/*
**	msql.h	-
**
**
** Copyright (c) 1993  David J. Hughes
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
**
** This software is provided "as is" without any expressed or implied warranty.
**
** ID = "$Id:"
**
*/



typedef	char	** m_row;

typedef struct field_s {
	char	*name,
		*table;
	int	type,
		length,
		flags;
} m_field;



typedef	struct	m_data_s {
	int	width;
	m_row	data;
	struct	m_data_s *next;
} m_data;

typedef struct m_fdata_s {
	m_field	field;
	struct m_fdata_s *next;
} m_fdata;



typedef struct result_s {
        m_data 	*queryData,
                *cursor;
	m_fdata	*fieldData,
		*fieldCursor;
	int	numRows,
		numFields;
} m_result;


#define	msqlNumRows(res) res->numRows
#define	msqlNumFields(res) res->numFields


extern	char msqlErrMsg[];
m_result *msqlListDBs(int sock);
m_result *msqlListTables(int sock);
m_result *msqlListFields(int sock,char*);
int msqlQuery(int sock,char* q);
void msqlDataSeek(m_result* handle,int offset);
void msqlFieldSeek(m_result* handle,int offset);
m_row	msqlFetchRow(m_result* handle);
m_field	*msqlFetchField(m_result* handle);
m_result *msqlStoreResult();
int msqlSelectDB(int sock,char* db);
int msqlConnect(char	*host);
void msqlClose(int sock);
void msqlFreeResult(m_result *result);

#define INT_TYPE	1
#define CHAR_TYPE	2
#define REAL_TYPE	3
#define IDENT_TYPE	4

#define NOT_NULL_FLAG   1
#define PRI_KEY_FLAG    2

#define IS_PRI_KEY(n)	(n & PRI_KEY_FLAG)
#define IS_NOT_NULL(n)	(n & NOT_NULL_FLAG)



