#include <a.out.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>

void
main(int argc, char *argv[])
{
 int fd;
 struct exec header;
 
 if (argc != 2)
   {
     fprintf(stderr, "Usage: %s file\n", argv[0]);
     exit(1);
   }
 
 fd = open(argv[1], O_RDWR);
 if (fd == -1)
   {
     perror("Can't open this file");
     exit(2);
   }
 if (read(fd,&header, sizeof(header)) != sizeof(header))
   {
     fprintf(stderr, "Can't read the header of %s\n", argv[1]);
     exit(3);
   }
 
 if (N_BADMAG(header))
   {
     fprintf(stderr, "This file is not executable.\n");
     exit(4);
   }
 
 N_SET_FLAGS(header, 0x40);
 
 if (lseek(fd,0,0) != 0L)
   {
     fprintf(stderr, "Can't lseek().\n");
     exit(5);
   }
   
 if (write(fd, &header, sizeof(header)) != sizeof(header))
   {
     fprintf(stderr, "Can't rewrite the header.\n");
     exit(6);
   }
   
 close(fd);
 exit(0);
}
 