#include <strings.h>
#include <stdio.h>
#include "insertor.h"
#include "utils.h"

u_char *text_bm;
u_char *second_text_bm;
u_int text_decoded = 0;
u_int second_text_decoded = 0;

void
init_text_bm()
{
 text_bm = (u_char*)xmalloc(text_len);
 second_text_bm = (u_char*)xmalloc(text_len);
 memset(text_bm, TBM_UNKNOWN, text_len);
 memset(second_text_bm, TBM_UNKNOWN, text_len);
}

void
show_text_bm()
{
  int val,i;
    
  for(i = 0; i < text_len; i++)
    {
      if ((i % 64) == 0)
          printf("\n%08X: ", i);
      val = text_bm[i];
      switch(val & (~(TBM_ALIGN | TBM_SYM | TBM_RELOC)))
        {
          case TBM_INSTR: putchar('i');
         		  break;
          case TBM_ENTRY: putchar('I');
          		  break;
          case TBM_LIT:   putchar('D');
          		  break;          		  
          default:	  putchar('?');
          		  break;
        }
    }
    putchar('\n');
}

#if 0
void
show_text_bm()
{
  int val,i;
  
  for(i = 0; i < text_len; i++)
    {
      val = text_bm[i];
      if (i < (text_len - 1) && val == text_bm[i+1])
        {
          printf("[%4x - ", i);
          while(i < text_len && val == text_bm[++i])
           ;
          i--;
          printf("%4x] ", i);
        }
      else
        printf(" %4x         ", i);
      switch(val & (~(TBM_ALIGN|TBM_SYM|TBM_RELOC)) )
        {
          case TBM_INSTR: printf("instruction\n");
         		  break;
          case TBM_ENTRY: printf("Beginning of an instruction\n");
          		  break;
          default:	  printf("%d\n", val);
          		  break;
        }
    }
}
#endif

void
save_text_bm()
{
 memcpy(second_text_bm, text_bm, text_len);
 second_text_decoded = text_decoded;
}

void
restore_text_bm()
{
 memcpy(text_bm, second_text_bm, text_len);
 text_decoded = second_text_decoded;
}