/****************************************************************************\
*                                                                            *
$Id: cim.h,v 1.3 1992/09/14 11:33:18 cim Exp $
*                                                                            *
*****************************************************************************/

/******************************************************************************
                                             Definition of runtime-constants */

#define __REALASDOUBLE 1

#ifndef __FILES
#define __FILES int *
#endif

#define __FALSE 0
#define __TRUE 1
#define __NULL 0L
#define __EOF (-1)

/* Executing must have the value 0 since it is not set */
#define __EXECUTING 0
#define __DETACHED 1
#define __TERMINATED 2
#define __RESUMED 3
#define __CONSTANT 1

#define __ACTS 1
#define __TEXT 3
#define __ARRAY 5
#define __THUNK 7

#define __FROM_START 0
#define __CURRENT_POS 1
#define __AT_END 2

#define __VALUE_THUNK 0
#define __VALUE_NOTHUNK 1
#define __ADDRESS_THUNK 2
#define __ADDRESS_NOTHUNK 3

#define __NOTEST 0
#define __WRITETEST 1
#define __READTEST 2
#define __READWRITETEST 3

#define __NOCONV 0
#define __INTREAL 1
#define __REALINT 2
#define __REALINTREAL 3

#define __RTPUTTEXTLENGTH 150
#define __RTPUTTEXTFORMATLENGTH 10
#define __RTPUTMAXN 100

/* Definition of kind */
#define __KNOKD   'N'
#define __KSIMPLE 'S'
#define __KARRAY  'A'
#define __KPROC   'P'
#define __KCLASS  'C'
#define __KBLOKK  'B'
#define __KPRBLK  'R'
#define __KFOR    'F'
#define __KINSP   'I'
#define __KCON    'O'
#define __KERROR  'E'

/* Definition of type */
#define __TNOTY   'N'
#define __TINTG   'I'
#define __TSHORT  'I'     /* S */
#define __TREAL   'R'
#define __TLONG   'R'     /* D */
#define __TBOOL   'B'
#define __TCHAR   'C'
#define __TLABEL  'L'
#define __TTEXT   'T'
#define __TREF    'P'
#define __TERROR  'E'

#define __NOSHARED  0
#define __SHARED    1

#define __NOAPPEND  0
#define __APPEND    1

#define __NOCREATE  0
#define __CREATE    1
#define __ANYCREATE 2

#define __READWRITE 0
#define __WRITEONLY 1
#define __READONLY  2

#define __NOREWIND  0
#define __REWIND    1

#define __NOPURGE   0
#define __PURGE     1

#define __READ 0
#define __WRITE 1
#define __SEEK 2

#define __BYTESIZE 8

/******************************************************************************
                                     Structures, unions and type definitions */

typedef union 
{
   long i;
   char c;
#ifdef __REALASDOUBLE
   double f;
#else
   float f;
#endif
   short s;
   long l;
   double d;
} __valuetype;

typedef struct
{
  void (*ment)();
  short ent;
}__progadr;

/* A prototype-object */

typedef struct __ptys __ptyp,*__pty;
struct __ptys
    {
        char  kind,plev;
        short blev,size;
        short ent;
        short fornest,connest;
        short naref,navirt;
        short *ref;
        __pty   *virt;
        __pty  *pref;
        void (*ment)();
        __progadr *virtlab;
    };


/* Head of a data-object */

typedef struct __dhs *__dhp;
typedef struct __dhs
  {
    __pty pp;
    __dhp gl,dl;
    short ex;
    char pm,dt;
    __dhp sl;
    void (*mex)();/* mex = exit til modul mex */
  } __dh;

/* Var parameter of type boolean, char, or text */
typedef struct
{
  __dhp bp;  /* Pointer to block to akt.par. */
  int ofs;   /* Relativ adress of akt.par   */
} __varpar;

/* Aritmetic var parameter */
typedef struct
{
  __dhp bp;  /* Pointer to block to akt.par. */
  int ofs;   /* Relativ adress of akt.par   */
  char conv; /* What kind of converting (integer, real) */
} __aritvarpar;

/* Ref var parameter */
typedef struct
{
  __dhp bp;   /* Pointer to block to akt.par. */
  int ofs;    /* Relativ adress of akt.par   */
  __pty q;    /* Pointer to prototype to strongest
	      /* qualification  on the access path */
  char conv;  /* When in test must be done */
} __refvarpar;


/* Formal prosedure parameter */
typedef struct
{
  __pty pp;
  __dhp psl;
} __forprocpar;

typedef struct
{
  __pty pp;
  __dhp psl;
  char conv;
} __aritprocpar;

typedef struct
{
  __pty pp;
  __dhp psl;
  char conv;
  __pty q;
} __refprocpar;

typedef union 
{
   __valuetype v;
   __dhp r;
} __val_or_ref;

/* Head of a stack-object */
typedef struct
  {
    __pty pp;
    __dhp gl,dl;
    short ex;
    char pm,dt,at; /* pm="ant ref", at="ant text", and dt="ant value" */
    short size;
  } __sh,*__shp;

/* A stack-object */
typedef struct
  {
    __sh h;
    __val_or_ref s[1];
  } __stk,*__stkp;

/* Head of a tekst-object */
typedef struct
{

   __pty pp;
   __dhp gl;
   char konstant;
   short size;
} __th,*__thp;

/* Tekst-object */
typedef struct
{
  __th h;
  char string[1];
}  __tobj,*__textref;

/* Tekst-variable */
typedef struct
{
    __textref obj;
    unsigned short length,pos,start;
} __txt, *__txtvp;

/* Notext */
typedef struct
{
  __txt tvar;
} __notext;

/* Head of an array-object */
typedef struct 
{
   __pty pp;
   __dhp gl;
   int size;
   short dim;
   char type;
} __ah,*__ahp;

/* Upper and lower limit for each dimension */
typedef struct
{
   int low,size;
} __arrlimit;

/* Head of an array-object */
typedef struct
{
   __ah h;
   __arrlimit limits[1];
} *__arrp;

/* Name transmission */
typedef struct 
{
  void (*ment)();
  short ent;
} __thunkorprogadr;

typedef struct
{
  void (*ment)();
  short ent;
} __thunkadr;

typedef union
{
  int ofs;        /* Offset adress for a variable, bp is base adress   */
  int i;          /* Valuie for a constant aktual name par */
#ifdef __REALASDOUBLE
  double f;
#else
  float f;
#endif
  char c;
  short s;
  long l;
  double d;
  __dhp r;
} __ofsorvalue;

typedef struct
{
  __dh h;
  char conv;     /* What kind of conversions have to be performed	   */
  __pty q;       /* Strongest qualification on the access path.		   */
  char ftype;    /* Formal type of an aritmetick name.                     */
  char writeaccess;/* TRUE or FALSE. For thunks that is computing adresses.*/
                 /* Should the thunk return the adress or an value.        */
}  __thunk,*__thunkp;

typedef struct
{
   __dhp sl;
   __thunkadr adr;
   __dhp bp;
   __ofsorvalue v;
   char namekind;
} __simplenamepar;

typedef struct
{
   __simplenamepar h;
} __charboolnamepar;

typedef struct
{
   __simplenamepar h;
   char conv;
} __aritnamepar;

typedef struct
{
   __simplenamepar h;
   __pty q;
   char conv;
} __refnamepar;

typedef struct
{
   __simplenamepar h;
   __txtvp tp;
} __textnamepar;

typedef struct
{
   __dhp sl;
   __thunkadr adr;
   __pty pp;                    /* Pointer to the procedures prototype    */
   __dhp psl;                   /* Procedures static environment          */
   char namekind;
} __procname;

typedef struct
{
   __procname h;
} __simpleprocnamepar;

typedef struct
{
   __procname h;
   char conv;
} __aritprocnamepar;

typedef struct
{
  __procname h;
   char conv;
  __pty q;
} __refprocnamepar;

typedef struct
{
   __dhp sl;
   __thunkorprogadr adr;
   __dhp ob;
   int swv;
   char namekind;
} __labelnamepar;

/* Label var and standard transmitted parameter or */
/* a name, var or standard transmitted switch parameter */
typedef struct   /* No thunk for switch parameter by name */
{
   __progadr adr;
   __dhp ob;
} __labelswitchpar;

typedef struct
{
   __dhp sl;
   __thunkadr adr;
   __arrp ap;
   char namekind;
} __arraynamepar;

typedef struct
{
  char *fil;
  long line,fromline;
} __map;

/******************************************************************************
                                                          External variables */

/* Inline error messages */
extern char *__errnone, *__errlim, *__errarr, *__errswitch, 
            *__errqual, *__errvirt, *__errbound;

/* Program counter */
extern int __lgoto;
extern void (*__mgoto)();
extern void __main_modul();
extern void (*__modul)();
extern int __lreturn;
extern void (*__mreturn)();
extern long __vreturn;

/* switch */
extern int __swv;

/* Local-block, parameter-block, and static environm,ent to rcp(p)() */
extern __dhp __lb,__pb;
extern __dhp __sl; /* Can't be a parameter since GBC must update it */

/* Garbage collections statistics */
extern int __gc; 
extern double __gbctime;

/* Return value */
extern long __ev;
#ifdef __REALASDOUBLE
extern double __ef;
#else
extern float __ef;
#endif
extern char __ec;
extern __dhp __er;
extern __txt __et;

/* Stack for evaluation of expressions */
                                                /* 900526 (1)   */
extern __valuetype  __v[];
extern __dhp __r[];
extern __txt __t[];

extern long __as; /* Antall p} h.h.v ref og text stakken */

/* Pointer to current array-object */
extern __arrp __ap;

/* (indeks - lower bound) for the actual dimensions to an array object */
extern int __h[];

extern __pty __pp;         /* Prototyp pointer */
extern __dhp __bp;         /* In test */
extern __refvarpar *__vrp; /* In test for var par */
extern __aritvarpar *__vvp;/* Convertion between real and integer */
extern __refnamepar *__nrp; /* In test for name par */
extern __aritnamepar *__nvp;/* Convertion between real and integer for name */
extern char __conv;
extern char __currentlowten,
            __currentdecimalmark;

extern __notext __tk0;  /* tk0 == notext */
extern char __ctab[3][4];

extern long __poolsize,__maxsize;
extern char __dynsize,__chpoolsize;

extern char *__ctext;

extern char *__nullstr;

extern char *__progname;
extern long __argc;
extern long __argv;
extern long __rargc();
extern long __rargv();

extern __map *__curent_map;

extern long __line;

extern long __lines_per_page;

extern __dhp __sto,__max,__min,__fri;
extern __dh __niu,__nil;

extern __dhp __p;

/******************************************************************************
                                                         Outermost block and
							 the file classes    */

/* Outermost block */
typedef struct
{
  __dh h;
  __dhp c1,c2;
} __bs0FILE,__bs0;
extern __bs0FILE __blokk0;
extern __bs0FILE *__bp0FILE;
extern short __rl0FILE[];
extern __pty __pl0FILE[];
extern __ptyp __p0FILE;

/* Class file */
typedef struct
{
  __dh h;
  __txt filename;
  __FILES *file;
  char open;
  char shared,append,create,readwrite,re_wind,purge;
} __bs1FILE,__bs1;
extern __pty __pl1FILE[];
extern __ptyp __p1FILE;

/* File class imagefile */
typedef struct
{
  __bs1FILE s;
  __txt IMAGE;
} __bs2FILE,__bs2;
extern __bs2FILE *__bp2FILE;
extern short __rl2FILE[];
extern __pty __pl2FILE[];
extern __ptyp __p2FILE;

/* Imagefile class outfile */
typedef struct
{
  __bs2FILE s;
 } __bs3FILE,__bs3;
extern __pty __pl3FILE[];
extern __ptyp __p3FILE;

/* Imagefile class infile */
typedef struct
{
  __bs2FILE s;
  char endfile;
} __bs4FILE,__bs4;
extern __pty __pl4FILE[];
extern __ptyp __p4FILE;
extern __bs4FILE __sysin;

/* Imagefile class directfile */
typedef struct
{
  __bs2FILE s;
  long loc,maxloc,minwriteloc,imagelength;
  char endfile,locked,lastop,writeonly;
} __bs5FILE,__bs5;
extern __pty __pl5FILE[];
extern __ptyp __p5FILE;

/* Outfile class printfile */
typedef struct
{
  __bs3FILE s;
  long line,lines_per_page,spacing,page;
} __bs6FILE,__bs6;
extern __pty __pl6FILE[];
extern __ptyp __p6FILE;
extern __bs6FILE __sysout;
extern __bs6FILE __syserr;

/* File class bytefile  */
typedef struct
{
  __bs1FILE s;
  char endfile,bytesize;
} __bs7FILE,__bs7;
extern __pty __pl7FILE[];
extern __ptyp __p7FILE;

/* Bytefile class inbytefile */
typedef struct
{
  __bs7FILE s;
  char endfile;
}  __bs8FILE,__bs8;
extern __pty __pl8FILE[];
extern __ptyp __p8FILE;

/* Bytefile class outbytefile */
typedef struct
{
  __bs7FILE s;
} __bs9FILE,__bs9;
extern __pty __pl9FILE[];
extern __ptyp __p9FILE;

/* Bytefile class directbytefile */
typedef struct
{
  __bs7FILE s;
  long loc,maxloc,minwriteloc;
  char locked,lastop,writeonly;
} __bs10FILE,__bs10;
extern __pty __pl10FILE[];
extern __ptyp __p10FILE;

/******************************************************************************
                                                         External declaration
							 of run-time routines
							 that do not return 
							 int                 */

 /* RTCK.C */
 extern __dhp __rca();
 extern __dhp __ralloc();
 extern char __rin();
 extern char __rrin();
 extern char __ris();
 extern char __rgetav();
 extern char __rgetcbv();
 extern char __rgetrv();
 extern char __rgettv();
 extern char __rgetproc();
 extern char __rgetlab();
 extern char __rgeta();
 extern char __rgetsa();

/* RTBASICIO.C */
 extern __dhp __rsysin();
 extern __dhp __rsysout();
 extern __dhp __rsyserr();

/* ENVIRONMENT.C */

/* Basic operations */
 extern double __rabsr();
 extern long __rabsi();
 extern long __rsigni();
 extern long __rsignr();
 extern long __rmod();
 extern long __rrem();
 extern long __rentier();
 extern long __rintrea();
#if __REALASDOUBLE
 extern double __raddepsilon();
 extern double __rsubepsilon();
#else
 extern float __raddepsilon();
 extern float __rsubepsilon();
#endif
 extern long __rlowerbound();
 extern long __rupperbound();

/* Power functions */
 extern long __rpowii();
 extern double __rpowri();
 extern double __rpow();

/* Text utilities */
 extern char __rchar();
 extern char __risochar();
 extern long __rrank();
 extern long __risorank();
 extern char __rdigit();
 extern char __rletter();
 extern char __rlowten();
 extern char __rdecimalmark();

/* Mathematical functions */
 extern double __rsqrt();
 extern double __rsin();
 extern double __rcos();
 extern double __rtan();
 extern double __rarcsin();
 extern double __rarccos();
 extern double __rarctan();
 extern double __rarctan2();
 extern double __rsinh();
 extern double __rcosh();
 extern double __rtanh();
 extern double __rln();
 extern double __rlog10();
 extern double __rexp();
 extern double __rcotan();

/* Extremum functions */
 extern void __rmint();
 extern char __rminc();
 extern long __rmini();
 extern double __rminr();
 extern void __rmaxt();
 extern char __rmaxc();
 extern long __rmaxi();
 extern double __rmaxr();

/* Environmental enquiries
 extern txtvp __rsimulaid();

/* Random drawing */
 extern char __rdraw();
 extern long __rrandint();
 extern double __runiform();
 extern double __rnormal();
 extern double __rnegexp();
 extern long __rpoisson();
 extern double __rerlang();
 extern long __rdiscrete();
 extern double __rlinear();
 extern long __rhistd();

/* Calendar and timing utilities */
 extern __txtvp __rdatetime();
 extern double __rcputime();
 extern double __rclocktime();

/* RTTEXT.C */
 extern char __rtconstant();
 extern long __rtstart();
 extern long __rtlength();
 extern char __rtmore();
 extern char __rtgetchar();
 extern double __rtgetreal();
 extern long __rtgetfrac();
 extern long __rtgetint();
 extern long __rtputint();
 extern long __rtputfix();
 extern long __rtputreal();
 extern long __rtputfrac();
 extern long __rtpos();
 extern __txtvp __rtmain();
 extern __txtvp __rtsub();
 extern __txtvp __rtstrip();
 extern __txtvp __rcopy();
 extern __txtvp __rblanks();
 extern __txtvp __rconc();
 extern __txtvp __rtextvalassign();
 extern __txtvp __rtextassign();
 extern char __reqrtext();
 extern char __reqrtext();
 extern char __reqtext();
 extern char __rlttext();
 extern char __rletext();

 extern void __rtputchar();
 extern void __rtsetpos();

/* FILESYSTEM.C */

 extern long __rfsize();

/* Class file */
 extern __txtvp __rfilename();
 extern char __risopen();
 extern char __rsetaccess();

/* File class imagefile */
 extern long __rpos();
 extern char __rmore();
 extern long __rlength();

/* Imagefile class infile */
 extern char __riendfile();
 extern char __riopen();
 extern char __riclose();
 extern char __riinrecord();
 extern char __riinchar();
 extern char __rilastitem();
 extern long __riinint();
 extern double __riinreal();
 extern long __riinfrac();
 extern __txtvp __riintext();

/* Imagefile class outfile */
 extern char __roopen();
 extern char __roclose();

/* Outfile class printfile */
 extern long __rpline();
 extern long __rppage();
 extern char __rpopen();
 extern char __rpclose();
 extern long __rplinesperpage();

/* Imagefile class directfile */
 extern long __rdlocation();
 extern char __rdendfile();
 extern char __rdlocked();
 extern char __rdcheckpoint();
 extern char __rdunlock();
 extern long __rdlock();
 extern char __rdopen();
 extern char __rdclose();
 extern long __rdlastloc();
 extern long __rdmaxloc();
 extern char __rddeleteimage();

/* File class bytefile */

 extern long __rbytesize();

/* Bytefile class inbytefile */
 extern long __ribinbyte();
 extern char __ribendfile();
 extern char __ribopen();
 extern char __ribclose();

/* Bytefile class outbytefile */
 extern char __robopen();
 extern char __robclose();

/* Bytefile class directbytefile */
 extern long __rdblocation();
 extern long __rdbmaxloc();
 extern char __rdblocked();
 extern long __rdblock();
 extern char __rdbunlock();
 extern char __rdbopen();
 extern char __rdbclose();
 extern long __rdblastloc();

/* Environment to C */
 extern char *__rcopytexttoc();
 extern char *__raddroffirstchar();
 extern char *__raddroffirstelem();
 extern char **__rcopytextarrtoc();
 extern char *__rcopyarrtoc();

