/*
 ****************************************************************************
 *
 *	File:	multipass_cb.C
 *
 *	Function(s):
 *
 *	Description:
 *		multipass callback stubs, generated by the OI UIB.
 *
 *	RCSid = "$Id: multipass_cb.C,v 1.1.1.1 1993/06/10 17:15:00 mth Exp $"
 *
 ****************************************************************************
 */
#include <OI/oi.H>
#include "multipass.H"
#include "multipass_bd.H"

/*
 *	The following definitions are generated and read by the user
 *	interface builder to simplify the process of generating prototype
 *	stubs.
 *
 *	The user interface builder will ONLY preserve prototype stubs placed
 *	above the dividing line (below).  If you need to include additional
 *	header files to ensure that your program compiles, please include 
 *	them in
 *		multipass.H
 *
 *	CAVEAT
 *		These definitions ensure that a prototype stub is not
 *		regenerated.   PLEASE leave the definition here
 *		even if you move the stub to another file.
 *	
 */

extern void setcolor (OI_menu_cell *, void *, OI_number);


/* End of Function Declarations -- Protected User Code begins at next line */
/*
 ******************************************************************************
 *
 *	Function Name:	setcolor
 *
 *		Description: 
 *			A cells action routine is invoked when the mouse
 *			pointer is over the cell and the SELECT mouse button
 *			is clicked.  Note that this implies the function is
 *			called when turning cells off as well as on, in
 *			persistant menus (excl, poly).
 *
 *		Returns:
 *			nothing
 * 
 *		Side Effects:
 *			none.
 *
 *		Warnings:
 *			none.
 *
 ******************************************************************************
 */
void
setcolor (
	OI_menu_cell	*cellp,		// (input) ptr to cell which fired
	void		*argp,		// (input) ptr to user supplied argument
	OI_number	)	// (input) mouse button used to fire cell
{
/*	External Variables */
/*	External Procedures: */
/*	Local Variables: */
/*
	Procedure:
*/
	if (cellp->selected())
		((OI_d_tech*)argp)->set_bkg_color( cellp->name() );
	return ;
}

