#include <OI/oi.H>			/* Internat.C */
#include <strings.h>
	/*
	*	The function StartNewDemo must be defined before we define the
	*	static cell definitions, else the compiler complains.
	*/
	void StartNewDemo(OI_menu_cell *);
	/* 
	*	These are the cell definitions for each cell in the application.
	*	They are in English, the other langauges are specified in 
	*	resource files.  Each cell has a name for identification, and an
	*	English text string for the default label.  
	*/
	OI_cell_spec demo_cells[] = {
		{"english", "Start English Demo", (OI_action_fnp)StartNewDemo},
		{"german", "Start German Demo", (OI_action_fnp)StartNewDemo},
		{"spanish", "Start Spanish Demo", (OI_action_fnp)StartNewDemo},
		{"quit", "Quit", (OI_action_fnp)OI_end_interaction},
	};
	
	OI_cell_spec num_cells[] = {
		{"one", "One"},
		{"two", "Two"},
		{"three", "Three"},
	};

main (int argc, char **argv)
{
	OI_connection	*conp;			/* connection to the server */
	OI_app_window	*wp;		/* enclosing app window */
	OI_button_menu  *mp;           /* control menu */

	if (conp = OI_init(&argc, argv, "Internat", "Internat"))
	    {
		wp = oi_create_app_window("mainWin", 1, 1, "International Demo");
		wp->set_layout(OI_layout_column);

		mp = oi_create_button_menu("languageMenu", OI_count(demo_cells), demo_cells, OI_vertical, NULL);
		mp->layout_associated_object(wp, 1, 1, OI_active);
		mp = oi_create_button_menu("numMenu", OI_count(num_cells), num_cells, OI_vertical, NULL);
		mp->layout_associated_object(wp, 2, 1, OI_active);

		wp->set_associated_object(conp->root(), OI_def_loc, OI_def_loc, OI_active);
		OI_begin_interaction();
	}

	OI_fini();
}

void StartNewDemo(OI_menu_cell *cell)
{

	char command[256];	/* Character string for forked command */
	char **common_argv;
	int i, common_argc;
	
	 /* Create the command string for invoked command.
	 * Append OI_common_argv to the command string so that the
	 * invoked process has the same attributes as the original one.
	 *	
	 * Also, invoke command with the correct -language flag to
	 * find the correct text strings file for the desired language.
	 */

	strcpy(command, "Internat ");
	
	common_argc = OI_common_argc();
	common_argv = OI_common_argv();

	for (i = 0; i < common_argc; i++) {
		strcat(command, common_argv[i]);
		strcat(command, " ");
	}
	
	strcat(command, "-config Internat.cf -language ");
	strcat(command, cell->name());
	strcat(command, " &");

	OI_fork(command);		// Invoke the command
}
