#include <math.h>
#include <OI/oi.H>				/* Panner.C */

	static	GC			draw_gc = 0;

int main (int argc, char **argv)
{
		void			mov_curve (OI_panner*,void*,OI_scroll_event,long,long);
		void			disp_mini_curve(OI_panner *pp, void *bp, XExposeEvent *ep);
		void			expose(OI_d_tech*,void*,const XEvent*);
		OI_connection		*conp;
		OI_app_window		*wp;
		OI_panner		*pp;
		OI_box			*bp;
	
	if (conp = OI_init(&argc,argv,"Panner")) {
		wp = oi_create_app_window("main",1,1,"Panner");
		wp->set_layout(OI_layout_column);
		bp = oi_create_box("curve_box",300,120);
		bp->layout_associated_object(wp,1,2,OI_active);
		pp = oi_create_panner("panner",90,60,&mov_curve,bp,&disp_mini_curve);
		pp->set_span(300,200);
		pp->set_view(100,100);
		pp->layout_associated_object(wp,1,1,OI_active);
		bp->set_expose(expose,pp);
		wp->set_associated_object(wp->root(),OI_def_loc,OI_def_loc,OI_active);
		OI_begin_interaction();
	}
}
void disp_curve(OI_panner *pp, OI_d_tech *objp, long start_x_unit, long end_x_unit)
{
		long		i;
		int		x1,y1,x2,y2;
		XGCValues	gcv;
		double		damping;

	if (!draw_gc) {
		gcv.foreground = objp->fg_pixel();
		gcv.background = objp->bkg_pixel();
		draw_gc = XCreateGC(objp->display(),objp->X_window(),GCForeground|GCBackground,&gcv);
	}
	x1 = (int)(objp->size_x()/pp->view_x()*(start_x_unit - pp->view_psn_x()));
	damping = (pp->span_x() - 0.1*(9*start_x_unit+1))/(pp->span_x() - 1);
	y1 = (int)(damping*sin(double(start_x_unit)/10.0)*pp->span_y()/2.0 + pp->span_y()/2.0);
	y1 = (int)(objp->size_y()/pp->view_y()*(y1 - pp->view_psn_y()));
	for (i = start_x_unit + 1 ; i <= end_x_unit ; i++) {
		x2 = (int)(objp->size_x()/pp->view_x()*(i - pp->view_psn_x()));
		damping = (pp->span_x() - 0.1*(9*i+1))/(pp->span_x() - 1);
		y2 = (int)(damping*sin(double(i)/10.0)*pp->span_y()/2.0 + pp->span_y()/2.0);
		y2 = (int)(objp->size_y()/pp->view_y()*(y2 - pp->view_psn_y()));
		XDrawLine(objp->display(),objp->X_window(),draw_gc,x1,y1,x2,y2);
		x1 = x2;
		y1 = y2;
	}
	return;
}
void disp_mini_curve(OI_panner *pp, void*, XExposeEvent*)
{

		long		i;
		int		x1,y1,x2,y2;
		XGCValues	gcv;
		double		damping;
		long		start_x_unit,end_x_unit;
		double		ratio,y_adjust;

	if (!draw_gc) {
		gcv.foreground = pp->fg_pixel();
		gcv.background = pp->bkg_pixel();
		draw_gc = XCreateGC(pp->display(),pp->X_window(),GCForeground|GCBackground,&gcv);
	}
	start_x_unit = pp->paint_org_x();
	end_x_unit = pp->paint_width();
	ratio = (double)(pp->span_x())/(end_x_unit - start_x_unit);
	y_adjust = (pp->paint_height() + pp->paint_org_y())/2.0;
	x1 = (int)start_x_unit;
	damping = (pp->paint_width() - 0.1*(9*start_x_unit+1))/(pp->paint_width() - 1);
	y1 = (int)(damping*sin(double(ratio*0.0)/10.0)*y_adjust + y_adjust);
	for (i = start_x_unit + 1 ; i <= end_x_unit ; i++) {
		x2 = (int)i;
		damping = (pp->paint_width() - 0.1*(9*i+1))/(pp->paint_width() - 1);
		y2 = (int)(damping*sin(double(ratio*(i - start_x_unit))/10.0)*y_adjust + y_adjust);
		XDrawLine(pp->display(),pp->X_window(),draw_gc,x1,y1,x2,y2);
		x1 = x2;
		y1 = y2;
	}
	return;
}
void expose(OI_d_tech*, void *argp, const XEvent *ep)
{
		OI_panner   *pp;
	pp = (OI_panner*)argp;
	if ((ep->type == Expose) && (ep->xexpose.count==0))
		disp_curve(pp,pp->app_window()->subobject("curve_box"),pp->view_psn_x(),pp->view_psn_x() + pp->view_x());
	else if ((ep->type == GraphicsExpose) && (ep->xgraphicsexpose.count==0))
		disp_curve(pp,pp->app_window()->subobject("curve_box"),pp->view_psn_x(),pp->view_psn_x() + pp->view_x());
}
void mov_curve (OI_panner *pp, void *argp, OI_scroll_event, long, long)
{
		OI_box	*bp;

		bp = (OI_box*)argp;
		if (pp->app_window()) {
			XClearWindow(bp->display(),bp->X_window());
			disp_curve(pp,bp,pp->view_psn_x(),pp->view_psn_x() + pp->view_x());
		}
		return;
}
