#include <OI/oi.H>		/* AnimGlyph.C */

	class	AnimGlyph : public OI_glyph {		// class AnimGlyph definition
			long		numpix;		// number of pixmaps
			Pixmap		*pmp;		// ptr to pixmaps
		 public:
					AnimGlyph( char*, char*, char* ) ;
			void		btn_animate(OI_menu_cell*, void*, OI_number) ;
		} ;

AnimGlyph::AnimGlyph(					// constructor for AnimGlyph
			char		*usr_namp,
			char		*perm_filp,
			char		*animate_filp)
			: OI_glyph(usr_namp,perm_filp,perm_filp,NULL,OI_pic_mask,OI_no)
{
	numpix = conp->uniform_pixmap_series(&pmp,animate_filp);
}

void AnimGlyph::btn_animate(OI_menu_cell*, void*, OI_number)	// AnimGlyph member function btn_animate
{
	animate(100,numpix,pmp,OI_animate_single) ;
	return ;
}

int main (int argc, char **argv)
{
			OI_connection	*conp;
			OI_app_window	*wp;
			OI_menu		*mp;
			OI_menu_cell	*mcp;
			AnimGlyph	*aniglyp;

		static	OI_cell_spec	cells[] = {
			{"animate","Animate"},
			}; 
	
	if (conp = OI_init(&argc,argv,"AnimGlyph")) {
		wp = oi_create_app_window("main",1,1,"AnimGlyph");
		wp->set_layout(OI_layout_row,20,20);
		mp = oi_create_button_menu("menu",OI_n_cells(cells),&cells[0],OI_vertical);
		mp->layout_associated_object(wp,10,10,OI_active);
		aniglyp = new AnimGlyph("glyph","../bitmaps/bird1.bm","../bitmaps/bird@.bm");
		aniglyp->set_gravity(OI_grav_center);
		aniglyp->layout_associated_object(wp,1,1,OI_active);
		mcp = (OI_menu_cell*)mp->subobject("animate");
		mcp->change_action(aniglyp,(OI_action_memfnp)&AnimGlyph::btn_animate);
		wp->set_associated_object(wp->root(),OI_def_loc,OI_def_loc,OI_active);
		OI_begin_interaction();
	}
}
