#include <OI/oi.H>			/* Gauge.C */

int main(int argc, char** argv)
{
		void			set_the_gauge(void*);
		void			add_obj(OI_menu_cell*,void*,OI_number);

		OI_connection		*conp;
		OI_app_window		*wp;
		OI_gauge		*gp;
		OI_menu			*mp;
		OI_menu_cell		*cellp;

		static	OI_cell_spec		cells[] = {
				{"add","Add New Object",add_obj},
				{"exit","Exit",(OI_action_fnp)OI_end_interaction},
			};
	if (conp = OI_init(&argc,argv,"Gauge")) {
		wp = oi_create_app_window("main",1,1,"Gauge");
		wp->set_layout(OI_layout_column);
		mp = oi_create_button_menu("main_menu",OI_count(cells),&cells[0],OI_horizontal);
		wp->set_main_menu(mp);
		cellp = (OI_menu_cell*)(mp->subobject("add"));
		cellp->change_arg(wp);
		gp = oi_create_gauge("gauge",100,OI_vertical,10,0,"Number of Children: ",OI_gauge_ends_none,NULL,NULL,OI_yes,6,OI_gauge_ticks_all);
		gp->layout_associated_object(wp,(OI_number)0,(OI_number)0,OI_active);
		OI_add_timeout(200,set_the_gauge,gp);
		wp->set_associated_object(wp->root(),OI_def_loc,OI_def_loc,OI_active);
		OI_begin_interaction();
		OI_fini();
	}
}

void	add_obj(OI_menu_cell*, void *argp, OI_number)
{
		OI_box	*bp;
	static	int	siz = 10;
	static	int	column = 0;

	siz++;
	bp = oi_create_box("new_box",siz,siz);
	if (++column > 10)
		column = 1;
	bp->layout_associated_object((OI_d_tech*)argp,column,siz,OI_active);
	return;
}

void	set_the_gauge(void *argp)
{
	OI_gauge	*gp;
	
	gp = (OI_gauge*)argp;
	if (gp->app_window()->num_props() > gp->maximum()) 
		gp->set_span(gp->maximum() + 11);
	gp->set_value(gp->app_window()->num_props());
	return;
}
