#include <stdio.h>			/* Sender.C */
#include <stdlib.h>
#include <sysent.h>
#include <OI/oi.H>

#include "paint.xbm"
#include "nopaint.xbm"
#include "paintmask.xbm"
#include "nopaintmask.xbm"

#include "target.xbm"
#include "targetmask.xbm"
#include "targetok.xbm"
#include "targetokmask.xbm"

// various cursors we'll use
Cursor	nopaint_cursor;
Cursor	paint_cursor;
Cursor	target_cursor;
Cursor	targetok_cursor;

// translations we'll put on objects to get things started
static char *dragTrans = "#override \n\
	<Btn1Down>:	drag_start()\n";

// text and filename that we'll drag via the "DRAG ME" object
#define TEXT		"This is text to drag and drop."
#define FNAME		"dragdrop.txt"

// **********************************************************************************
// color_drag_preview is the drag preview callback for the color boxes
// It changes the color of the pointer to be the same as the box being dragged

void color_drag_preview(
	OI_d_tech	*dtp,		// the object being dragged
	void		*,		// argp
	OI_dnd_operation op,		// the operation being previewed
	long,				// the X root coordinate of the pointer
	long)				// the Y root coordinate of the pointer
{
	XColor		other;
	XColor		color;

	switch (op) {
		case OI_dnd_start: // we started the drag,recolor the cursor
			color.pixel = dtp->bkg_pixel();
			color.flags = DoRed|DoGreen|DoBlue;
			XQueryColor(dtp->display(),dtp->connection()->colormap(),&color);
			other.red = ~0;
			other.green = ~0;
			other.blue = ~0;
			other.flags = DoRed|DoGreen|DoBlue;
			XRecolorCursor(dtp->display(),paint_cursor,&color,&other);
			XRecolorCursor(dtp->display(),nopaint_cursor,&color,&other);
			break;
		case OI_dnd_done: // the drag operation is finished
			break;
		case OI_dnd_motion: // the pointer moved during the drag
			break;
		case OI_dnd_enter: // the pointer entered a drop site
			// we specified two different cursors when we did the allow_drag() so
			// we don't need to do anything when we see enter and leave operations
			break;
		case OI_dnd_leave: // the pointer left a drop site
			break;
	}
}

// **********************************************************************
// Make a drag-source box with a unique background color

OI_box *make_color_box(
	OI_connection	*conp,		// our connection to the server
	const	char	*name,		// the name of the box
	const	char	*background)	// the background color of the box
{
	OI_box		*box;
	PIXEL		color;
	Atom		atoms[2];

	box = oi_create_box(name,20,20);  // create the box
	// the following two lines will eventually not be needed
	box->set_bvl_width(0);
	box->set_bdr_width(1);
	box->allow_drag(nopaint_cursor,paint_cursor); // make the box a draggable object

	// setup the drag_preview callback so we can change the color of
	// the cursor when the drag starts
	box->set_drag_preview(color_drag_preview);

	// put some translations on to get the drag started
	box->override_translations(dragTrans);

	box->set_bkg_color(background);  // color the box

	// setup the selection_name atoms that the box can convert
	atoms[0] = conp->atom("BACKGROUND");
	atoms[1] = None;
	box->set_selection_targets(atoms);

	// setup the selection data that will be used when the drop happens
	color = box->bkg_pixel();
	box->set_selection_data(conp->atom("BACKGROUND"),conp->atom("PIXEL"),&color,1,32);

	return (box);
}

// ********************************************************************
// Create the drag and drop cursors

void make_cursors(
	OI_connection	*conp)	// our connection to the server
{
	Pixmap		targetok,targetokmask;
	Pixmap		target,targetmask;
	Pixmap		paint,paintmask;
	Pixmap		nopaint,nopaintmask;


	// First create the cursor for the "DRAG ME" object
	// Create the following pixmaps
	//	targetok     - the cursor image when over a drop site
	//	targetokmask - the mask for the above cursor
	//	target       - the cursor image when not over a drop site
	//	targetmask   - the mask for the above cursor
	targetok = XCreateBitmapFromData(conp->display(),conp->root()->X_window(),targetok_bits,targetok_width,targetok_height);
	targetokmask = XCreateBitmapFromData(conp->display(),conp->root()->X_window(),targetokmask_bits,targetok_width,targetok_height);
	target = XCreateBitmapFromData(conp->display(),conp->root()->X_window(),target_bits,target_width,target_height);
	targetmask = XCreateBitmapFromData(conp->display(),conp->root()->X_window(),targetmask_bits,target_width,target_height);

	// Now create the cursors using OI_connection::make_cursor()
	targetok_cursor = conp->make_cursor(targetok,targetokmask,targetok_x_hot,targetok_y_hot);
	target_cursor = conp->make_cursor(target,targetmask,target_x_hot,target_y_hot);

	// After making the cursors, we can free the pixmaps
	XFreePixmap(conp->display(),targetok);
	XFreePixmap(conp->display(),targetokmask);
	XFreePixmap(conp->display(),target);
	XFreePixmap(conp->display(),targetmask);

	// Now create the "paintbrush" cursors for the color boxes
	// Create the following pixmaps
	//	paint       - the cursor image when over a drop site
	//	paintmask   - the mask for the above cursor
	//	nopaint     - the cursor image when not over a drop site
	//	nopaintmask - the mask for the above cursor
	paint = XCreateBitmapFromData(conp->display(),conp->root()->X_window(),paint_bits,paint_width,paint_height);
	paintmask = XCreateBitmapFromData(conp->display(),conp->root()->X_window(),paintmask_bits,paint_width,paint_height);
	nopaint = XCreateBitmapFromData(conp->display(),conp->root()->X_window(),nopaint_bits,paint_width,paint_height);
	nopaintmask = XCreateBitmapFromData(conp->display(),conp->root()->X_window(),nopaintmask_bits,paint_width,paint_height);

	// Now create the cursors using OI_connection::make_cursor()
	paint_cursor = conp->make_cursor(paint,paintmask,paint_x_hot,paint_y_hot);
	nopaint_cursor = conp->make_cursor(nopaint,nopaintmask,paint_x_hot,paint_y_hot);

	// After making the cursors,we can free the pixmaps
	XFreePixmap(conp->display(),paint);
	XFreePixmap(conp->display(),paintmask);
	XFreePixmap(conp->display(),nopaint);
	XFreePixmap(conp->display(),nopaintmask);
}

// *****************************************************************************
// This callback actually deletes the "WILL DELETE" object after it is dropped

OI_bool selection_convert(
		OI_d_tech	*objp,
		void		*,
	const	XEvent		*ep)
{
		OI_bool		ret;

	ret = OI_no;
	if (ep->xselectionrequest.target == objp->connection()->atom("DELETE")) {
		XChangeProperty(objp->display(),ep->xselectionrequest.requestor,
			ep->xselectionrequest.property,objp->connection()->atom("INTEGER"),
			32,PropModeReplace,NULL,0);
		ret = OI_yes;
		objp->delete_all_delayed();
	}
	return(ret) ;
}

// *********************************************************************************

main (int argc,char **argv)
{
	OI_connection	*conp;
	OI_app_window	*app;
	OI_box		*box;
	OI_static_text	*st;
	int		row;
	char		buff[20];
	int		siz_txt,siz_fnam;
	char		hname[256];
	Atom		atoms[10];
	int		i;

	if ((conp = OI_init(&argc,argv,"Sender","Sender")) == NULL) {
		fprintf(stderr,"%s: OI_init failed\n",argv[0]);
		exit(1);
	}

	row = 0;
	app = oi_create_app_window("app_window",200,200,"Sender");
	app->set_layout(OI_layout_row);

	// create the cursors we'll use during drag and drop operations
	make_cursors(conp);
	// create the "DRAG ME" static text object
	st = oi_create_static_text("st","DRAG ME");
	// get the size of the text and the hostname
	siz_txt = strlen(TEXT);
	siz_fnam = strlen(FNAME);
	gethostname((char*)hname,255);

	// set the selection data that this object can send through a drop
	st->set_selection_data(conp->atom("FILE_NAME"),conp->atom("STRING"),FNAME,siz_fnam,8);
	st->set_selection_data(conp->atom("STRING"),conp->atom("STRING"),TEXT,siz_txt,8);
	st->set_selection_data(conp->atom("LENGTH"),conp->atom("INTEGER"),&siz_txt,1,32);
	st->set_selection_data(conp->atom("HOST_NAME"),conp->atom("STRING"),hname,strlen(hname),8);

	// setup the selection_name that it can convert
	i = 0;
	atoms[i++] = conp->atom("FILE_NAME");
	atoms[i++] = conp->atom("STRING");
	atoms[i++] = conp->atom("LENGTH");
	atoms[i++] = conp->atom("HOST_NAME");
	atoms[i] = None;
	st->set_selection_targets(atoms);

	// disallow_cut_paste so it doesn't grab out mouse button press
	st->disallow_cut_paste();
	// make the object draggable
	st->allow_drag(target_cursor,targetok_cursor);
	// put some drag translations on the object
	st->override_translations(dragTrans);
	// associate the object to the app_window
	st->layout_associated_object(app,0,row++,OI_active);

	// create the "WILL DELETE" static text object
	st = oi_create_static_text("st","WILL DELETE");

	// set the selection data that this object can send through a drop
	st->set_selection_data(conp->atom("FILE_NAME"),conp->atom("STRING"),FNAME,siz_fnam,8);
	st->set_selection_data(conp->atom("STRING"),conp->atom("STRING"),TEXT,siz_txt,8);
	st->set_selection_data(conp->atom("LENGTH"),conp->atom("INTEGER"),&siz_txt,1,32);
	st->set_selection_data(conp->atom("HOST_NAME"),conp->atom("STRING"),hname,strlen(hname),8);
	st->set_selection_convert(selection_convert);

	// setup the selection_name that it can convert (these are the same is for "DRAG ME")
	// note that "DELETE"  is done in selection_convert
	i = 0;
	atoms[i++] = conp->atom("FILE_NAME");
	atoms[i++] = conp->atom("STRING");
	atoms[i++] = conp->atom("LENGTH");
	atoms[i++] = conp->atom("HOST_NAME");
	atoms[i++] = conp->atom("DELETE");
	atoms[i] = None;
	st->set_selection_targets(atoms);

	// disallow_cut_paste so it doesn't grab out mouse button press
	st->disallow_cut_paste();
	// make the object draggable
	st->allow_drag(target_cursor,targetok_cursor);
	// put some drag translations on the object
	st->override_translations(dragTrans);
	// associate the object to the app_window
	st->layout_associated_object(app,0,row++,OI_active);

	// Now make three boxes with colors of red,green,and blue and
	// associate them to the app_window

	box = make_color_box(conp,"redBox","red");
	box->layout_associated_object(app,0,row,OI_active);
	box = make_color_box(conp,"greenBox","green");
	box->layout_associated_object(app,2,row,OI_active);
	box = make_color_box(conp,"blueBox","blue");
	box->layout_associated_object(app,2,row,OI_active);

	// put the app_window on the display
	app->set_associated_object(conp->root(),OI_def_loc,OI_def_loc,OI_active);

	OI_begin_interaction();
	OI_fini();
}
