#include <OI/oi.H>
#if defined(ultrix) || defined(SVR4) || defined(hpux)
#include <unistd.h>
#else
#include <sysent.h>
#endif
#include <fcntl.h>
#include <string.h>


typedef	struct {
	int		fd;
	OI_d_tech	*container ;
} COMPOUND_IO ;

/*
 *	Select
 *
 *	This program demonstrates adding io callbacks to the OI dispatch routine.
 *	The program opens the parent tty.  All entered at the tty is captured and
 *	displayed within the scrolled text object.
 *
 *	The program opens the io stream and registers callback to activate when i/o
 *	is ready for it.
 *
 *	The reader should refer to the OI documentation for
 *	information on the following member functions.
 *	- OIIntro
 *		OI_init()
 *		OI_begin_interaction()
 *		OI_fini()
 *	- OI_d_tech
 *		layout_associated_object()
 *		set_associated_object()
 *		set_layout()
 *	- OI_app_window
 *		oi_create_app_window()
 *	- OIINTRO
 *		OI_io_dispatch_insert()
 *			( OI_USER_INPUT, OI_USER_OUTPUT, OI_USER_EXCEPT )
 *		OI_io_dispatch_remove()
 */
void
main (int argc, char**argv)
{
	int			inp_rdy(int,void*) ;
	int			fd ;
	OI_connection		*conp ;
	OI_app_window		*wp ;
	OI_scroll_text		*scrltxt ;
	static COMPOUND_IO	tty ;

	/*
	 *	attempt to open the base tty for reading.
	 *	note that the tty is line oriented, not character, for this example
	 */
	if (fd = open("/dev/tty",O_RDONLY) < 0) {
		printf("Unable to open /dev/tty\n") ;
	}
	else {
		/*
		 *	Open a connection.
		 */
		if (conp = OI_init(&argc,argv,"OITest")) {
			/*
			 *	Create the select main window.  Make it row layout.
			 */
			wp = oi_create_app_window("main",200,100,"I/O Callbacks") ;
			wp->set_layout(OI_layout_row) ;

			/*
			 *	create the text container object
			 */
			scrltxt = oi_create_scroll_text( "scrltxt", OI_SCROLL_BAR_VERTICAL, 10, 60, 100, 80 );
			scrltxt->layout_associated_object( wp, 1, 1, OI_ACTIVE) ;
			scrltxt->set_size_track( OI_size_track_full );
			scrltxt->insert_line( -1, "All text typed into the xterm from which you" );
			scrltxt->insert_line( -1, "started this program will be echoed into this");
			scrltxt->insert_line( -1, "OI_scroll_text when return is pressed." );
	
			/*
			 *	Insert the input_ready routine for this file descriptor.
			 */
			tty.fd		= fd ;
			tty.container	= scrltxt ;
			OI_io_dispatch_insert(fd,OI_USER_INPUT,&inp_rdy,(void*) &tty ) ;

			/*
			 *	OK, display main window.
			 */
			wp->set_associated_object(wp->root(),OI_DEF_LOC,OI_DEF_LOC,OI_ACTIVE) ;
			OI_begin_interaction() ;

			/*
			 *	Cleanup.  Make sure that we cleanup the library.
			 */
			OI_fini();
		}
	}
}


/*
 *	input ready
 *	
 *	This function demonstrates the use of both dispatch_remove and
 *	dispatch_insert.  This function was inserted as the first function
 *	to call for this descriptor to allow us to do whatever initialization
 *	that we might need to do.  After initialization is complete, we 
 *	remove the current dispatch routine, and insert the generic read 
 *	routine.
 */
int
inp_rdy(int fd, void *argp)
{
	int		inp_read(int, void*) ;

	OI_io_dispatch_remove( fd, OI_USER_INPUT ) ;
	OI_io_dispatch_insert( fd, OI_USER_INPUT, &inp_read, argp ) ;
	return( 1 ) ;
}


/*
 *	input read
 *
 *	This function is called whenever io input is ready on the specified
 *	descriptor.  The routine simply reads the descriptor, then places the
 *	text into the associated scroll text container object.
 */
int
inp_read(int fd, void *argp)
{
	char		buf[513] ;
	COMPOUND_IO	* p ;
	char		* cr;
	int		nc ;

	p = (COMPOUND_IO*) argp ;
	nc = read( fd, buf, sizeof(buf) );
	if (nc > 0) {
		buf[ nc ] = '\0';
		if (cr = strchr( buf, '\n')) *cr = '\0' ;
		((OI_scroll_text *)p->container)->insert_scroll_line( -1, buf );
	}
	return( 1 ) ;
}
