#include <OI/oi.H>
#include <ctype.h>


/*
 *	callbacks - C functions as callback functions.
 *
 *	This program demonstrates setting a character check callback on an entry field.
 *	The program demonstrates how to set up C functions as callback functions.
 *	The program creates a hex entry field, and uses the character check callback to
 *	ensure that typed characters are hex [0-9, a-f, A-F].
 *
 *	The reader should refer to the OI documentation for
 *	information on the following member functions.
 *		- OIIntro
 *			OI_init()
 *			OI_begin_interaction()
 *			OI_fini()
 *		- OI_d_tech
 *			layout_associated_object()
 *			set_associated_object()
 *			set_layout()
 *		- OI_app_window
 *			oi_create_app_window()
 *		- OI_entry_field
 *			oi_create_entry_field()
 *			set_char_chk()
 *				OI_EF_CHAR_CHK_BAD
 *				OI_EF_CHAR_CHK_INSERT
 *
 */
void
main (int argc, char **argv)
{
	OI_ef_char_chk_status hexValidate(OI_entry_field *, void *, OI_number, char);	/*  validation routine */
	OI_connection	*conp;				/* the connection to the server */
	OI_app_window	*appWindow;			/* the enclosing app window */
	OI_entry_field	*entryField;			/* the entry field */

	
	/*
	 *	Open a connection.
	 */
	if ((conp = OI_init(&argc, argv, "callback", "Callback"))) {

		/*
		 *	Create the application window.
		 *	Make it row layout.
		 */
		appWindow = oi_create_app_window("myapp", 10, 10, "C callback");
		appWindow->set_layout(OI_layout_row);

		/*
		 *	Create the hex entry field.
		 *	Set character check for the entry field.
		 *	Layout the entry field in the application window.
		 */
		entryField = oi_create_entry_field("hexEntry", 8, "Address: 0x", NULL, 8);
		entryField->set_char_chk(hexValidate);
		entryField->layout_associated_object(appWindow, 1, 1, OI_ACTIVE);

		/*
		 *	Display main window.
		 *	Begin interaction.
		 */
		appWindow->set_associated_object(conp->root(), OI_DEF_LOC, OI_DEF_LOC, OI_ACTIVE);
		OI_begin_interaction();
	}

	/*
	 *	Cleanup.  Make sure that we cleanup the library.
	 */
	OI_fini();
}


/*
 *	Hex Validate
 *
 *	This entry field character check function validates that
 *	the typed character was actually hex.  If a hex character
 *	was typed, OI_EF_CHAR_CHK_INSERT, is returned, otherwise
 *	an error condition, OI_EF_CHAR_CHK_BAD, is returned.
 */
OI_ef_char_chk_status
hexValidate(OI_entry_field *, void *, OI_number, char c)
{
	OI_ef_char_chk_status ok;

	ok = OI_EF_CHAR_CHK_BAD;
	if (c && isxdigit(c))
		ok = OI_EF_CHAR_CHK_INSERT;

	return (ok);
}
