/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	models.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_model class header
 *
 *	RCSid = "$Id: models.H,v 4.2.1.1 1993/06/01 22:55:41 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_models_H
#define OI_models_H

	class OI_class;

	class OI_model {
	 protected:
			XrmQuark	namq ;				/* quark corresponding to model instance name */
			XrmQuark	classq ;			/* quark corresponding to model class name */
			XrmQuark	hlp_filq ;			/* quark corresponding to default help file */
	 public:
					OI_model(char *, char *) ;
		virtual			~OI_model() ;
			XrmQuark	class_quark()			{ return(classq); }
			XrmQuark	instance_quark()		{ return(namq); }
			char		*name() ;			/* instance name */
			char		*class_name() ;			/* class name */
		virtual	unsigned long	default_horz_scrollbar() = 0 ;
		virtual	unsigned long	default_vert_scrollbar() = 0 ;
		virtual	OI_bool		is_3d() = 0 ;
			char		*default_help_file() ;
			XrmQuark	default_help_file_quark()	{ return(hlp_filq); }
		virtual	OI_class	*default_excl_menu_class() = 0 ;
		virtual	OI_class	*default_poly_menu_class() = 0 ;
	} ;

	class OI_model_openlook : public OI_model {
	 public:
					OI_model_openlook(char *mdl_nam=NULL, char *mdl_cls=NULL) ;
		virtual			~OI_model_openlook();
		virtual	unsigned long	default_horz_scrollbar() ;
		virtual	unsigned long	default_vert_scrollbar() ;
		virtual	OI_bool		is_3d() ;
		virtual	OI_class	*default_excl_menu_class() ;
		virtual	OI_class	*default_poly_menu_class() ;
	} ;

	class OI_model_openlook_3d : public OI_model_openlook {
	 public:
					OI_model_openlook_3d(char *mdl_nam=NULL, char *mdl_cls=NULL) ;
		virtual			~OI_model_openlook_3d();
		virtual	OI_bool		is_3d() ;
	} ;

	class OI_model_motif : public OI_model {
	 public:
					OI_model_motif(char *mdl_nam=NULL, char *mdl_cls=NULL) ;
		virtual			~OI_model_motif();
		virtual	unsigned long	default_horz_scrollbar() ;
		virtual	unsigned long	default_vert_scrollbar() ;
		virtual	OI_bool		is_3d() ;
		virtual	OI_class	*default_excl_menu_class() ;
		virtual	OI_class	*default_poly_menu_class() ;
	} ;

 /* model dependent aspects of OI objects */
	class OI_mdl : public OI_callback {
	 protected:
			OI_class	*classp ;				/* ptr to class object */
					OI_mdl(class OI_class *) ;
		virtual			~OI_mdl();
	 public:
			void		initialize(class OI_connection*) ;
			OI_bool		initialized(class OI_connection*) ;
	} ;

 /* ptrs to defined models */
	extern	class	OI_model	*OI_models[3] ;		/* ptr to model info for each model */

#endif /* OI_models_H */
