
# line 10 "fortran.y"

/*
  fortran.c:

    Copyright (C) 1992 by Robert K. Moniot.
    This program is free software.  Permission is granted to
    modify it and/or redistribute it.  There is no warranty
    for this program.


	    This grammar is ANSI standard-conforming, except for:
		-- Sensitive to whitespace, which is used in lexical analysis
		   to separate keywords and identifiers from context.  This
		   is a design feature.  Rules are the same as for Pascal.
		   (Of course stmt fields and end-of-line still honored.)
		   Note: a complex constant cannot be split across lines.
		-- Currently, some keywords are partially reserved: may
		   only be used for scalar variables.  (See keywords.c)  This
		   is the fault of the lexical analyzer (too little lookahead).

	    Extensions supported:
		-- Case insensitive.
		 -- Hollerith constants.
		-- Variable names may be longer than 6 characters.  Also
		   allows underscores in names.
		-- DO ... ENDDO and DO WHILE loop forms allowed.
		-- NAMELIST supported.
		-- TYPE and ACCEPT I/O statements allowed.
		-- Tabs are permitted in input, and (except in character data)
		   expand into blanks up to the next column equal to 1 mod 8.
		-- Type declarations INTEGER*2, REAL*8, etc. are allowed.
		   REAL*8 becomes DOUBLE PRECISION.  For others, length spec
		   is ignored.
		-- IMPLICIT NONE allowed.
	 */

/*  Author: R. Moniot
 *  Date:   August 1988
 *  Last revision: January 1992
 */

#include <stdio.h>
#include <string.h>
#include "ftnchek.h"
#include "symtab.h"
void exit();



int current_datatype,	/* set when parse type_name or type_stmt */
    stmt_sequence_no,   /* set when parsing, reset to 0 at end_stmt */
    control_item_count;	/* count of items in control_info_list */

extern unsigned prev_stmt_line_num; /* shared with advance */

int current_module_hash = -1,	/* hashtable index of current module name */
    current_module_type,
    executable_stmt=FALSE,
    prev_stmt_class=0,
		 /* flags for lexer */
    complex_const_allowed=FALSE, /* for help in lookahead for these */
    inside_format=FALSE,	/* when inside parens of FORMAT  */
    integer_context=FALSE,	/* says integers-only are to follow */
    prev_goto=FALSE,
    goto_flag=FALSE;	/* if unconditional GOTO was encountered */

long exec_stmt_count=0;	/* count of executable stmts in program */

PRIVATE void
print_comlist(), print_exprlist(), END_processing();
PRIVATE Token *
  append_token();
PRIVATE int
  do_bounds_type();
		/* Uses of Token fields for nonterminals: */
/*
  1. dim_bound_lists: dimensioning info for arrays:
       token.class = no. of dimensions,
       token.subclass = no. of elements
  2. expressions
       token.value.integer = hash index (of identifier)
       token.class = type_byte = storage_class << 4 + datatype
       token.subclass = flags: CONST_EXPR, LVALUE_EXPR, etc.
  3. common variable lists
       token.subclass = flag: COMMA_FLAG used to handle extra/missing commas
*/

#define seq_header   1
#define seq_implicit 2
#define seq_specif   3
#define seq_stmt_fun 4
#define seq_exec     5
#define seq_end      6

#define DBG(S)	if(debug_parser) fprintf(list_fd,"\nproduction: S");
#define DBGstr(S,str) \
	if(debug_parser) fprintf(list_fd,"\nproduction: S%s",str);

# define tok_identifier 257
# define tok_array_identifier 258
# define tok_label 259
# define tok_integer_const 260
# define tok_real_const 261
# define tok_dp_const 262
# define tok_complex_const 263
# define tok_logical_const 264
# define tok_string 265
# define tok_hollerith 266
# define tok_edit_descriptor 267
# define tok_letter 268
# define tok_relop 269
# define tok_AND 270
# define tok_OR 271
# define tok_EQV 272
# define tok_NEQV 273
# define tok_NOT 274
# define tok_power 275
# define tok_concat 276
# define tok_ASSIGN 277
# define tok_ACCEPT 278
# define tok_BACKSPACE 279
# define tok_BLOCK 280
# define tok_BLOCKDATA 281
# define tok_CALL 282
# define tok_CHARACTER 283
# define tok_CLOSE 284
# define tok_COMMON 285
# define tok_COMPLEX 286
# define tok_CONTINUE 287
# define tok_BYTE 288
# define tok_DATA 289
# define tok_DIMENSION 290
# define tok_DO 291
# define tok_DOUBLE 292
# define tok_DOUBLEPRECISION 293
# define tok_DOWHILE 294
# define tok_ELSE 295
# define tok_ELSEIF 296
# define tok_END 297
# define tok_ENDDO 298
# define tok_ENDFILE 299
# define tok_ENDIF 300
# define tok_ENTRY 301
# define tok_EQUIVALENCE 302
# define tok_EXTERNAL 303
# define tok_FILE 304
# define tok_FORMAT 305
# define tok_FUNCTION 306
# define tok_GO 307
# define tok_GOTO 308
# define tok_IF 309
# define tok_IMPLICIT 310
# define tok_INCLUDE 311
# define tok_INQUIRE 312
# define tok_INTEGER 313
# define tok_INTRINSIC 314
# define tok_LOGICAL 315
# define tok_NAMELIST 316
# define tok_OPEN 317
# define tok_PARAMETER 318
# define tok_PAUSE 319
# define tok_PRECISION 320
# define tok_PRINT 321
# define tok_PROGRAM 322
# define tok_READ 323
# define tok_REAL 324
# define tok_RETURN 325
# define tok_REWIND 326
# define tok_SAVE 327
# define tok_STOP 328
# define tok_SUBROUTINE 329
# define tok_TO 330
# define tok_TYPE 331
# define tok_THEN 332
# define tok_WHILE 333
# define tok_WRITE 334
# define tok_illegal 335
# define EOS 127
# define REDUCE 337
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval, yyval;
typedef int yytabelem;
# define YYERRCODE 256

# line 2499 "fortran.y"

void
init_parser()			/* Initialize various flags & counters */
{
	initial_flag = TRUE;	/* set flag for keyword test */
	implicit_flag=FALSE;	/* clear flags for IMPLICIT stmt */
	implicit_letter_flag = FALSE;
	implicit_type_given = FALSE;
	implicit_none = FALSE;
	prev_token_class = EOS;
	complex_const_allowed = FALSE;
	stmt_sequence_no = 0;
}

		/* Propagate non-integer type if any of DO loop
		   bounds are non-integer. */
PRIVATE int
do_bounds_type(t1,t2,t3)
     Token *t1, *t2, *t3;
{
  int result_class;
       if(datatype_of(t1->class) != type_INTEGER) result_class = t1->class;
  else if(datatype_of(t2->class) != type_INTEGER) result_class = t2->class;
  else if(datatype_of(t3->class) != type_INTEGER) result_class = t3->class;
  else result_class = t1->class;
  return result_class;
}


/* Debugging routine: prints the expression list of various productions */

PRIVATE void
print_exprlist(s,t)
	char *s;
	Token *t;
{

	fprintf(list_fd,"\n%s arglist: ",s);

	if(t == NULL)
		fprintf(list_fd,"(empty)");
	else {
	      while( (t=t->next_token) != NULL) {
		  fprintf(list_fd,"%s ",type_name[datatype_of(t->class)]);
		  if( is_true(ID_EXPR,t->subclass) )
			fprintf(list_fd,"(%s) ",token_name(*t));
	    }
	}
}

PRIVATE void
print_comlist(s,t)
	char *s;
	Token *t;
{

	fprintf(list_fd,"\n%s varlist: ",s);

	if(t == NULL)
		fprintf(list_fd,"(empty)");
	else {
	      while( (t=t->next_token) != NULL) {
		  fprintf(list_fd,"%s ",type_name[datatype_of(t->class)]);
		  if( is_true(ID_EXPR,t->subclass) )
			fprintf(list_fd,"(%s) ",token_name(*t));
		}
	  }
}

/* After having parsed prog_stmt, function_stmt, subroutine_stmt,
   block_data_stmt, the stmt_sequence_no is set to the value seq_header.
*/

void
check_seq_header(t)
     Token *t;
{
	if(stmt_sequence_no >= seq_header) {
	   syntax_error( (t == (Token *) NULL? line_num: t->line_num),
			NO_COL_NUM,
			"missing END statement inserted");
	   msg_tail( (t == (Token *) NULL? "at end of file":
		      "prior to statement") );

	   END_processing(t);
	}
	stmt_sequence_no = seq_header;
}




	/* After having parsed end_stmt, common block lists and
	   subprogram argument lists are copied over into global symbol
	   table, the local symbol table is printed out and then cleared,
	   and stmt_sequence_no is set to zero for start of next module.
	*/

PRIVATE void
END_processing(t)
	Token *t;
{
  if(current_module_hash != -1) {
	if(exec_stmt_count == 0 &&
	   current_module_type != type_BLOCK_DATA) {
	  warning(t == (Token *)NULL? line_num: t->line_num, NO_COL_NUM,
		  "Module contains no executable statements");
	}

	if(do_list && t != (Token *)NULL)
	    flush_line_out(t->line_num);
	process_lists(current_module_hash);
	debug_symtabs();
	print_loc_symbols(current_module_hash);
	init_symtab();
  }
  exec_stmt_count = 0;
  stmt_sequence_no = 0;
  current_module_hash = -1;
  implicit_type_given = FALSE;
  implicit_none = FALSE;
}

		/* Routine to add token t to the front of a token list. */
PRIVATE Token *
append_token(tlist,t)
     Token *tlist, *t;
{
	Token *tcopy;
	if((tcopy=new_token()) == (Token *)NULL){
		fprintf(stderr,
			"Oops--Out of token space at line %u\n",
			line_num);
#ifdef LARGE_MACHINE
		fprintf(stderr,
			"Recompile me with larger TOKENSPACESZ value\n");
#else
		fprintf(stderr,
			"Recompile me with LARGE_MACHINE option\n");
#endif
		exit(1);
	}

	*tcopy = *t;		/* make permanent copy of token */
	tcopy->next_token = tlist; /* link it onto front of list */
	return tcopy;		/* return it as new tlist */
}
yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 244,
	40, 367,
	-2, 427,
-1, 399,
	61, 431,
	-2, 429,
-1, 400,
	61, 432,
	-2, 430,
-1, 466,
	41, 352,
	44, 352,
	-2, 397,
-1, 544,
	269, 0,
	-2, 384,
-1, 615,
	42, 214,
	-2, 216,
-1, 623,
	42, 439,
	-2, 406,
	};
# define YYNPROD 442
# define YYLAST 1548
yytabelem yyact[]={

   265,   507,   382,   565,   398,   566,   386,   240,   612,   287,
   611,   368,   467,   254,   494,   608,   476,   495,   489,   588,
   473,   468,   586,   396,   488,   465,   245,   143,   255,   143,
   338,   385,    79,   119,    78,   143,   236,   118,   305,   118,
   175,   165,   326,   269,   262,   118,   397,    77,   261,   275,
   266,   471,   212,   235,   184,   263,   366,   196,   173,   132,
   359,   183,   260,   201,    83,   144,   145,   171,   764,   222,
   517,   307,   313,   188,   290,   312,   244,   142,   154,   142,
   303,   151,   189,   403,   189,   142,   428,   403,   189,   418,
   738,   216,   217,   220,   189,   683,   414,   415,   419,   143,
   273,   277,   279,   288,   169,   394,   168,   420,   746,   118,
   609,   591,   149,   143,   157,   160,   676,   383,   672,   167,
   179,   527,   187,   118,   197,   202,   202,   207,   209,   213,
   695,   166,   219,   297,   694,   228,   228,   174,   311,   367,
   176,   295,   256,   294,   369,   214,   181,   178,   413,   142,
   192,   198,   203,   203,   158,   159,   300,   301,   302,   475,
   164,   176,   347,   142,   158,   159,   214,   227,   499,   156,
   218,   355,   229,   457,   350,   144,   145,   310,   205,   199,
   176,   315,   413,   296,   334,   413,   117,   182,   176,   137,
   388,   141,   194,   200,   389,   139,   140,   143,   247,   248,
   249,   250,   320,   341,   413,   365,   493,   118,   432,   327,
   339,   455,   777,   430,   453,   772,   135,   340,   138,   323,
   384,   409,   402,   390,   766,   210,   762,   136,   187,   379,
   220,   758,   761,   187,   760,   174,   354,   351,   333,   117,
   360,   361,   137,   349,   141,   153,   377,   142,   139,   140,
   756,   375,   202,   755,   742,   741,   124,   725,   154,   204,
   456,   380,   740,   152,   739,   722,   734,   332,   655,   135,
   733,   138,   356,   416,   732,   706,   404,   387,   628,   203,
   136,   395,   730,   719,   716,   407,   715,   651,   511,   492,
   714,   431,   158,   159,   158,   159,   429,   690,   454,   158,
   159,   452,   410,   688,   408,   401,   322,   460,   673,   417,
   667,   190,   378,   190,   463,   460,   458,   190,   426,   427,
   421,   414,   415,   190,   395,   661,   414,   415,   395,   376,
   395,   365,   602,   353,   374,   445,   591,   744,   592,   595,
   587,   594,   357,   598,   660,   491,   659,   414,   415,   414,
   415,   466,   414,   415,   600,   158,   159,   158,   400,   369,
   365,   143,   252,   143,   276,   268,   469,   267,   508,   348,
   474,   118,   603,   118,   158,   159,   158,   159,   144,   145,
   434,   158,   159,   363,   436,   373,   438,   158,   159,   521,
   179,   158,   159,   496,   537,   484,   343,   144,   145,   174,
   187,   174,   482,   351,   329,   360,   145,   533,   158,   159,
   197,   142,   202,   142,   372,   349,   529,   486,   531,   501,
   522,   504,   512,   536,   513,   518,   213,   509,   510,   505,
   470,   516,   514,   447,   442,   437,   435,   198,   433,   203,
   411,   393,   538,   364,   556,   392,   391,   330,   321,    58,
   567,   319,   256,   563,   318,   469,   535,   530,   317,   256,
   574,   299,   293,   256,   543,   225,   362,   542,   547,   548,
   252,   150,   549,   545,   546,   664,   544,   539,   540,   342,
    14,   226,   605,   528,   449,   215,   557,   328,   422,   747,
   423,   617,   425,   336,    86,   616,   335,   424,   564,   515,
   474,   569,   474,   575,   474,   570,   743,   571,   422,   572,
   423,   576,   341,   169,   503,   168,   624,   500,   194,   339,
   288,   604,   606,   700,   776,   327,   340,   642,   167,   640,
   615,   645,   625,   650,   754,   634,   635,   582,   768,   647,
   166,   422,   703,   423,   297,   270,   558,   559,   753,   720,
   649,   631,   520,   289,   639,   644,   593,   698,   765,   757,
   699,   596,   597,   592,   657,   658,   671,   221,   577,   232,
   538,   230,   599,   413,   684,   256,   682,   526,   656,   144,
   145,   223,   247,   248,   249,   250,   243,   241,   242,   666,
   702,   256,   526,   680,   296,   422,   264,   423,   291,   665,
   256,   256,   526,   674,   687,   689,   685,   297,   693,   692,
   691,   663,   669,   653,   662,   632,   654,   686,   675,   652,
   643,   630,   582,   520,   631,   584,   704,   705,   491,   491,
     7,   474,   469,   619,   533,   618,   233,   233,   626,   233,
   233,   627,   288,   578,   710,   718,   713,   708,   721,   711,
   712,   717,   707,   581,   541,   697,   582,   296,   524,   502,
   485,   251,   723,   271,   272,   579,   352,   561,   580,   731,
   562,   554,   306,   371,   526,   567,   496,   735,   496,   496,
   737,   553,   552,   469,   526,   526,   525,   144,   145,   526,
   247,   248,   249,   250,   243,   241,   242,   519,   256,   477,
   520,   344,   478,   370,   724,   200,   304,   508,   752,   729,
   617,   617,   749,   748,   616,   745,   770,   767,   679,   678,
   677,   637,   636,   583,   633,   629,   567,   523,   316,   759,
   462,   450,   441,   440,   439,   406,   405,   344,   763,   346,
   331,   324,   314,   308,   298,   292,   285,   162,    10,   615,
   750,   239,     3,   237,     9,   146,   258,   148,   534,    16,
   144,   145,     8,   147,   769,   532,   567,   771,   246,   508,
   774,   773,   775,   238,   668,   444,   560,   508,   778,   284,
    84,    91,   128,   112,   113,   130,   117,    99,    75,   137,
    87,   141,    72,    73,   131,   139,   140,   107,   103,   104,
    17,   108,   129,   105,    68,    74,    80,   101,    69,   133,
   123,   122,   124,   114,    11,   100,   135,    81,   138,    76,
    98,    70,    89,   464,    93,    64,   125,   136,   102,   127,
    82,    88,   134,   601,    94,   590,   589,   126,    16,   144,
   145,   259,   161,    95,   268,   648,   267,   158,   159,    97,
   247,   248,   249,   250,   620,   621,   622,    96,   283,    84,
    91,   128,   112,   113,   130,   117,    99,    75,   137,    87,
   141,    72,    73,   131,   139,   140,   107,   103,   104,    17,
   108,   129,   105,    68,    74,    80,   282,    69,   133,   123,
   122,   124,   114,   281,   100,   135,    81,   138,    76,    98,
    70,    89,   257,    93,    64,   125,   136,   102,   127,    82,
    88,   134,   728,    94,   144,   145,   126,   555,   602,   727,
   551,   726,   591,   585,   550,   595,   587,   594,   646,   598,
    90,   309,   412,   253,    84,    91,   128,    92,   451,   130,
   600,    99,   568,   106,    87,   252,   443,   446,   268,   736,
   267,   448,   461,    85,   224,   121,   129,   120,   638,   381,
   751,   337,   614,   613,   123,   122,   124,   701,   252,   100,
   610,   268,   483,   267,    98,   172,    89,   170,    93,   211,
   125,   208,   102,   127,   206,    88,   459,   696,    94,   222,
   252,   126,   670,   268,   479,   267,   325,   607,   481,   480,
   163,    71,   116,   115,   195,   252,   358,   276,   268,   193,
   267,   191,   185,   186,   498,   497,   345,   180,   487,   177,
   280,    67,   276,   268,   472,   267,   111,    66,   110,   109,
    65,   155,    63,    62,    61,   278,    60,   276,   268,    59,
   267,    57,    56,    55,    54,    53,    52,    51,    50,    49,
   274,    48,   276,   268,    47,   267,    46,    45,   144,   145,
    44,   247,   248,   249,   250,   243,   241,   242,   252,    43,
    42,   268,    41,   267,    40,   264,    39,    38,    37,    36,
    35,    34,    33,   259,    32,    31,   268,    30,   267,   602,
    29,    28,    27,   591,    26,    25,   595,    24,   594,    23,
   598,    22,    21,    20,    19,    18,    15,    13,    12,     6,
   252,   600,   709,   268,     5,   267,     4,     2,     1,     0,
   252,     0,   490,   268,     0,   267,     0,     0,     0,     0,
   252,   681,     0,   268,     0,   267,     0,     0,     0,     0,
   252,     0,   593,   268,   641,   267,     0,   596,   597,   592,
   252,   573,     0,   268,     0,   267,     0,     0,   599,     0,
     0,     0,   144,   145,     0,   247,   248,   249,   250,   243,
   241,   242,   252,     0,   506,   268,     0,   267,     0,   264,
     0,     0,     0,     0,     0,   144,   145,     0,   247,   248,
   249,   250,   243,   241,   242,     0,     0,     0,     0,     0,
   252,     0,   264,   268,     0,   267,     0,   144,   145,     0,
   247,   248,   249,   250,   243,   241,   242,   619,   459,   618,
     0,     0,   399,   400,   264,   247,   248,   249,   250,   243,
   241,   242,   252,     0,   234,     0,     0,   144,   145,   264,
   247,   248,   249,   250,   243,   241,   242,   231,     0,   234,
     0,     0,   144,   145,   264,   247,   248,   249,   250,   243,
   241,   242,     0,     0,     0,     0,     0,   144,   145,   264,
   247,   248,   249,   250,   243,   241,   242,   252,     0,     0,
   268,     0,   267,     0,   264,   144,   145,     0,   247,   248,
   249,   250,   243,   241,   242,     0,     0,     0,     0,     0,
   144,   145,   264,   247,   248,   249,   250,   243,   241,   242,
     0,     0,     0,   593,     0,     0,     0,   264,   596,   597,
   592,   252,     0,     0,   268,     0,   267,   144,   145,   599,
   247,   248,   249,   250,   243,   241,   242,   144,   145,     0,
   247,   248,   249,   250,   243,   241,   242,   144,   145,     0,
   247,   248,   249,   250,   243,   241,   242,   144,   145,     0,
   247,   248,   249,   250,   243,   241,   242,   144,   145,     0,
   247,   248,   249,   250,   243,   241,   242,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,   144,
   145,     0,   247,   248,   249,   250,   243,   241,   242,     0,
     0,     0,     0,     0,     0,     0,     0,     0,   286,     0,
     0,     0,     0,     0,     0,     0,     0,   144,   145,     0,
   247,   248,   249,   250,   243,   241,   242,     0,     0,     0,
     0,   158,   159,     0,   623,   248,   249,   250,   620,   621,
   622,     0,     0,     0,     0,     0,     0,     0,     0,   144,
   145,     0,   247,   248,   249,   250,   243,   241,   242,     0,
     0,     0,     0,     0,   144,   145,     0,   247,   248,   249,
   250,   243,   241,   242,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,   144,   145,     0,   247,   248,   249,
   250,   243,   241,   242,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,   144,   145,
     0,   247,   248,   249,   250,   243,   241,   242 };
yytabelem yypact[]={

   503, -1000,   503, -1000, -1000, -1000, -1000, -1000,   582, -1000,
 -1000,  -153, -1000, -1000, -1000, -1000,   344,   -46, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000,    42,  -103, -1000,
   707,   -97,   121,  -103, -1000,    37,   471,  -103,   151,   134,
  -103,  -103,    98,   424, -1000,   130,   657,   338,   -93,   -93,
  1207,  1192,  1043,  1192,  1192,  1010,   995,   980, -1000, -1000,
 -1000,   706,  1281,   -53,   705,   335,  -192,   704,   334,  -103,
  -103,  -103,  -209, -1000, -1000,   664, -1000, -1000, -1000,   632,
 -1000, -1000, -1000,  -259,   703, -1000, -1000, -1000, -1000, -1000,
  -103, -1000,  -231, -1000, -1000, -1000, -1000, -1000, -1000,  -248,
 -1000, -1000,   702,   688, -1000, -1000, -1000, -1000, -1000,   331,
 -1000, -1000,   327,   324, -1000,  -103, -1000,   321, -1000, -1000,
   179,   701,  -103,   360,   320, -1000,   700, -1000,   663, -1000,
   140, -1000,   449, -1000, -1000, -1000,   148,   352, -1000,   697,
   699,    35,    47, -1000, -1000,   622,  -103,   697, -1000,   124,
 -1000,   145, -1000,  -103,  -103,   339, -1000,   697, -1000,   316,
    99, -1000,   661,   631,   287,  -103,   207, -1000,   202, -1000,
 -1000,   185, -1000, -1000,  -103, -1000,  -143,  -143, -1000,   150,
  -143, -1000,   319, -1000,  -226, -1000,   318, -1000, -1000, -1000,
   314,   965,   178,  -193, -1000, -1000, -1000,   632, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000,   696,   695, -1000, -1000, -1000,
 -1000,   177,  1028,   313,   529, -1000,  -176, -1000, -1000,  1043,
  -182,  -172, -1000,  -162,  1237,   498,   450,   430,   430, -1000,
  -189,   169,   164,   311,   965,  -176, -1000,   309,   965,   308,
   965,   694,   693,   692,   307,   905, -1000,   306,   498, -1000,
 -1000,  -263, -1000, -1000,   423,   691, -1000, -1000, -1000, -1000,
   174,   171,   133, -1000,  -116, -1000,  1160, -1000, -1000,   690,
 -1000,  -143, -1000, -1000,  1160, -1000,  1028, -1000, -1000, -1000,
   303, -1000, -1000,   117, -1000,   658, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000,   121, -1000,   121,   616, -1000, -1000,
 -1000,   688, -1000,  -103,  1080,   162,  -103, -1000,    41, -1000,
 -1000, -1000, -1000,  -103,   470, -1000, -1000, -1000,  -103, -1000,
   615,   467, -1000,  -103, -1000,  -103, -1000,  1132, -1000, -1000,
    99,    99, -1000,   161, -1000,  -103, -1000,  -103, -1000,   119,
   452,  1028,  -260, -1000,   298,   656,  -143, -1000, -1000,   687,
   614, -1000, -1000, -1000,   645,  -176, -1000,   422, -1000, -1000,
 -1000, -1000,  1043,   430, -1000,  1028,   928, -1000, -1000,  1043,
    80, -1000,   267,  1043,  1028,  1028,   610,    80,  1028,  1028,
  1237,  -162,   430,   430,   430,   430,   450,   450,   430, -1000,
 -1000, -1000, -1000, -1000,   641, -1000,   640, -1000,   630,   965,
   965,   965, -1000, -1000,   626,  -176, -1000, -1000,  1028,  1237,
 -1000,  1028, -1000,   117, -1000,   117, -1000,   117, -1000,  1110,
   445,  1028,   965,   599,   624, -1000, -1000,   612, -1000,  -176,
 -1000,   682,   581, -1000, -1000, -1000,   882,   245,  -103,   421,
   -44,  -158, -1000,  1174, -1000,   100, -1000,   597, -1000,   220,
 -1000,   498, -1000,   685,   580,   571,   684,   632, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000,   681,   680,   498, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000,  -176,   -82, -1000,  1100,
 -1000, -1000,   579, -1000, -1000,   801,   965, -1000,   322,   160,
 -1000,   578,   572,   445, -1000,  -176,   141, -1000, -1000,  -182,
  -182,  1043,  -172, -1000, -1000,   450,   450, -1000, -1000, -1000,
  1043,  1043,   219,   217,   198,   570, -1000,   414,   558,   548,
   183, -1000,   950,  -143,    77,   181,   559,   498,  1028,    75,
   679,   678,   677, -1000,   552,  1090,    54,   533, -1000, -1000,
   -82, -1000,  1028,   176,   117,   170, -1000,  1053, -1000,    71,
 -1000, -1000, -1000, -1000,  -126,  -130, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000,  1028, -1000,   516, -1000,   478,
   546, -1000, -1000,   500, -1000, -1000, -1000, -1000,   -62,   -62,
 -1000, -1000, -1000, -1000, -1000,   214, -1000,  1080,  1070,  -103,
 -1000,  -103,  -103,   928, -1000, -1000, -1000, -1000,   163,   159,
   157,  1237,  -143,   156,   508,  -143, -1000,   138,  1043, -1000,
 -1000, -1000, -1000, -1000,  1028, -1000,   196,   529,   529, -1000,
 -1000, -1000,  -103,   155,   322,   147,   143, -1000,   139,  -176,
 -1000, -1000, -1000, -1000,  1237,    49,   137,   135,   128,   127,
 -1000, -1000,   465, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000,   296, -1000, -1000, -1000,  -176, -1000,  -158,
  -160,   442,  1174,   590, -1000, -1000,  1237, -1000, -1000, -1000,
   507, -1000, -1000,   493, -1000, -1000, -1000,   126, -1000, -1000,
   123,   515, -1000,   104,  -176,  1237,   107,   105, -1000,   165,
 -1000, -1000, -1000, -1000, -1000,  -143,  -264,   514,    97, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000,   676,   494, -1000, -1000, -1000, -1000, -1000, -1000,   675,
 -1000, -1000,   322, -1000,    88,  1237, -1000, -1000,  1237,  -143,
 -1000, -1000, -1000, -1000,   480,    85,  1237, -1000, -1000 };
yytabelem yypgo[]={

     0,  1118,  1117,   752,  1116,  1114,  1109,   754,  1108,  1107,
   480,  1106,  1105,  1104,  1103,  1102,   748,  1101,  1099,  1097,
  1095,  1094,  1092,  1091,  1090,  1087,  1085,  1084,  1082,  1081,
  1080,  1079,  1078,  1077,  1076,  1074,  1072,  1070,  1069,  1060,
  1057,  1056,  1054,  1051,  1049,  1048,  1047,  1046,  1045,  1044,
  1043,  1042,  1041,   449,  1039,  1036,  1034,  1033,  1032,  1031,
    46,    51,  1030,  1029,  1028,    59,    47,    34,    32,  1027,
  1026,  1024,    20,  1021,  1019,    73,  1018,    24,    18,  1017,
  1016,    14,    17,  1015,  1014,    12,    38,   146,   187,    54,
  1013,    61,  1012,  1011,   150,  1009,  1006,    60,  1004,   179,
  1003,    11,  1002,    56,    57,    63,  1001,  1000,    41,   999,
   998,   997,    15,     1,   996,    42,   994,   987,   984,   981,
   979,    52,   977,    67,   975,   972,   970,   967,    58,    64,
    40,    10,     8,   963,   962,   961,    30,    33,   960,   959,
    49,   958,    36,   957,   955,     6,     2,   953,    31,     9,
   494,   952,   951,   949,   943,     3,   942,   938,     5,   481,
   937,   933,    13,   932,   931,   105,   930,   569,   924,   921,
   920,   919,    23,     4,   917,   912,    28,   902,   893,   886,
   858,   857,   849,   843,   545,   842,    16,    22,    19,   836,
   835,   833,    76,   823,    25,   807,   779,   776,   775,   774,
   773,   768,   765,   758,   756,    62,    48,    44,    55,     0,
    50,    43,    53,   753,   751,     7,    26,    21 };
yytabelem yyr1[]={

     0,     1,     1,     2,     2,     3,     3,     3,     3,     4,
     4,     7,     7,     7,     7,     7,     8,     8,     8,     8,
     5,     5,    16,     6,     9,     9,     9,     9,     9,     9,
     9,     9,     9,     9,     9,     9,     9,    10,    10,    10,
    10,    10,    10,    10,    10,    10,    10,    10,    10,    10,
    10,    10,    10,    10,    10,    10,    10,    10,    10,    11,
    11,    11,    11,    11,    11,    11,    59,    12,    17,    17,
    13,    62,    62,    62,    62,    63,    64,    65,    65,    65,
    14,    69,    69,    70,    61,    61,    71,    71,    72,    72,
    15,    15,    73,    73,    22,    74,    74,    75,    76,    76,
    77,    77,    77,    77,    79,    23,    80,    80,    81,    81,
    82,    82,    82,    83,    84,    84,    24,    24,    24,    88,
    88,    89,    90,    90,    90,    87,    87,    91,    91,    92,
    92,    25,    93,    93,    94,    95,    96,    96,    97,    97,
    26,    26,    26,    26,    66,    66,    66,   100,   100,   100,
   100,   102,   102,   102,    67,    68,    98,    98,   104,   104,
    99,    99,   105,   105,   105,   105,   106,    20,    20,   107,
   109,   107,   110,   108,   111,   111,   112,   112,   103,   103,
   103,    19,   114,   114,   116,   115,    27,   118,   118,    28,
   119,   119,    29,    29,   120,   120,   121,   121,    21,   122,
   122,   122,   125,   127,   123,   124,   124,   128,   128,   126,
   126,   131,   131,   133,   133,   132,   132,   135,   135,   136,
   136,   130,   138,   138,   139,   141,    30,   129,   129,   129,
   129,    31,    32,    33,    33,    34,    34,    34,   147,   147,
   148,   148,    35,    52,    53,   151,   150,    54,   152,   153,
    54,    55,    56,    56,    57,   156,    57,   157,    57,   154,
   154,   154,   155,   155,    58,    58,    36,    37,    38,   159,
   159,   159,   159,   161,    41,   163,    41,   164,   160,    39,
    39,    39,    39,    39,   166,    40,    40,    42,   168,   169,
    42,    43,   170,   171,    43,   165,   165,   172,   172,   174,
   174,   174,   175,   175,   162,   162,   176,   176,   177,   178,
    47,   179,    48,   180,    49,    45,    45,   181,    46,    46,
   182,   182,    44,    44,   183,   173,   173,   167,   167,   185,
    18,   186,   186,   186,   187,   187,   187,   188,   188,   190,
   190,   190,   190,   190,   190,   191,   189,   189,   189,   144,
   193,   193,   194,   196,    50,   197,    50,   199,    50,   195,
   198,   198,   198,   198,    51,    51,   200,   201,   202,   202,
   203,   203,   117,   140,   204,   204,   204,   205,   205,   206,
   206,   207,   207,   208,   208,   209,   209,   209,   209,   209,
   210,   210,   210,   211,   211,   184,   184,   212,   212,   212,
   212,   212,   212,   212,   212,   212,   215,   215,   215,   215,
   149,   158,   113,    78,   137,   213,    85,    85,   217,   214,
   214,   143,   143,    86,    86,    86,    86,   142,   142,   192,
   216,    60,    60,   134,   134,   134,   134,   134,   134,   101,
   145,   146 };
yytabelem yyr2[]={

     0,     2,     0,     2,     4,     3,     3,     2,     2,     5,
     3,     3,     3,     3,     3,     5,     3,     3,     3,     3,
     2,     4,     4,     7,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     1,     9,     7,    13,
     2,     7,    13,     7,    13,     5,     3,     2,     2,     2,
     2,     7,    13,     3,     1,     2,     3,     7,     3,     3,
     5,     7,     5,     3,     6,     2,     6,     9,     3,     7,
     3,     7,     3,     7,     1,     9,     6,    10,     7,     7,
     3,     3,     3,     8,     4,     4,     7,     7,     9,     3,
     5,     5,     7,     5,     3,     3,     5,     3,     5,     3,
     3,     7,     2,     5,     5,     7,     3,     5,     3,     5,
     6,     6,     6,     8,     2,     7,     2,     3,     3,     3,
     3,     5,     3,     3,     3,     7,     2,     6,     3,     3,
     2,     6,     3,     7,     3,     7,     3,     7,     7,     2,
     1,     8,     1,    11,     2,     6,     3,     7,     6,     2,
     6,    10,     2,     6,     1,     9,     6,     3,     7,     6,
     3,     7,     4,     6,     2,     6,     3,     7,     6,     2,
     4,     6,     1,     1,    12,     2,     6,     3,     2,     2,
     6,     2,     6,     2,     3,     2,     3,     2,     6,     3,
     2,    15,     6,    10,     1,     1,    13,     2,     2,     2,
     2,    13,     8,    12,    14,     7,    13,    15,     2,     4,
     4,     8,    21,     5,     7,     1,    11,     4,     1,     1,
    16,     4,     4,     6,    11,     1,    15,     1,    13,     6,
     8,     5,     7,    11,     7,     5,     4,     6,     6,     0,
     2,     3,     2,     1,     6,     1,     8,     1,    11,    10,
    12,    14,     6,    10,     3,     7,    11,     6,     1,     1,
    14,     7,     1,     1,    15,     3,     7,     7,     3,     3,
     7,     7,     7,     3,     2,     6,     3,     2,    15,     1,
    12,     1,    12,     1,    12,     6,    10,     3,     6,    10,
     3,     5,     6,    10,     3,     2,     2,     3,     2,     1,
    13,     0,     4,     6,     2,     4,     2,     6,     2,     2,
     2,     2,     2,     2,     3,     2,     2,     4,     4,     9,
     3,     7,     2,     1,     6,     1,    10,     1,    12,     5,
     3,     7,     7,    11,     5,     7,     9,     3,     1,     2,
     3,     7,     3,     3,     2,     7,     7,     2,     7,     2,
     7,     2,     5,     2,     7,     2,     5,     5,     7,     7,
     2,     7,     7,     2,     7,     2,     7,     3,     2,     2,
     2,     3,     3,     3,     3,     7,     3,     3,     3,     3,
     3,     3,     3,     3,     9,     9,     3,     7,     3,     5,
     4,     4,     4,     6,     9,     9,    11,     2,     2,     3,
     3,     2,     2,     2,     4,     4,     2,     2,     2,     2,
     1,     3 };
yytabelem yychk[]={

 -1000,    -1,    -2,    -3,    -4,    -5,    -6,   127,   259,    -7,
   -16,   311,    -8,    -9,   -10,   -11,   256,   297,   -12,   -13,
   -14,   -15,   -17,   -18,   -19,   -20,   -21,   -22,   -23,   -24,
   -25,   -26,   -27,   -28,   -29,   -30,   -31,   -32,   -33,   -34,
   -35,   -36,   -37,   -38,   -39,   -40,   -41,   -42,   -43,   -44,
   -45,   -46,   -47,   -48,   -49,   -50,   -51,   -52,   -53,   -54,
   -55,   -56,   -57,   -58,   322,   -62,   -69,   -73,   301,   305,
   318,  -106,   289,   290,   302,   285,   316,   -66,   -67,   -68,
   303,   314,   327,  -129,   277,  -147,  -150,   287,   328,   319,
  -166,   278,  -160,   321,   331,  -183,  -181,  -182,   317,   284,
   312,  -195,   325,   295,   296,   300,  -154,   294,   298,   -63,
   -64,   -70,   280,   281,   310,  -100,  -102,   283,  -142,  -137,
  -143,  -144,   308,   307,   309,   323,   334,   326,   279,   299,
   282,   291,   -65,   306,   329,   313,   324,   286,   315,   292,
   293,   288,  -192,  -216,   257,   258,    -3,    -7,   -16,   265,
   127,   127,   309,   291,   304,   -59,   127,   -60,   257,   258,
   -60,  -185,    40,  -107,   257,  -108,   -65,   -66,   -67,   -68,
  -122,  -123,  -124,  -128,  -129,  -130,    40,   -74,   -75,   -60,
   -79,   -87,   -88,   -91,   -89,   -92,   -90,   -60,   -75,    47,
   276,   -93,   -94,   -95,    47,   -98,  -104,   -60,   -75,   -99,
    42,  -105,   -60,   -75,   -99,    44,  -118,   -60,  -119,   -60,
   127,  -120,  -121,   -60,    47,    61,  -145,  -145,    40,   -60,
  -145,   -10,   332,  -150,   297,   127,  -159,   260,   -60,   265,
  -159,    40,  -167,  -184,    42,  -212,  -142,  -213,  -200,  -214,
  -215,   265,   266,   264,  -192,  -216,  -201,   260,   261,   262,
   263,  -167,    40,  -161,  -162,  -176,  -140,  -177,  -204,    40,
  -205,  -206,  -207,  -208,   274,  -209,  -210,    45,    43,  -211,
  -184,  -167,  -167,  -173,    40,  -140,    42,  -173,    40,  -173,
    40,  -178,  -179,  -180,  -196,    40,   127,  -149,  -209,   -53,
   127,  -150,    40,   127,  -142,   333,  -192,  -216,    40,   127,
   -60,   -60,   -60,   289,    42,   -86,    40,   330,    40,  -164,
   -60,  -145,   306,   320,    40,   -86,    40,   127,   127,   127,
   -60,   127,   127,    40,    40,  -114,  -115,   -60,   127,    44,
   127,    40,   127,  -123,    44,    47,    44,  -135,  -136,  -137,
  -130,  -216,   127,    44,    40,   -80,    40,   127,   -88,   -91,
   127,   -89,    44,   -87,   -60,    47,   127,   -94,   -96,   -97,
   -60,   -60,   127,    44,   127,    44,  -103,    40,  -101,   260,
    42,    42,   127,   -99,   127,    44,   127,    44,   127,    44,
   -60,  -139,  -146,   260,  -146,  -148,  -145,   127,    40,    44,
  -146,   127,   127,   127,  -165,  -140,  -172,   -60,  -173,   257,
   258,   127,    44,   276,   -86,    40,    40,   -86,   127,    44,
  -140,   127,  -163,    44,   272,   273,  -162,  -140,   271,   270,
   269,  -208,    43,    45,    47,    42,  -210,  -210,   275,   127,
    44,   127,    44,   127,  -165,   127,  -165,   127,  -165,    40,
    40,    40,   127,    41,  -198,  -140,    42,   127,  -152,    61,
    40,  -157,   127,    40,   127,    40,   127,    40,  -101,    58,
  -209,  -151,    40,  -146,  -193,  -194,  -142,   -85,  -217,  -140,
   127,   -61,   -71,   -72,   -60,    42,  -186,    41,    44,  -116,
  -109,  -110,  -123,  -125,  -128,    44,   -75,   -76,   -77,   -78,
    42,  -209,   127,    44,   -81,   -82,   -60,   -83,   -84,   127,
    47,   -97,    44,    47,  -104,  -105,    42,  -113,  -209,  -103,
  -103,   127,   -60,   -60,  -121,    47,  -140,   330,   127,    41,
    44,  -146,  -148,    40,    44,    41,    44,    41,    61,  -162,
  -212,   -85,  -202,  -209,  -203,  -140,  -162,   127,  -176,  -205,
  -205,    44,  -206,  -207,  -208,  -210,  -210,  -211,  -211,  -211,
  -168,  -170,    41,    41,    41,  -174,  -173,   -60,  -165,  -165,
  -197,    41,    44,  -145,  -140,  -155,  -158,  -209,  -156,  -140,
   -61,   -61,   -61,    41,  -209,    58,  -140,  -165,    44,    41,
    44,    41,    44,    41,    44,    41,  -187,    44,  -188,  -189,
  -190,    40,   267,   260,    45,    43,   265,   266,    47,   276,
    58,  -191,    36,   127,  -115,    61,  -108,  -111,  -112,   268,
  -126,  -131,  -132,  -133,  -134,   -60,  -101,  -215,    45,    43,
   264,   265,   266,   260,  -136,   -60,    41,    44,    58,    40,
    41,    44,    44,    40,   -86,   -86,    41,    41,  -141,  -142,
  -149,    44,  -145,    41,  -148,  -145,   127,  -162,    44,  -172,
  -173,   127,    41,    41,    44,   127,  -142,  -162,  -162,   127,
   127,   127,    44,    41,    61,    41,    41,   127,  -199,  -140,
    42,  -146,    41,   127,    44,  -140,    41,    41,    41,    41,
    41,    41,  -209,    41,    41,  -194,  -142,  -217,   127,   -72,
   127,  -187,  -188,  -186,   260,   260,  -117,  -140,    41,    44,
    45,  -127,    44,    42,  -215,  -215,    61,   -77,   -78,    42,
   -81,   -82,   -82,   -85,   127,   127,   127,  -149,  -146,   127,
    41,  -146,   127,  -162,  -140,    61,  -169,  -171,  -175,   -60,
   127,  -173,   127,   127,   127,  -145,  -153,  -158,    41,   127,
   127,   127,   127,    41,    41,  -112,   268,    47,  -131,  -132,
   -60,  -138,  -113,    41,    41,   127,   127,    44,   127,  -155,
   127,   127,    61,  -146,   332,    44,   127,    41,    44,  -145,
    41,  -173,   127,  -158,  -113,  -146,    44,   127,  -113 };
yytabelem yydef[]={

     2,    -2,     1,     3,     5,     6,     7,     8,     0,    10,
    20,     0,    11,    12,    13,    14,     0,     0,    16,    17,
    18,    19,    24,    25,    26,    27,    28,    29,    30,    31,
    32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
    42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
    52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
    62,    63,    64,    65,    66,    70,    80,     0,     0,   329,
     0,     0,     0,     0,   104,     0,     0,    77,    78,    79,
     0,     0,     0,     0,   440,   440,   440,     0,   269,   269,
     0,     0,   273,     0,     0,     0,     0,     0,   309,   311,
   313,   353,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,    93,   166,   144,   146,   154,   227,   228,
   229,   230,   238,     0,     0,   284,   277,   324,   317,   320,
     0,   440,     0,    76,    83,   147,   148,   149,   150,     0,
   152,   153,   427,   428,   429,   430,     4,     9,    21,     0,
    15,    22,     0,     0,   321,     0,    90,     0,   431,   432,
     0,     0,     0,     0,     0,   169,     0,    77,    78,    79,
     0,   199,     0,   205,   207,   208,     0,     0,    95,     0,
     0,     0,     0,   125,   119,   127,     0,   129,   130,     0,
   124,     0,   132,     0,     0,     0,   156,   158,   159,     0,
     0,   160,   162,   164,     0,     0,     0,   187,     0,   190,
   192,     0,   194,   196,     0,   224,     0,     0,   440,     0,
     0,   243,     0,   440,     0,   266,     0,   270,   271,   272,
     0,     0,     0,   327,   328,   395,   397,   398,   399,   400,
   401,   402,   403,   404,    -2,   428,     0,   406,   407,   408,
   409,     0,     0,     0,   275,   304,   306,   307,   373,     0,
   374,   377,   379,   381,     0,   383,   385,     0,     0,   390,
   393,     0,     0,     0,     0,   325,   326,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   364,     0,   410,   247,
   251,     0,   248,   252,     0,     0,   427,   428,   257,   265,
     0,     0,     0,    92,     0,   422,     0,   239,   245,     0,
   359,   261,    75,   151,     0,   421,     0,    23,   253,   264,
     0,    91,    68,    84,   331,     0,   182,   184,   167,   170,
   168,   172,   198,   200,     0,   202,     0,     0,   217,   219,
   220,     0,    94,     0,     0,     0,     0,   116,     0,   126,
   117,   120,   128,   121,     0,   123,   131,   133,   134,   136,
   138,     0,   140,     0,   141,     0,   155,     0,   179,   439,
     0,     0,   142,     0,   186,     0,   189,     0,   193,     0,
     0,     0,     0,   441,     0,     0,     0,   235,   440,     0,
     0,   244,   267,   268,     0,   325,   295,     0,   298,    -2,
    -2,   282,     0,     0,   420,     0,   368,   419,   285,     0,
     0,   274,     0,     0,     0,     0,     0,   306,     0,     0,
     0,   382,     0,     0,     0,     0,   386,   387,     0,   287,
   288,   291,   292,   322,     0,   315,     0,   318,     0,     0,
     0,     0,   354,   355,     0,   360,   440,   365,     0,     0,
   255,     0,    71,    84,    73,    84,    81,    84,   145,     0,
     0,     0,     0,   259,     0,   350,    -2,     0,   416,   418,
    67,     0,    85,    86,    88,    89,     0,     0,     0,     0,
     0,     0,   201,     0,   206,     0,    96,     0,    98,   100,
   102,   413,   105,     0,     0,     0,   110,   111,   112,   118,
   122,   137,   139,   135,   157,   161,     0,     0,   412,   163,
   165,   143,   188,   191,   195,   197,   225,     0,   232,     0,
   440,   240,     0,   440,   440,     0,     0,   405,     0,     0,
   396,     0,     0,   383,   369,   370,     0,   276,   305,   375,
   376,     0,   378,   380,    -2,   388,   389,   391,   392,   394,
     0,     0,     0,     0,     0,     0,   299,     0,     0,     0,
     0,   357,     0,     0,     0,     0,     0,   411,     0,     0,
     0,     0,     0,   423,     0,     0,     0,     0,   260,   349,
     0,   414,     0,     0,     0,     0,   332,     0,   334,     0,
   336,   331,   338,   346,     0,     0,   339,   340,   341,   342,
   343,   344,   345,   181,   183,     0,   171,     0,   174,   176,
   203,   209,   211,     0,   215,    -2,   213,   433,     0,     0,
   436,   437,   438,    -2,   218,     0,    97,     0,     0,     0,
   106,     0,     0,     0,   114,   115,   178,   180,     0,     0,
     0,     0,     0,     0,     0,     0,   279,     0,     0,   296,
   297,   283,   415,   366,     0,   286,   397,   289,   293,   323,
   316,   319,     0,     0,     0,     0,     0,   356,     0,   362,
   440,   361,   249,   254,     0,     0,     0,     0,     0,     0,
   425,   424,     0,   246,   278,   351,   352,   417,    69,    87,
   330,   333,   335,     0,   347,   348,   185,   372,   173,     0,
     0,     0,     0,     0,   434,   435,     0,    99,   101,   103,
     0,   109,   108,     0,   226,   231,   233,     0,   241,   236,
     0,     0,   280,     0,   371,     0,     0,     0,   301,   303,
   310,   300,   312,   314,   358,     0,     0,   262,     0,   258,
    72,    74,    82,   426,   337,   175,   177,   204,   210,   212,
   216,     0,     0,   107,   113,   234,   237,   440,   281,     0,
   290,   294,     0,   363,     0,     0,   256,   221,     0,     0,
   308,   302,   250,   263,   222,     0,     0,   242,   223 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif


/* @(#)27       1.7.1.1  com/cmd/lang/yacc/yaccpar,
 cmdlang, bos320, 9209320f 2/19/92 16:36:02 */
/*
 * COMPONENT_NAME: (CMDLANG) Language Utilities
 *
 * FUNCTIONS: yyparse
 * ORIGINS: 03
 */
/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#ifdef YYSPLIT
#   define YYERROR      return(-2)
#else
#   define YYERROR      goto yyerrlab
#endif
#ifdef YACC_MSG
#ifndef _XOPEN_SOURCE
#define _XOPEN_SOURCE
#endif
#include <nl_types.h>
nl_catd catd;
#endif
#define YYACCEPT        return(0)
#define YYABORT         return(1)
#ifndef YACC_MSG
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		YYERROR;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#else
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		catd=catopen("yacc_user.cat",0);\
		yyerror(catgets(catd,1,1,"syntax error - cannot backup" ));\
		YYERROR;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#endif
#define YYRECOVERING()  (!!yyerrflag)
#ifndef YYDEBUG
#       define YYDEBUG  1       /* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;                    /* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG          (-1000)

#ifdef YYSPLIT
#   define YYSCODE { \
			extern int (*_yyf[])(); \
			register int yyret; \
			if (_yyf[yytmp]) \
			    if ((yyret=(*_yyf[yytmp])()) == -2) \
				    goto yyerrlab; \
				else if (yyret>=0) return(yyret); \
		   }
#endif

/*
** global variables used by the parser
*/
YYSTYPE yyv[ YYMAXDEPTH ];      /* value stack */
int yys[ YYMAXDEPTH ];          /* state stack */

YYSTYPE *yypv;                  /* top of value stack */
YYSTYPE *yypvt;                 /* top of value stack for $vars */
int *yyps;                      /* top of state stack */

int yystate;                    /* current state */
int yytmp;                      /* extra var (lasts between blocks) */

int yynerrs;                    /* number of errors */
int yyerrflag;                  /* error recovery flag */
int yychar;                     /* current input token number */

#ifdef __cplusplus
 #ifdef _CPP_IOSTREAMS
  #include <iostream.h>
  extern void yyerror (char *);
/* error message routine -- iostream version */
 #else
  #include <stdio.h>
  extern "C" void yyerror (char *);
/* error message routine -- stdio version */
 #endif /* _CPP_IOSTREAMS */
 extern "C" int yylex(void);        /* return the next token */
#endif /* __cplusplus */


/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
#ifdef __cplusplus
extern "C"
#endif /* __cplusplus */
int
yyparse()
{
	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;
#ifdef YACC_MSG
	catd=catopen("yacc_user.cat",0);
#endif
	goto yystack;
	{
		register YYSTYPE *yy_pv;        /* top of value stack */
		register int *yy_ps;            /* top of state stack */
		register int yy_state;          /* current state */
		register int  yy_n;             /* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
		if ( ++yy_ps >= &yys[ YYMAXDEPTH ] )    /* room on stack? */
		{
#ifndef YACC_MSG
			yyerror( "yacc stack overflow" );
#else
			yyerror(catgets(catd,1,2,"yacc stack overflow" ));
#endif
			YYABORT;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;         /* simple state */
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;             /* reached EOF */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )  /*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;             /* reached EOF */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )        /* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:         /* new error */
#ifndef YACC_MSG
				yyerror( "syntax error" );
#else
				yyerror(catgets(catd,1,3,"syntax error" ));
#endif
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:         /* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)                                        {
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:         /* no shift yet; eat a token */
				if ( yychar == 0 )      /* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
		yytmp = yy_n;                   /* value to switch over */
		yypvt = yy_pv;                  /* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1]; /* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1]; /* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/

		switch(yytmp){

case 5:
# line 216 "fortran.y"
{
				/* Create id token for prog if unnamed. */
			  if(current_module_hash == -1) {
			    implied_id_token(&(yypvt[-0]),unnamed_prog);
			    def_function(
				type_PROGRAM,&(yypvt[-0]),(Token*)NULL);
			    current_module_hash =
			      def_curr_module(&(yypvt[-0]));
			    current_module_type = type_PROGRAM;
			  }
			  prev_stmt_class = curr_stmt_class;
			  integer_context = FALSE;
			} /*NOTREACHED*/ break;
case 6:
# line 230 "fortran.y"
{
			  if(current_module_hash == -1) {
			    implied_id_token(&(yypvt[-0]),unnamed_prog);
			    def_function(
				type_PROGRAM,&(yypvt[-0]),(Token*)NULL);
			    current_module_hash =
			      def_curr_module(&(yypvt[-0]));
			    current_module_type = type_PROGRAM;
			  }
			  if(prev_stmt_class != tok_RETURN)
			    do_RETURN(current_module_hash,&(yypvt[-0]));
			  END_processing(&(yyval));
			  goto_flag = prev_goto = FALSE;
			  prev_stmt_class = curr_stmt_class;
			} /*NOTREACHED*/ break;
case 9:
# line 255 "fortran.y"
{
#ifdef CHECK_LABELS
			  def_label(&(yypvt[-1]));
#endif
			  if(executable_stmt)
			    prev_goto = goto_flag;
			} /*NOTREACHED*/ break;
case 10:
# line 263 "fortran.y"
{
			  if(executable_stmt) {
			    if(prev_goto)
				syntax_error(yypvt[-0].line_num, NO_COL_NUM,
					"No path to this statement");
			    prev_goto = goto_flag;
			  }
			} /*NOTREACHED*/ break;
case 11:
# line 274 "fortran.y"
{
			    exec_stmt_count = 0;
			    executable_stmt = FALSE;
			} /*NOTREACHED*/ break;
case 12:
# line 279 "fortran.y"
{
			    executable_stmt = FALSE;
			} /*NOTREACHED*/ break;
case 13:
# line 283 "fortran.y"
{	/* handle statement functions correctly */
			  if(is_true(STMT_FUNCTION_EXPR, yypvt[-0].subclass)
				     && stmt_sequence_no <= seq_stmt_fun) {
			    stmt_sequence_no = seq_stmt_fun;
			    executable_stmt = FALSE;
			  }
			  else {
			    stmt_sequence_no = seq_exec;
			    ++exec_stmt_count;
			    executable_stmt = TRUE;
			  }
			} /*NOTREACHED*/ break;
case 14:
# line 296 "fortran.y"
{
			    stmt_sequence_no = seq_exec;
			    ++exec_stmt_count;
			    executable_stmt = TRUE;
			} /*NOTREACHED*/ break;
case 15:
# line 302 "fortran.y"
{
			    executable_stmt = TRUE;
			    if(stmt_sequence_no == 0)
			      stmt_sequence_no = seq_header;
			    complex_const_allowed = FALSE; /* turn off flags */
			    inside_format=FALSE;
			    integer_context = FALSE;
			    yyval.line_num = prev_stmt_line_num; /* best guess */
			    yyerrok; /* (error message already given) */
			} /*NOTREACHED*/ break;
case 16:
# line 315 "fortran.y"
{
			    current_module_type = type_PROGRAM;
			} /*NOTREACHED*/ break;
case 17:
# line 319 "fortran.y"
{
			    current_module_type = type_SUBROUTINE;
			} /*NOTREACHED*/ break;
case 18:
# line 323 "fortran.y"
{
			    current_module_type = type_SUBROUTINE;
			} /*NOTREACHED*/ break;
case 19:
# line 327 "fortran.y"
{
			    current_module_type = type_BLOCK_DATA;
			} /*NOTREACHED*/ break;
case 23:
# line 340 "fortran.y"
{
#ifdef ALLOW_INCLUDE
			  if(f77_standard) {
			      nonstandard(yypvt[-2].line_num,yypvt[-2].col_num);
			  }
			   open_include_file(yypvt[-1].value.string);
#else
			  syntax_error(yypvt[-2].line_num,yypvt[-2].col_num,
				"statement not permitted");
#endif
			 } /*NOTREACHED*/ break;
case 24:
# line 360 "fortran.y"
{
			     if(stmt_sequence_no < seq_implicit) {
				   stmt_sequence_no = seq_implicit;
			     }
			     goto_flag = prev_goto = FALSE;
			} /*NOTREACHED*/ break;
case 25:
# line 367 "fortran.y"
{
			     if(stmt_sequence_no < seq_implicit) {
				stmt_sequence_no = seq_implicit;
			     }
			} /*NOTREACHED*/ break;
case 26:
# line 373 "fortran.y"
{
			     if(stmt_sequence_no > seq_specif) {
				   syntax_error(yypvt[-0].line_num, NO_COL_NUM,
					"Statement out of order.");
			     }
			     else {
				if(stmt_sequence_no < seq_implicit) {
				   stmt_sequence_no = seq_implicit;
				}
			     }
			} /*NOTREACHED*/ break;
case 27:
# line 385 "fortran.y"
{
			     if(stmt_sequence_no > seq_implicit) {
				 syntax_error(yypvt[-0].line_num, NO_COL_NUM,
					"Statement out of order.");
			     }
			     else {
				    stmt_sequence_no = seq_implicit;
			     }
			} /*NOTREACHED*/ break;
case 28:
# line 395 "fortran.y"
{
			     if(stmt_sequence_no < seq_stmt_fun) {
				stmt_sequence_no = seq_stmt_fun;
			      }
			} /*NOTREACHED*/ break;
case 29:
# line 401 "fortran.y"
{
			    if(stmt_sequence_no > seq_specif) {
				syntax_error(yypvt[-0].line_num, NO_COL_NUM,
					"Statement out of order.");
			    }
			    else {
				stmt_sequence_no = seq_specif;
			    }
			} /*NOTREACHED*/ break;
case 30:
# line 411 "fortran.y"
{
			    if(stmt_sequence_no > seq_specif) {
				syntax_error(yypvt[-0].line_num, NO_COL_NUM,
					"Statement out of order.");
			    }
			    else {
				stmt_sequence_no = seq_specif;
			    }
			} /*NOTREACHED*/ break;
case 31:
# line 421 "fortran.y"
{
			    if(stmt_sequence_no > seq_specif) {
				syntax_error(yypvt[-0].line_num, NO_COL_NUM,
					"Statement out of order.");
			    }
			    else {
				stmt_sequence_no = seq_specif;
			    }
			} /*NOTREACHED*/ break;
case 32:
# line 431 "fortran.y"
{
			    if(stmt_sequence_no > seq_specif) {
				syntax_error(yypvt[-0].line_num, NO_COL_NUM,
					"Statement out of order.");
			    }
			    else {
				stmt_sequence_no = seq_specif;
			    }
			} /*NOTREACHED*/ break;
case 33:
# line 441 "fortran.y"
{
			    if(stmt_sequence_no > seq_specif) {
				syntax_error(yypvt[-0].line_num, NO_COL_NUM,
					"Statement out of order.");
			    }
			    else {
				stmt_sequence_no = seq_specif;
			    }
			} /*NOTREACHED*/ break;
case 34:
# line 451 "fortran.y"
{
			    if(stmt_sequence_no > seq_specif) {
				syntax_error(yypvt[-0].line_num, NO_COL_NUM,
					"Statement out of order.");
			    }
			    else {
				stmt_sequence_no = seq_specif;
			    }
			} /*NOTREACHED*/ break;
case 35:
# line 461 "fortran.y"
{
			    if(stmt_sequence_no > seq_specif) {
				syntax_error(yypvt[-0].line_num, NO_COL_NUM,
					"Statement out of order.");
			    }
			    else {
				stmt_sequence_no = seq_specif;
			    }
			} /*NOTREACHED*/ break;
case 36:
# line 471 "fortran.y"
{
			    if(stmt_sequence_no > seq_specif) {
				syntax_error(yypvt[-0].line_num, NO_COL_NUM,
					"Statement out of order.");
			    }
			    else {
				stmt_sequence_no = seq_specif;
			    }
			} /*NOTREACHED*/ break;
case 37:
# line 486 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 38:
# line 490 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 39:
# line 494 "fortran.y"
{
			    goto_flag=TRUE;
			} /*NOTREACHED*/ break;
case 40:
# line 498 "fortran.y"
{
			    goto_flag=FALSE;	/* fallthru allowed */
			} /*NOTREACHED*/ break;
case 41:
# line 502 "fortran.y"
{
			    goto_flag=TRUE;
			} /*NOTREACHED*/ break;
case 42:
# line 506 "fortran.y"
{
			    goto_flag=TRUE;
			} /*NOTREACHED*/ break;
case 43:
# line 510 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 44:
# line 514 "fortran.y"
{
			    goto_flag=TRUE;
			} /*NOTREACHED*/ break;
case 45:
# line 518 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 46:
# line 522 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 47:
# line 526 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 48:
# line 530 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 49:
# line 534 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 50:
# line 538 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 51:
# line 542 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 52:
# line 546 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 53:
# line 550 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 54:
# line 554 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 55:
# line 558 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 56:
# line 562 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 57:
# line 566 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 58:
# line 570 "fortran.y"
{
			    goto_flag=TRUE;
			} /*NOTREACHED*/ break;
case 59:
# line 577 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 60:
# line 581 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 61:
# line 585 "fortran.y"
{
			    prev_goto = goto_flag =FALSE;
			} /*NOTREACHED*/ break;
case 62:
# line 589 "fortran.y"
{
			    prev_goto = goto_flag =FALSE;
			} /*NOTREACHED*/ break;
case 63:
# line 593 "fortran.y"
{
			    prev_goto = goto_flag =FALSE;
			} /*NOTREACHED*/ break;
case 64:
# line 597 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 65:
# line 601 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 66:
# line 607 "fortran.y"
{check_seq_header(&(yypvt[-0]));} /*NOTREACHED*/ break;
case 67:
# line 609 "fortran.y"
{
			     def_function(
				type_PROGRAM,&(yypvt[-1]),(Token*)NULL);
			     current_module_hash =
			       def_curr_module(&(yypvt[-1]));
			} /*NOTREACHED*/ break;
case 68:
# line 622 "fortran.y"
{
			  do_ENTRY(&(yypvt[-1]),(Token*)NULL
				   ,current_module_hash);
			} /*NOTREACHED*/ break;
case 69:
# line 627 "fortran.y"
{
			  do_ENTRY(&(yypvt[-4]),&(yypvt[-2])
				   ,current_module_hash);
			     if(debug_parser)
				print_exprlist("entry stmt",&(yypvt[-2]));
			} /*NOTREACHED*/ break;
case 71:
# line 641 "fortran.y"
{
			     if(f77_standard) {
				nonstandard(yypvt[-1].line_num,
				  yypvt[-1].col_num+strlen(token_name(yypvt[-1])));
				msg_tail(": parentheses required");
			     }
			 def_function(
				current_datatype,&(yypvt[-1]),(Token*)NULL);
			 current_module_hash=
			   def_curr_module(&(yypvt[-1]));
			} /*NOTREACHED*/ break;
case 72:
# line 654 "fortran.y"
{
			 def_function(
				current_datatype,&(yypvt[-4]),&(yypvt[-2]));
			 current_module_hash=
			   def_curr_module(&(yypvt[-4]));
			 if(debug_parser)
			   print_exprlist("function stmt",&(yypvt[-2]));
			} /*NOTREACHED*/ break;
case 73:
# line 663 "fortran.y"
{
			     if(f77_standard) {
				nonstandard(yypvt[-1].line_num,
				  yypvt[-1].col_num+strlen(token_name(yypvt[-1])));
				msg_tail(": parentheses required");
			     }
			 def_function(
				type_UNDECL,&(yypvt[-1]),(Token*)NULL);
			 current_module_hash=
			   def_curr_module(&(yypvt[-1]));
			} /*NOTREACHED*/ break;
case 74:
# line 676 "fortran.y"
{
			 def_function(
				type_UNDECL,&(yypvt[-4]),&(yypvt[-2]));
			 current_module_hash=
			   def_curr_module(&(yypvt[-4]));
			 if(debug_parser)
			   print_exprlist("function stmt",&(yypvt[-2]));
			} /*NOTREACHED*/ break;
case 75:
# line 688 "fortran.y"
{
			  check_seq_header(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 76:
# line 695 "fortran.y"
{
			  check_seq_header(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 81:
# line 714 "fortran.y"
{
			  def_function(
				 type_SUBROUTINE,&(yypvt[-1]),(Token*)NULL);
			  current_module_hash=
			    def_curr_module(&(yypvt[-1]));
			} /*NOTREACHED*/ break;
case 82:
# line 722 "fortran.y"
{
			  def_function(
				 type_SUBROUTINE,&(yypvt[-4]),&(yypvt[-2]));
			  current_module_hash=
			    def_curr_module(&(yypvt[-4]));
			  if(debug_parser)
			    print_exprlist("subroutine stmt",&(yypvt[-2]));
			} /*NOTREACHED*/ break;
case 83:
# line 733 "fortran.y"
{
			  check_seq_header(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 84:
# line 739 "fortran.y"
{
			    yyval.next_token = (Token*)NULL;
			} /*NOTREACHED*/ break;
case 86:
# line 746 "fortran.y"
{
			    yyval.next_token = append_token((Token*)NULL,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 87:
# line 750 "fortran.y"
{
			    yyval.next_token = append_token(yypvt[-2].next_token,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 88:
# line 756 "fortran.y"
{
			     def_arg_name(&(yypvt[-0]));
			     primary_id_expr(&(yypvt[-0]),&(yyval));
			} /*NOTREACHED*/ break;
case 89:
# line 761 "fortran.y"
{
			     yyval.class = type_byte(class_LABEL,type_LABEL);
			     yyval.subclass = 0;
			} /*NOTREACHED*/ break;
case 90:
# line 771 "fortran.y"
{
				  /* form name %DATnn */
			  ++block_data_number;
			  sprintf(unnamed_block_data+4,"%02d"
				  ,block_data_number%100);
			  implied_id_token(&(yyval),unnamed_block_data);

			  def_function(
				 type_BLOCK_DATA,&(yyval),(Token*)NULL);
			  current_module_hash=
			    def_curr_module(&(yyval));
			} /*NOTREACHED*/ break;
case 91:
# line 784 "fortran.y"
{
			  def_function(
				 type_BLOCK_DATA,&(yypvt[-1]),(Token*)NULL);
			  current_module_hash=
			    def_curr_module(&(yypvt[-1]));
			} /*NOTREACHED*/ break;
case 92:
# line 793 "fortran.y"
{
			  check_seq_header(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 93:
# line 797 "fortran.y"
{
			  check_seq_header(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 97:
# line 812 "fortran.y"
{
			     def_array_dim(&(yypvt[-3]),&(yypvt[-1]));
			} /*NOTREACHED*/ break;
case 98:
# line 819 "fortran.y"
{
			     yyval.class = 1;
			     yyval.subclass = yypvt[-0].subclass;
			} /*NOTREACHED*/ break;
case 99:
# line 824 "fortran.y"
{
			     yyval.class = yypvt[-2].class + 1; /* one more dimension */
			     yyval.subclass = yypvt[-2].subclass * yypvt[-0].subclass;
			} /*NOTREACHED*/ break;
case 100:
# line 831 "fortran.y"
{
			      yyval.subclass = yypvt[-0].value.integer;
			} /*NOTREACHED*/ break;
case 101:
# line 835 "fortran.y"
{	/* avoid getting 0 - 0 + 1 = 1 if bounds nonconstant */
			      if( datatype_of(yypvt[-2].class) == type_INTEGER
				 && is_true(CONST_EXPR,yypvt[-2].subclass)
				 && datatype_of(yypvt[-0].class) == type_INTEGER
				 && is_true(CONST_EXPR,yypvt[-0].subclass) )
				yyval.subclass = yypvt[-0].value.integer - yypvt[-2].value.integer + 1;
			      else
				yyval.subclass = 0;
			} /*NOTREACHED*/ break;
case 102:
# line 845 "fortran.y"
{
			     yyval.subclass = 0;
			} /*NOTREACHED*/ break;
case 103:
# line 849 "fortran.y"
{
			     yyval.subclass = 0;
			} /*NOTREACHED*/ break;
case 104:
# line 855 "fortran.y"
{equivalence_flag = TRUE;} /*NOTREACHED*/ break;
case 105:
# line 856 "fortran.y"
{equivalence_flag = FALSE;} /*NOTREACHED*/ break;
case 108:
# line 864 "fortran.y"
{
			  equivalence(&(yypvt[-2]), &(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 109:
# line 868 "fortran.y"
{
			  equivalence(&(yypvt[-2]), &(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 110:
# line 875 "fortran.y"
{
			     def_equiv_name(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 111:
# line 879 "fortran.y"
{
			     def_equiv_name(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 112:
# line 883 "fortran.y"
{
			     def_equiv_name(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 116:
# line 898 "fortran.y"
{
			     implied_id_token(&(yyval),blank_com_name);
			     def_com_block(&(yyval), &(yypvt[-1]));
			     if(is_true(COMMA_FLAG,yypvt[-1].subclass))
				   syntax_error(
					     yypvt[-1].line_num,yypvt[-1].col_num,
					     "trailing comma");
			     if(debug_parser)
				print_comlist("blank common",&(yypvt[-1]));

			} /*NOTREACHED*/ break;
case 117:
# line 910 "fortran.y"
{
			     if(is_true(COMMA_FLAG,yypvt[-1].subclass))
				syntax_error(
					     yypvt[-1].line_num,yypvt[-1].col_num,
					     "trailing comma");

			} /*NOTREACHED*/ break;
case 118:
# line 918 "fortran.y"
{
			     implied_id_token(&(yyval),blank_com_name);
			     def_com_block(&(yyval),&(yypvt[-2]));
			     if(is_true(COMMA_FLAG,yypvt[-1].subclass))
				syntax_error(
					     yypvt[-1].line_num,yypvt[-1].col_num,
					     "trailing comma");
			     if(debug_parser)
				print_comlist("blank common",&(yypvt[-2]));

			} /*NOTREACHED*/ break;
case 119:
# line 935 "fortran.y"
{
			     yyval.subclass = yypvt[-0].subclass;
			} /*NOTREACHED*/ break;
case 120:
# line 939 "fortran.y"
{
			     yyval.subclass = yypvt[-0].subclass;
			     yyval.line_num = yypvt[-0].line_num;
			     yyval.col_num = yypvt[-0].col_num;
			} /*NOTREACHED*/ break;
case 121:
# line 947 "fortran.y"
{
			     def_com_block(&(yypvt[-1]),&(yypvt[-0]));
			     yyval.subclass = yypvt[-0].subclass;
			     yyval.line_num = yypvt[-0].line_num;
			     yyval.col_num = yypvt[-0].col_num;
			     if(debug_parser)
				print_comlist("labeled common",&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 122:
# line 958 "fortran.y"
{
			     yyval = yypvt[-1];
			} /*NOTREACHED*/ break;
case 123:
# line 963 "fortran.y"
{
			     implied_id_token(&(yyval),blank_com_name);
			} /*NOTREACHED*/ break;
case 124:
# line 967 "fortran.y"
{
			     implied_id_token(&(yyval),blank_com_name);
			} /*NOTREACHED*/ break;
case 125:
# line 973 "fortran.y"
{
			    yyval.subclass = yypvt[-0].subclass;
			    yyval.next_token = append_token((Token*)NULL,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 126:
# line 978 "fortran.y"
{
			    if(!is_true(COMMA_FLAG,yypvt[-1].subclass))
				syntax_error(
					yypvt[-0].line_num,yypvt[-0].col_num-1,
					"missing comma");
			    yyval.subclass = yypvt[-0].subclass;
			    yyval.line_num = yypvt[-0].line_num;
			    yyval.col_num = yypvt[-0].col_num;
			    yyval.next_token = append_token(yypvt[-1].next_token,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 127:
# line 991 "fortran.y"
{			   /* no comma */
			     yyval.subclass = yypvt[-0].subclass;
			     make_false(COMMA_FLAG,yyval.subclass);
			} /*NOTREACHED*/ break;
case 128:
# line 996 "fortran.y"
{			   /* has comma */
			     yyval.subclass = yypvt[-1].subclass;
			     make_true(COMMA_FLAG,yyval.subclass);
			   } /*NOTREACHED*/ break;
case 129:
# line 1003 "fortran.y"
{
			     def_com_variable(&(yypvt[-0]));
			     primary_id_expr(&(yypvt[-0]),&(yyval));
			} /*NOTREACHED*/ break;
case 130:
# line 1008 "fortran.y"
{
			     def_com_variable(&(yypvt[-0]));
			     primary_id_expr(&(yypvt[-0]),&(yyval));
			} /*NOTREACHED*/ break;
case 131:
# line 1021 "fortran.y"
{
			    if(is_true(COMMA_FLAG,yypvt[-1].subclass))
				syntax_error(
				 yypvt[-1].line_num,yypvt[-1].col_num+strlen(token_name(yypvt[-1])),
					"trailing comma");
			    if(f77_standard) {
				nonstandard(yypvt[-2].line_num,yypvt[-2].col_num);
			    }
			} /*NOTREACHED*/ break;
case 133:
# line 1034 "fortran.y"
{
			    yyval = yypvt[-0];
			} /*NOTREACHED*/ break;
case 134:
# line 1040 "fortran.y"
{
			     def_namelist(&(yypvt[-1]),&(yypvt[-0]));
			     yyval = yypvt[-0];
			} /*NOTREACHED*/ break;
case 135:
# line 1047 "fortran.y"
{
			    yyval = yypvt[-1];
			} /*NOTREACHED*/ break;
case 136:
# line 1053 "fortran.y"
{
			     yyval.next_token = append_token((Token*)NULL,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 137:
# line 1057 "fortran.y"
{
			    if(!is_true(COMMA_FLAG,yypvt[-1].subclass))
				syntax_error(
					yypvt[-0].line_num,yypvt[-0].col_num-1,
					"missing comma");
			    yyval.subclass = yypvt[-0].subclass;
			    yyval.line_num = yypvt[-0].line_num;
			    yyval.col_num = yypvt[-0].col_num;
			    yyval.next_token = append_token(yypvt[-1].next_token,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 138:
# line 1070 "fortran.y"
{			   /* no comma */
			     def_namelist_item(&(yypvt[-0]));
			     primary_id_expr(&(yypvt[-0]),&(yyval));
			     make_false(COMMA_FLAG,yyval.subclass);
			} /*NOTREACHED*/ break;
case 139:
# line 1076 "fortran.y"
{			   /* has comma */
			     def_namelist_item(&(yypvt[-1]));
			     primary_id_expr(&(yypvt[-1]),&(yyval));
			     make_true(COMMA_FLAG,yyval.subclass);
			} /*NOTREACHED*/ break;
case 145:
# line 1094 "fortran.y"
{
				/* Only REAL*8 is actually recognized */
			    if(current_datatype == type_REAL
			       && yypvt[-0].value.integer == 8)
				current_datatype = type_DP;

			     if(f77_standard) {
				nonstandard(yypvt[-0].line_num,yypvt[-0].col_num);
			     }
			} /*NOTREACHED*/ break;
case 147:
# line 1109 "fortran.y"
{
			     current_datatype = type_INTEGER;
			     integer_context = TRUE;
			} /*NOTREACHED*/ break;
case 148:
# line 1114 "fortran.y"
{
			     current_datatype = type_REAL;
			     integer_context = TRUE;
			} /*NOTREACHED*/ break;
case 149:
# line 1119 "fortran.y"
{
			     current_datatype = type_COMPLEX;
			     integer_context = TRUE;
			} /*NOTREACHED*/ break;
case 150:
# line 1124 "fortran.y"
{
			     current_datatype = type_LOGICAL;
			     integer_context = TRUE;
			} /*NOTREACHED*/ break;
case 151:
# line 1131 "fortran.y"
{
			     current_datatype = type_DP;
			} /*NOTREACHED*/ break;
case 152:
# line 1135 "fortran.y"
{
			     current_datatype = type_DP;
			} /*NOTREACHED*/ break;
case 153:
# line 1139 "fortran.y"
{
			     current_datatype = type_INTEGER;
			     if(f77_standard)
			       nonstandard(yypvt[-0].line_num,yypvt[-0].col_num);
			} /*NOTREACHED*/ break;
case 154:
# line 1147 "fortran.y"
{
			     current_datatype = type_STRING;
			     integer_context = TRUE;
			} /*NOTREACHED*/ break;
case 155:
# line 1154 "fortran.y"
{
			     current_datatype = type_STRING;
			} /*NOTREACHED*/ break;
case 158:
# line 1164 "fortran.y"
{
			     declare_type(&(yypvt[-0]),current_datatype);
			} /*NOTREACHED*/ break;
case 159:
# line 1168 "fortran.y"
{
			     declare_type(&(yypvt[-0]),current_datatype);
			} /*NOTREACHED*/ break;
case 162:
# line 1178 "fortran.y"
{
			     declare_type(&(yypvt[-0]),current_datatype);
			} /*NOTREACHED*/ break;
case 163:
# line 1182 "fortran.y"
{
			     declare_type(&(yypvt[-2]),current_datatype);
			} /*NOTREACHED*/ break;
case 164:
# line 1186 "fortran.y"
{
			     declare_type(&(yypvt[-0]),current_datatype);
			} /*NOTREACHED*/ break;
case 165:
# line 1190 "fortran.y"
{
			     declare_type(&(yypvt[-2]),current_datatype);
			} /*NOTREACHED*/ break;
case 166:
# line 1197 "fortran.y"
{implicit_flag=TRUE;} /*NOTREACHED*/ break;
case 167:
# line 1201 "fortran.y"
{
			    {implicit_flag=FALSE;}
			    if(implicit_none) {
				syntax_error(yypvt[-2].line_num,yypvt[-2].col_num,
				     "conflicts with IMPLICIT NONE");
			    }
			    else {
				implicit_type_given = TRUE;
			    }
			} /*NOTREACHED*/ break;
case 168:
# line 1212 "fortran.y"
{
			    int h=yypvt[-1].value.integer;
			    {implicit_flag=FALSE;}
			    if( strcmp(hashtab[h].name,"NONE") == 0 ) {
				if(implicit_type_given) {
				    syntax_error(yypvt[-2].line_num,yypvt[-2].col_num,
					 "conflicts with IMPLICIT statement");
				}
				else {
				    if(f77_standard)
				      nonstandard(yypvt[-1].line_num,yypvt[-1].col_num);
				    implicit_none = TRUE;
				}
			    }
			    else {
				syntax_error(yypvt[-1].line_num,yypvt[-1].col_num,
				     "unknown keyword -- ignored");
			    }
			} /*NOTREACHED*/ break;
case 170:
# line 1234 "fortran.y"
{initial_flag = TRUE;} /*NOTREACHED*/ break;
case 172:
# line 1240 "fortran.y"
{implicit_letter_flag = TRUE;} /*NOTREACHED*/ break;
case 173:
# line 1241 "fortran.y"
{implicit_letter_flag = FALSE;} /*NOTREACHED*/ break;
case 176:
# line 1249 "fortran.y"
{
			     set_implicit_type(current_datatype,
					     (int)yypvt[-0].subclass,(int)yypvt[-0].subclass);
			} /*NOTREACHED*/ break;
case 177:
# line 1254 "fortran.y"
{
			     set_implicit_type(current_datatype,
					(int)yypvt[-2].subclass,(int)yypvt[-0].subclass);
			} /*NOTREACHED*/ break;
case 184:
# line 1275 "fortran.y"
{complex_const_allowed = TRUE;} /*NOTREACHED*/ break;
case 185:
# line 1277 "fortran.y"
{
			     def_parameter(&(yypvt[-3]),&(yypvt[-0]));
			     complex_const_allowed = FALSE;
			} /*NOTREACHED*/ break;
case 187:
# line 1288 "fortran.y"
{
			     def_ext_name(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 188:
# line 1292 "fortran.y"
{
			     def_ext_name(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 190:
# line 1302 "fortran.y"
{
			     def_intrins_name(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 191:
# line 1306 "fortran.y"
{
			     def_intrins_name(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 196:
# line 1321 "fortran.y"
{
			     ref_variable(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 197:
# line 1325 "fortran.y"
{
			     def_com_block(&(yypvt[-1]),(Token*)NULL);
			} /*NOTREACHED*/ break;
case 202:
# line 1340 "fortran.y"
{complex_const_allowed=TRUE;} /*NOTREACHED*/ break;
case 203:
# line 1342 "fortran.y"
{complex_const_allowed=FALSE;} /*NOTREACHED*/ break;
case 207:
# line 1351 "fortran.y"
{
			     use_lvalue(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 214:
# line 1367 "fortran.y"
{
			     use_parameter(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 216:
# line 1374 "fortran.y"
{
			     use_parameter(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 219:
# line 1385 "fortran.y"
{
			     use_lvalue(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 221:
# line 1393 "fortran.y"
{
			    use_implied_do_index(&(yypvt[-3]));
			} /*NOTREACHED*/ break;
case 224:
# line 1404 "fortran.y"
{complex_const_allowed = TRUE;} /*NOTREACHED*/ break;
case 225:
# line 1405 "fortran.y"
{
			  assignment_stmt_type(&(yypvt[-3]),&(yypvt[-2]),
					&(yypvt[-0]));
			  complex_const_allowed = FALSE;
			} /*NOTREACHED*/ break;
case 226:
# line 1411 "fortran.y"
{
				/* Clear u-b-s flags spuriously set */
			  if(is_true(STMT_FUNCTION_EXPR, yypvt[-5].subclass)
				     && stmt_sequence_no <= seq_stmt_fun)
			     stmt_function_stmt(&(yypvt[-5]));
			} /*NOTREACHED*/ break;
case 231:
# line 1429 "fortran.y"
{
			    do_ASSIGN(&(yypvt[-1]));
			} /*NOTREACHED*/ break;
case 235:
# line 1446 "fortran.y"
{
			     do_assigned_GOTO(&(yypvt[-1]));
			} /*NOTREACHED*/ break;
case 236:
# line 1450 "fortran.y"
{
			     do_assigned_GOTO(&(yypvt[-4]));
			} /*NOTREACHED*/ break;
case 237:
# line 1454 "fortran.y"
{
			     do_assigned_GOTO(&(yypvt[-5]));
			} /*NOTREACHED*/ break;
case 242:
# line 1470 "fortran.y"
{
			  int t=datatype_of(yypvt[-9].class);
			  if(t != type_INTEGER && t != type_REAL
			     && t != type_DP && t != type_ERROR ) {
			    syntax_error(yypvt[-9].line_num,yypvt[-9].col_num,
		  "integer, real, or double precision expression required");
			  }
			} /*NOTREACHED*/ break;
case 243:
# line 1482 "fortran.y"
{
			  int t=datatype_of(yypvt[-1].class);
			  if(t != type_LOGICAL && t != type_ERROR)
			     syntax_error(yypvt[-1].line_num,yypvt[-1].col_num,
					  "logical expression required");
			} /*NOTREACHED*/ break;
case 244:
# line 1492 "fortran.y"
{
			  int t=datatype_of(yypvt[-2].class);
			  if(t != type_LOGICAL && t != type_ERROR)
			     syntax_error(yypvt[-2].line_num,yypvt[-2].col_num,
					  "logical expression required");
			} /*NOTREACHED*/ break;
case 245:
# line 1500 "fortran.y"
{complex_const_allowed = TRUE;} /*NOTREACHED*/ break;
case 246:
# line 1501 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-1].subclass)){
				use_variable(&(yypvt[-1]));
			    }
			    complex_const_allowed = FALSE;

			    initial_flag = TRUE;	/* for is_keyword */
			    yyval = yypvt[-1]; /* Inherit expr for type checking above */
			} /*NOTREACHED*/ break;
case 248:
# line 1514 "fortran.y"
{complex_const_allowed = TRUE;} /*NOTREACHED*/ break;
case 249:
# line 1515 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-1].subclass)){
				use_variable(&(yypvt[-1]));
			    }
			    complex_const_allowed = FALSE;

			    initial_flag = TRUE;
			} /*NOTREACHED*/ break;
case 254:
# line 1545 "fortran.y"
{
			     use_lvalue(&(yypvt[-3]));
			     use_variable(&(yypvt[-3]));

				/* Check for non-integer DO index or bounds */
			     if(datatype_of(yypvt[-3].class) == type_INTEGER
				&& datatype_of(yypvt[-1].class) != type_INTEGER)
			       warning(yypvt[-2].line_num,yypvt[-3].col_num,
				  "type mismatch between DO index and bounds");

			     else if(datatype_of(yypvt[-3].class) != type_INTEGER)
			       if(datatype_of(yypvt[-1].class) != type_INTEGER) {
				 if(port_check)
				   nonportable(yypvt[-1].line_num,yypvt[-1].col_num,
					       "non-integer DO loop bounds");
			       }
			       else {
				 if(trunc_check)
				   warning(yypvt[-3].line_num,yypvt[-3].col_num,
					   "DO index is not integer");
			       }
			} /*NOTREACHED*/ break;
case 255:
# line 1568 "fortran.y"
{complex_const_allowed=TRUE;} /*NOTREACHED*/ break;
case 256:
# line 1569 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-2].subclass)){
				use_variable(&(yypvt[-2]));
			    }
			    complex_const_allowed=FALSE;
			    /* (N.B. nonportability flagged in do_handle) */
			} /*NOTREACHED*/ break;
case 257:
# line 1577 "fortran.y"
{complex_const_allowed=TRUE;} /*NOTREACHED*/ break;
case 258:
# line 1578 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-2].subclass)){
				use_variable(&(yypvt[-2]));
			    }
			    complex_const_allowed=FALSE;
#ifdef ALLOW_DO_ENDO
			    if(f77_standard)
				nonstandard(yypvt[-5].line_num,yypvt[-5].col_num);
#else
			    syntax_error(yypvt[-5].line_num,yypvt[-5].col_num,
				    "Nonstandard syntax");
#endif
			} /*NOTREACHED*/ break;
case 261:
# line 1596 "fortran.y"
{
#ifdef ALLOW_DO_ENDO
			    if(f77_standard)
				nonstandard(yypvt[-1].line_num,yypvt[-1].col_num);
#else
			    syntax_error(yypvt[-1].line_num,yypvt[-1].col_num,
				    "Nonstandard syntax");
#endif
			    integer_context=FALSE;
			} /*NOTREACHED*/ break;
case 262:
# line 1609 "fortran.y"
{
			    yyval.class=do_bounds_type(&(yypvt[-2]),&(yypvt[-0]),&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 263:
# line 1613 "fortran.y"
{
			    yyval.class=do_bounds_type(&(yypvt[-4]),&(yypvt[-2]),&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 264:
# line 1619 "fortran.y"
{
#ifdef ALLOW_DO_ENDO
			    if(f77_standard)
				nonstandard(yypvt[-1].line_num,yypvt[-1].col_num);
#else
			    syntax_error(yypvt[-1].line_num,yypvt[-1].col_num,
				    "Nonstandard syntax");
#endif
			} /*NOTREACHED*/ break;
case 265:
# line 1629 "fortran.y"
{
#ifdef ALLOW_DO_ENDO
			    if(f77_standard)
				nonstandard(yypvt[-1].line_num,yypvt[-1].col_num);
#else
			    syntax_error(yypvt[-1].line_num,yypvt[-1].col_num,
				    "Nonstandard syntax");
#endif
			} /*NOTREACHED*/ break;
case 271:
# line 1655 "fortran.y"
{
			     use_variable(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 273:
# line 1663 "fortran.y"
{complex_const_allowed = FALSE;} /*NOTREACHED*/ break;
case 275:
# line 1665 "fortran.y"
{complex_const_allowed = FALSE;} /*NOTREACHED*/ break;
case 277:
# line 1668 "fortran.y"
{control_item_count = 0;} /*NOTREACHED*/ break;
case 278:
# line 1670 "fortran.y"
{complex_const_allowed = TRUE;} /*NOTREACHED*/ break;
case 284:
# line 1683 "fortran.y"
{control_item_count = 0;} /*NOTREACHED*/ break;
case 285:
# line 1687 "fortran.y"
{
			    if(f77_standard)
				nonstandard(yypvt[-2].line_num,yypvt[-2].col_num);
			} /*NOTREACHED*/ break;
case 286:
# line 1692 "fortran.y"
{
			    if(f77_standard)
				nonstandard(yypvt[-4].line_num,yypvt[-4].col_num);
			} /*NOTREACHED*/ break;
case 288:
# line 1701 "fortran.y"
{complex_const_allowed = TRUE;} /*NOTREACHED*/ break;
case 289:
# line 1702 "fortran.y"
{complex_const_allowed = FALSE;} /*NOTREACHED*/ break;
case 291:
# line 1706 "fortran.y"
{
			    if(f77_standard)
				nonstandard(yypvt[-2].line_num,yypvt[-2].col_num);
			} /*NOTREACHED*/ break;
case 292:
# line 1711 "fortran.y"
{complex_const_allowed = TRUE;} /*NOTREACHED*/ break;
case 293:
# line 1712 "fortran.y"
{complex_const_allowed = FALSE;} /*NOTREACHED*/ break;
case 294:
# line 1713 "fortran.y"
{
			    if(f77_standard)
				nonstandard(yypvt[-6].line_num,yypvt[-6].col_num);
			} /*NOTREACHED*/ break;
case 295:
# line 1721 "fortran.y"
{
			    ++control_item_count;
			} /*NOTREACHED*/ break;
case 296:
# line 1725 "fortran.y"
{
			    ++control_item_count;
			} /*NOTREACHED*/ break;
case 297:
# line 1734 "fortran.y"
{
			    use_io_keyword(&(yypvt[-2]),&(yypvt[-0]),curr_stmt_class);
			} /*NOTREACHED*/ break;
case 298:
# line 1738 "fortran.y"
{
			    if( yypvt[-0].class != '*'
			       && is_true(ID_EXPR,yypvt[-0].subclass)){
					/* WRITE(string,...) means store
					   output in the string */
				if(curr_stmt_class == tok_WRITE
				 && control_item_count == 0
				 && datatype_of(yypvt[-0].class) == type_STRING)
				    use_lvalue(&(yypvt[-0]));
					/* READ/WRITE(..,namelist) means
					   I/O with variables of namelist. */
				else if( control_item_count == 1
				    && datatype_of(yypvt[-0].class) == type_NAMELIST)
				    ref_namelist(&(yypvt[-0]),curr_stmt_class);

				use_variable(&(yypvt[-0]));
			    }
			} /*NOTREACHED*/ break;
case 299:
# line 1764 "fortran.y"
{
			    if( yypvt[-0].class != '*'
			       && is_true(ID_EXPR,yypvt[-0].subclass)){
				use_variable(&(yypvt[-0]));
			    }
			    ++control_item_count;
			} /*NOTREACHED*/ break;
case 300:
# line 1772 "fortran.y"
{
			    use_io_keyword(&(yypvt[-2]),&(yypvt[-0]),curr_stmt_class);
			    ++control_item_count;
			} /*NOTREACHED*/ break;
case 301:
# line 1777 "fortran.y"
{
			    ++control_item_count;
			} /*NOTREACHED*/ break;
case 302:
# line 1783 "fortran.y"
{
			    use_io_keyword(&(yypvt[-2]),&(yypvt[-0]),curr_stmt_class);
			} /*NOTREACHED*/ break;
case 303:
# line 1787 "fortran.y"
{
			    use_special_open_keywd(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 306:
# line 1798 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-0].subclass)){
				if( curr_stmt_class == tok_READ ||
				    curr_stmt_class == tok_ACCEPT )
				    use_lvalue(&(yypvt[-0]));
				else
				    use_variable(&(yypvt[-0]));
			    }
			} /*NOTREACHED*/ break;
case 308:
# line 1812 "fortran.y"
{
			     use_implied_do_index(&(yypvt[-3]));
			} /*NOTREACHED*/ break;
case 309:
# line 1818 "fortran.y"
{control_item_count = 0;} /*NOTREACHED*/ break;
case 311:
# line 1823 "fortran.y"
{control_item_count = 0;} /*NOTREACHED*/ break;
case 313:
# line 1828 "fortran.y"
{control_item_count = 0;} /*NOTREACHED*/ break;
case 317:
# line 1836 "fortran.y"
{control_item_count = 0;} /*NOTREACHED*/ break;
case 320:
# line 1843 "fortran.y"
{control_item_count = 0;} /*NOTREACHED*/ break;
case 321:
# line 1844 "fortran.y"
{control_item_count = 0;} /*NOTREACHED*/ break;
case 324:
# line 1851 "fortran.y"
{control_item_count = 0;} /*NOTREACHED*/ break;
case 327:
# line 1865 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-0].subclass)){
				 use_variable(&(yypvt[-0]));
			    }
			} /*NOTREACHED*/ break;
case 329:
# line 1874 "fortran.y"
{inside_format=TRUE;} /*NOTREACHED*/ break;
case 330:
# line 1875 "fortran.y"
{
			  inside_format=FALSE;
			} /*NOTREACHED*/ break;
case 344:
# line 1901 "fortran.y"
{
			  if(f77_standard)
			     nonstandard(yypvt[-0].line_num,yypvt[-0].col_num);
			} /*NOTREACHED*/ break;
case 349:
# line 1918 "fortran.y"
{
				if(stmt_sequence_no > seq_stmt_fun) {
				    syntax_error(
					yypvt[-3].line_num, NO_COL_NUM,
					    "statement out of order");
				 }
				def_stmt_function(&(yypvt[-3]),&(yypvt[-1]));
					/* make token info */
				primary_id_expr(&(yypvt[-3]),&(yyval));
				if(debug_parser)
				  print_exprlist("stmt function",&(yypvt[-1]));
			} /*NOTREACHED*/ break;
case 350:
# line 1933 "fortran.y"
{
			    yyval.next_token = append_token((Token*)NULL,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 351:
# line 1937 "fortran.y"
{
			    yyval.next_token = append_token(yypvt[-2].next_token,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 353:
# line 1947 "fortran.y"
{
			     call_subr(&(yypvt[-0]),(Token*)NULL);
			     complex_const_allowed = FALSE;
			} /*NOTREACHED*/ break;
case 355:
# line 1953 "fortran.y"
{
			     call_subr(&(yypvt[-2]),(Token*)NULL);
			     complex_const_allowed = FALSE;
			} /*NOTREACHED*/ break;
case 357:
# line 1959 "fortran.y"
{
			     call_subr(&(yypvt[-3]),&(yypvt[-1]));
			     if(debug_parser)
				print_exprlist("call stmt",&(yypvt[-1]));
			     complex_const_allowed = FALSE;
			} /*NOTREACHED*/ break;
case 359:
# line 1968 "fortran.y"
{
			     complex_const_allowed = TRUE;
			     yyval = yypvt[-0];
			} /*NOTREACHED*/ break;
case 360:
# line 1974 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-0].subclass)){
				 use_actual_arg(&(yypvt[-0]));
				 use_variable(&(yypvt[-0]));
			    }
			    yyval.next_token = append_token((Token*)NULL,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 361:
# line 1982 "fortran.y"
{
			    yyval.next_token = append_token((Token*)NULL,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 362:
# line 1986 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-0].subclass)){
				 use_actual_arg(&(yypvt[-0]));
				 use_variable(&(yypvt[-0]));
			    }
			    yyval.next_token = append_token(yypvt[-2].next_token,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 363:
# line 1994 "fortran.y"
{
			    yyval.next_token = append_token(yypvt[-4].next_token,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 364:
# line 2001 "fortran.y"
{
			     do_RETURN(current_module_hash,&(yypvt[-1]));
			} /*NOTREACHED*/ break;
case 365:
# line 2005 "fortran.y"
{
			     do_RETURN(current_module_hash,&(yypvt[-2]));
			} /*NOTREACHED*/ break;
case 366:
# line 2012 "fortran.y"
{
				   /* restore status of complex flag */
				if(!is_true(COMPLEX_FLAG,yypvt[-3].subclass))
				  complex_const_allowed=FALSE;
				call_func(&(yypvt[-3]),&(yypvt[-1]));
							/* make token info */
				func_ref_expr(&(yypvt[-3]),&(yypvt[-1]),&(yyval));
				if(debug_parser)
				    print_exprlist("function",&(yypvt[-1]));
			} /*NOTREACHED*/ break;
case 367:
# line 2025 "fortran.y"
{
			  if(complex_const_allowed)/* save context */
			    make_true(COMPLEX_FLAG,yyval.subclass);
			  complex_const_allowed=TRUE;
			} /*NOTREACHED*/ break;
case 368:
# line 2032 "fortran.y"
{
				yyval.class = 0;
				yyval.next_token = NULL;
			} /*NOTREACHED*/ break;
case 370:
# line 2040 "fortran.y"
{
			    yyval.next_token = append_token((Token*)NULL,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 371:
# line 2044 "fortran.y"
{
			    yyval.next_token = append_token(yypvt[-2].next_token,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 372:
# line 2052 "fortran.y"
{
			  if(datatype_of(yypvt[-0].class) != type_ERROR){
			    if( ! is_const_type(yypvt[-0].class) ) {
			      syntax_error(yypvt[-0].line_num,yypvt[-0].col_num,
		      "arithmetic, char, or logical expression expected");
			    }
			    else {
			      if( !is_true(PARAMETER_EXPR,yypvt[-0].subclass) ) {
				syntax_error(yypvt[-0].line_num,yypvt[-0].col_num,
					   "constant expression expected");
			      }
			    /* Here we allow, with some warnings, expr
			       containing intrins func or **REAL in
			       PARAMETER defn. */
			      else if( !is_true(CONST_EXPR,yypvt[-0].subclass) ) {
				if(f77_standard) {
				  nonstandard(yypvt[-0].line_num,yypvt[-0].col_num);
				  msg_tail(
			 "\n    intrinsic func or **REAL in PARAMETER defn");
				}
			      }
			    }
			  }
			} /*NOTREACHED*/ break;
case 373:
# line 2080 "fortran.y"
{
			    if(debug_parser) {
				fprintf(list_fd,
					"\nexpr: class=0x%x subclass=0x%x",
					yypvt[-0].class,
					yypvt[-0].subclass);
			    }
			} /*NOTREACHED*/ break;
case 375:
# line 2093 "fortran.y"
{
			    binexpr_type(&(yypvt[-2]),&(yypvt[-1]),&(yypvt[-0])
					 ,&(yyval));
			} /*NOTREACHED*/ break;
case 376:
# line 2098 "fortran.y"
{
			    binexpr_type(&(yypvt[-2]),&(yypvt[-1]),&(yypvt[-0])
					 ,&(yyval));
			} /*NOTREACHED*/ break;
case 378:
# line 2107 "fortran.y"
{
			    binexpr_type(&(yypvt[-2]),&(yypvt[-1]),&(yypvt[-0])
					 ,&(yyval));
			} /*NOTREACHED*/ break;
case 380:
# line 2116 "fortran.y"
{
			    binexpr_type(&(yypvt[-2]),&(yypvt[-1]),&(yypvt[-0])
					 ,&(yyval));
			} /*NOTREACHED*/ break;
case 382:
# line 2125 "fortran.y"
{
			    unexpr_type(&(yypvt[-1]),&(yypvt[-0]),&(yyval));
			} /*NOTREACHED*/ break;
case 384:
# line 2133 "fortran.y"
{
			    binexpr_type(&(yypvt[-2]),&(yypvt[-1]),&(yypvt[-0])
					 ,&(yyval));
			} /*NOTREACHED*/ break;
case 386:
# line 2143 "fortran.y"
{
			    unexpr_type(&(yypvt[-1]),&(yypvt[-0]),&(yyval));
			} /*NOTREACHED*/ break;
case 387:
# line 2147 "fortran.y"
{
			    unexpr_type(&(yypvt[-1]),&(yypvt[-0]),&(yyval));
			} /*NOTREACHED*/ break;
case 388:
# line 2151 "fortran.y"
{
			    binexpr_type(&(yypvt[-2]),&(yypvt[-1]),&(yypvt[-0])
					 ,&(yyval));
			} /*NOTREACHED*/ break;
case 389:
# line 2156 "fortran.y"
{
			    binexpr_type(&(yypvt[-2]),&(yypvt[-1]),&(yypvt[-0])
					 ,&(yyval));
			} /*NOTREACHED*/ break;
case 391:
# line 2165 "fortran.y"
{
			    binexpr_type(&(yypvt[-2]),&(yypvt[-1]),&(yypvt[-0])
					 ,&(yyval));
			    if(div_check &&
			       !is_true(CONST_EXPR,yypvt[-0].subclass)){
				warning(yypvt[-1].line_num,yypvt[-1].col_num,
					"Possible division by zero");
			    }
			} /*NOTREACHED*/ break;
case 392:
# line 2175 "fortran.y"
{
			    binexpr_type(&(yypvt[-2]),&(yypvt[-1]),&(yypvt[-0])
					 ,&(yyval));
			} /*NOTREACHED*/ break;
case 394:
# line 2184 "fortran.y"
{
			    binexpr_type(&(yypvt[-2]),&(yypvt[-1]),&(yypvt[-0])
					 ,&(yyval));
			} /*NOTREACHED*/ break;
case 396:
# line 2193 "fortran.y"
{
			    binexpr_type(&(yypvt[-2]),&(yypvt[-1]),&(yypvt[-0])
					 ,&(yyval));
			} /*NOTREACHED*/ break;
case 397:
# line 2200 "fortran.y"
{
			    DBGstr(primary<--id=,token_name(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 401:
# line 2210 "fortran.y"
{
			    make_true(CONST_EXPR,yyval.subclass);
			    make_true(PARAMETER_EXPR,yyval.subclass);
			    make_true(NUM_CONST,yyval.subclass);
			} /*NOTREACHED*/ break;
case 402:
# line 2216 "fortran.y"
{
			    DBGstr(primary<--str=,yypvt[-0].value.string)
			    yyval.class = type_byte(class_VAR,type_STRING);
			    yyval.subclass = 0;
			    make_true(CONST_EXPR,yyval.subclass);
			    make_true(PARAMETER_EXPR,yyval.subclass);
			} /*NOTREACHED*/ break;
case 403:
# line 2224 "fortran.y"
{
			    DBGstr(primary<--h=,yypvt[-0].value.string)
			    yyval.class = type_byte(class_VAR,type_HOLLERITH);
			    yyval.subclass = 0;
			    make_true(CONST_EXPR,yyval.subclass);
			    make_true(PARAMETER_EXPR,yyval.subclass);
			    if(port_check && hollerith_check) {
				warning(yypvt[-0].line_num,yypvt[-0].col_num,
				"hollerith constant may not be portable");
			    }
			} /*NOTREACHED*/ break;
case 404:
# line 2236 "fortran.y"
{
			    DBGstr(primary<--log=,yypvt[-0].value.string)
			    yyval.class = type_byte(class_VAR,type_LOGICAL);
			    yyval.subclass = 0;
			    make_true(CONST_EXPR,yyval.subclass);
			    make_true(PARAMETER_EXPR,yyval.subclass);
			} /*NOTREACHED*/ break;
case 405:
# line 2244 "fortran.y"
{
			    yyval = yypvt[-1];
			} /*NOTREACHED*/ break;
case 406:
# line 2250 "fortran.y"
{
			    yyval.class = type_byte(class_VAR,type_INTEGER);
			    yyval.subclass = 0;
			} /*NOTREACHED*/ break;
case 407:
# line 2255 "fortran.y"
{
			    yyval.class = type_byte(class_VAR,type_REAL);
			    yyval.subclass = 0;
			} /*NOTREACHED*/ break;
case 408:
# line 2260 "fortran.y"
{
			    yyval.class = type_byte(class_VAR,type_DP);
			    yyval.subclass = 0;
			} /*NOTREACHED*/ break;
case 409:
# line 2265 "fortran.y"
{
			    yyval.class = type_byte(class_VAR,type_COMPLEX);
			    yyval.subclass = 0;
			} /*NOTREACHED*/ break;
case 410:
# line 2273 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-0].subclass)){
				use_variable(&(yypvt[-0]));
			    }
			    if(datatype_of(yypvt[-0].class) != type_INTEGER) {
				syntax_error(
					yypvt[-0].line_num,yypvt[-0].col_num,
					"expression must be integer type");
			    }
			} /*NOTREACHED*/ break;
case 411:
# line 2287 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-0].subclass)){
				use_variable(&(yypvt[-0]));
			    }
			    {
				int t=datatype_of(yypvt[-0].class);
				    if(t != type_INTEGER && t != type_REAL
					&& t != type_DP ) {
					syntax_error(
					  yypvt[-0].line_num,yypvt[-0].col_num,
		"expression must be integer, real, or double precision type");
				        }
			    }
			} /*NOTREACHED*/ break;
case 412:
# line 2307 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-0].subclass)){
				use_variable(&(yypvt[-0]));
			    }
			    if( ! is_true(CONST_EXPR,yypvt[-0].subclass) ) {
				syntax_error(
					yypvt[-0].line_num,yypvt[-0].col_num,
					"constant expression expected");
			    }
			    else
			      if(datatype_of(yypvt[-0].class) != type_INTEGER){
				syntax_error(
					yypvt[-0].line_num,yypvt[-0].col_num,
					"integer expression expected");
			    }

			} /*NOTREACHED*/ break;
case 413:
# line 2328 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-0].subclass)){
				use_variable(&(yypvt[-0]));
			    }

			    if( datatype_of(yypvt[-0].class) != type_INTEGER ){
				syntax_error(
					yypvt[-0].line_num,yypvt[-0].col_num,
					"integer dimension expected");
				yyval.value.integer = 0;
			    }
			    else {
			      if( is_true(CONST_EXPR,yypvt[-0].subclass) )
				yyval.value.integer =
				  int_expr_value(&(yypvt[-0]));
			      else		/* must be dummy */
				yyval.value.integer = 0;
			    }
			} /*NOTREACHED*/ break;
case 414:
# line 2354 "fortran.y"
{
				ref_array(&(yypvt[-3]),&(yypvt[-1]));
				if(debug_parser)
				    print_exprlist("array lvalue",&(yypvt[-1]));
					/* array now becomes scalar */
				make_false(ARRAY_ID_EXPR,yyval.subclass);
			} /*NOTREACHED*/ break;
case 415:
# line 2364 "fortran.y"
{
				ref_array(&(yypvt[-3]),&(yypvt[-1]));
				if(debug_parser)
				    print_exprlist("array",&(yypvt[-1]));
					/* array now becomes scalar */
				make_false(ARRAY_ID_EXPR,yyval.subclass);
			} /*NOTREACHED*/ break;
case 416:
# line 2374 "fortran.y"
{
			    yyval.next_token = append_token((Token*)NULL,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 417:
# line 2378 "fortran.y"
{
			    yyval.next_token = append_token(yypvt[-2].next_token,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 418:
# line 2384 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-0].subclass)){
				 use_variable(&(yypvt[-0]));
			    }
				/* check subscript exprs for integer type */
			    if(datatype_of(yypvt[-0].class) != type_INTEGER)
			      if(trunc_check)
				 warning(yypvt[-0].line_num,yypvt[-0].col_num,
					 "subscript is not integer");
			} /*NOTREACHED*/ break;
case 419:
# line 2398 "fortran.y"
{
				   /* restore status of complex flag */
				if(!is_true(COMPLEX_FLAG,yypvt[-1].subclass))
				  complex_const_allowed=FALSE;
			} /*NOTREACHED*/ break;
case 424:
# line 2412 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-2].subclass)){
				use_variable(&(yypvt[-2]));
			    }
			} /*NOTREACHED*/ break;
case 425:
# line 2418 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-1].subclass)){
				use_variable(&(yypvt[-1]));
			    }
			} /*NOTREACHED*/ break;
case 426:
# line 2424 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-3].subclass)){
				use_variable(&(yypvt[-3]));
			    }
			    if(is_true(ID_EXPR,yypvt[-1].subclass)){
				use_variable(&(yypvt[-1]));
			    }

			} /*NOTREACHED*/ break;
case 429:
# line 2443 "fortran.y"
{
			    ref_variable(&(yypvt[-0]));
			    primary_id_expr(&(yypvt[-0]),&(yyval));
			} /*NOTREACHED*/ break;
case 430:
# line 2450 "fortran.y"
{
			    ref_variable(&(yypvt[-0]));
			    primary_id_expr(&(yypvt[-0]),&(yyval));
			} /*NOTREACHED*/ break;
case 440:
# line 2483 "fortran.y"
{
			    integer_context=TRUE;
			} /*NOTREACHED*/ break;
case 441:
# line 2490 "fortran.y"
{
				integer_context=FALSE;
				yyval.class = type_byte(class_LABEL,type_LABEL);
				yyval.subclass = 0;
			} /*NOTREACHED*/ break;
}


	goto yystack;           /* reset registers in driver code */
}
