"Initialization code"
 !

"define required class"
Smalltalk at: #SortedCollection ifAbsent: [
OrderedCollection subclass: #SortedCollection
  instanceVariableNames: 
    ' sortBlock '
  classVariableNames: ''
  poolDictionaries: '']!

"define required class"
Smalltalk at: #HelpManager ifAbsent: [
Object variableSubclass: #HelpManager
  instanceVariableNames: 
    ' applicationWindow helpInstance aboutDlgClass extHelpPanelId keysHelpPanelId helpInit helpTableId helpTableModule helpWindowTitle helpLibraryPath pmHelpLibrary addresses dialogs '
  classVariableNames: ''
  poolDictionaries: 
    ' PMConstants PMHelpConstants ']!

"define required class"
Smalltalk at: #ApplicationWindow ifAbsent: [
Window subclass: #ApplicationWindow
  instanceVariableNames: 
    ' label collapsed menuWindow dependents activeTextPane '
  classVariableNames: ''
  poolDictionaries: 
    ' PMHelpConstants PMConstants ']!

"define required class"
Smalltalk at: #DialogTopPane ifAbsent: [
TopPane subclass: #DialogTopPane
  instanceVariableNames: 
    ' sem pmOwner '
  classVariableNames: 
    ' FrameTemplate '
  poolDictionaries: 
    ' CharacterConstants PMConstants ']!

"define required class"
Smalltalk at: #StaticGraphic ifAbsent: [
StaticPane subclass: #StaticGraphic
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: 
    ' PMConstants ']!



!SortedCollection methods !
   
collect: aBlock
        "For each element in the receiver, evaluate aBlock with
         that element as the argument.  Answer a new collection
         containing the results as its elements from the aBlock
         evaluations."
		"@25.02.94 ch: Creation"
    | answer |
    answer := OrderedCollection new.
    self do: [ :element |
        answer add: (aBlock value: element)].
    ^answer!

select: aBlock
        "For each element in the receiver, evaluate
         aBlock with that element as the argument.
         Answer a new collection containing those elements
         of the receiver for which aBlock evaluates to true."
    | answer |
    answer := self class sortBlock: sortBlock.
    self do: [ :element |
        (aBlock value: element)
            ifTrue: [answer add: element]].
    ^answer! !



!SortedCollection class methods ! !



!HelpManager methods !

displayHelp: id
        "Display the help panel identified by id
        id can be either an Integer or a String."
		"@12.02.94 ch: helpmanager bug workaround" 
    id isString
        ifTrue: [
            ^(PMWindowLibrary 
                sendMsg: helpInstance
                msg: HmDisplayHelp
                mp1Struct: id asParameter copy
				"The HelpManager uppercases the string passed in,
				so make a copy to prevent modification."
                mp2: HmPanelname) asPMLong asInteger].
    id isInteger
        ifTrue: [
            ^(PMWindowLibrary 
                sendMsg: helpInstance
                msg: HmDisplayHelp
                mp1: id
                mp2: HmpaneltypeNumber )asPMLong asInteger]! !



!HelpManager class methods ! !



!ApplicationWindow methods !
  
hmHelpsubitemNotFound: mp1 with: mp2
        "Private - Show the appropriate help panel."
		"@19.11.93 ch: Work around for OS/2 bug" 
    | helpLabel helpManager helpMode idTopic idSubTopic menu result |
    helpMode := mp1 shortAtOffset: 0.
    idTopic := mp2 lowHalf.			" menu "
    idSubTopic := mp2 highHalf.	" menu item "
    helpMode = HlpmMenu
        ifTrue: [ idSubTopic = 65535 "Only a submenu but no item is selected."
            ifTrue: [
                self menuWindow menus do: [:menu |
                    ( menu menuItem id = idTopic )
                        ifTrue: [ helpLabel := menu title ]]]
            ifFalse: [
                menu := self menuWindow menuOf: idSubTopic.
                ( menu == ( self menuWindow menuOf: idTopic ) )
                    ifTrue: [ helpLabel := ( menu selectorOf: idSubTopic ) asString ]
                    ifFalse: [ helpLabel := menu title ] ] ]
        ifFalse: [
            ((helpMode = HlpmFrame or: [helpMode = HlpmWindow])
            and: [children size >= idSubTopic])
                ifTrue: [helpLabel := (self childAtId: idSubTopic) name asParameter]].

	"Work around: HelpManager does not accept 'Finalize Code' for
	unknown reasons."
	helpLabel = 'Finalize Code' ifTrue: [helpLabel := 'Finalixe Code'].

    (helpManager := self helpManager) isNil 
        ifTrue: [helpManager := self pmOwner helpManager].
    (helpLabel isNil or: [helpManager isNil])
        ifTrue: [^false].

	"Display OS/2's standard help for help panels. We don't know
	if these panel values are documented and keep constant in other
	versions of OS/2."
	helpLabel = 'helpIndex' ifTrue: [
		helpLabel := 64026]
	ifFalse: [helpLabel = 'extendedHelp' ifTrue: [
		helpLabel := 64024]
	ifFalse: [helpLabel = 'helpForHelp' ifTrue: [
		helpLabel := 64023]
	ifFalse: [helpLabel = 'sendKeysHelp' ifTrue: [
		helpLabel := 64025]
	ifFalse: [helpLabel = '~Help' ifTrue: [
		helpLabel := 64022]]]]].

	result := helpManager displayHelp: helpLabel.

	"This doesn't work, properly a bug in OS/2. Modify to result < 0
	if you want to see the panel ids."
	result = 0 ifFalse: [
		helpLabel isInteger ifTrue: [helpLabel := helpLabel printString].
		Transcript nextPutAll: 'HelpManager error: ', result printString, 
			' in label: ', helpLabel printString; cr].
	^result = 0!
 
labelWithoutPrefix: aString
        "Set the window label of the receiver to aString
        without prepending 'Smalltalk/V '."
		"@06.11.93 ch : the window list was not updated" 
    label := aString. 
    label size > 500 ifTrue: [label := label copyFrom: 1 to: 500].
        "Experimentally determined that labels more than 500 bytes
         cause PM to mess up the title bar."
    handle isNil ifTrue: [^self].
    handle isValid ifTrue: [
        parent handle setWindowText: label;
        changeSwitchEntry: label ].! !



!ApplicationWindow class methods ! !



!DialogTopPane methods !
 
buildItems
        "Private - Build the control items within
         the dialog box.  Answer a ByteArray
        containing all the items."
		"@18.12.93 ch: inset the rectangle for childs, so they do not override the 
		border"  
    | answer items subpaneStyle rect text pmDlgItem strings stringsOffset
    offText cchClassName offClassName|
    answer := ByteArray new.
    strings := ByteArray new.
    items := OrderedCollection new.
    stringsOffset := 14 + 30 + (30 * children size).
    children do: [ :subpane |
        subpane style isNil ifTrue: [subpane style: subpane defaultStyle].
        ( subpane propertyAt: #noTabStop ) isNil ifTrue: [
            subpane addStyle: WsTabstop ].
        (subpane isKindOf: SubPane) ifTrue: [
            ((rect := subpane framingBlock) isKindOf: Context)
                ifTrue: [rect := rect value: 
					((0@0 extent: rectangle extent) insetBy: 2 @ 0)].
            text := (subpane respondsTo: #contents) 
                ifTrue: [subpane contents] 
                ifFalse: [nil].
            text class = String ifFalse:[
                text := nil].
            pmDlgItem := SelfDefinedStructure named: 'DLGTITEM'.
            offText := stringsOffset + strings size.
            text isNil ifFalse: [strings := strings, text asAsciiZ].
            (subpane windowClass isKindOf: String) 
                ifTrue: [
                    offClassName := stringsOffset + strings size.
                    cchClassName := subpane windowClass asAsciiZ size.
                    strings := strings, subpane windowClass asAsciiZ]
                ifFalse: [cchClassName := 0.
                    offClassName := subpane windowClass].
            items add: (
                pmDlgItem
                    cChildren: 0;
                    cchClassName: cchClassName;
                    offClassName: ( offClassName bitAnd: 16rFFFF );
                    cchText: text size;
                    offText: offText;
                    flStyle: WsVisible |  subpane style;
                    x: rect left asInteger;
                    y: rect bottom asInteger;
                    cx: rect width asInteger;
                    cy: rect height asInteger;
                    windowId: subpane getId ).
            subpane pmControlData notNil ifTrue: [
                pmDlgItem offCtlData: stringsOffset + strings size.
                strings := strings, subpane pmControlData contents ] ] ].
    items do: [:pmDlgItem | 
        answer := answer , pmDlgItem contents].
    ^answer , strings! !



!DialogTopPane class methods ! !



!StaticGraphic methods !
  
setHandle
        "Private - Set the icon or bitmap handle for the static control."
		"@16.12.93 ch: bug fix: the 'self resize:' statements causes wrong 
		positioning" 
        " Assumes 'handle = NullHandle' is false and value is either
          an icon or bitmap handle." 
    value notNil
    ifTrue: 
        [ PMWindowLibrary sendMsg: ( self handle )
            msg: SmSethandle mp1: value handle asParameter mp2: 0.
"		self invalidateRect: self rectangle. "
		
		"This MUST NOT be done. It causes a wrong position of the graphic."
        "self resize: self rectangle."		     	" force redraw..."
        ]! !



!StaticGraphic class methods ! !
"Finalization code"
  !

 
Transcript cr; nextPutAll: 'Bug Fixes 2.0 installed.'!
