#include "dict.h"
#include "lookupke.h"
#include "assoc.h"

#define THIS    Dictionary
#define BASE    Set
DEFINE_CLASS(Dictionary,Set);

Dictionary::Dictionary(unsigned size) : Set(size) {}

Dictionary::Dictionary(const Dictionary& d) : Set(d) {}

void Dictionary::operator=(const Dictionary& d)
{
    this->Set::operator=(d);
}

bool Dictionary::operator==(const Dictionary& d) const
{
    if (size() != d.size()) return NO;
    DO(*this,LookupKey*,a)
        if (!d.includesAssoc(*a)) return NO;
    DONE
    return YES;
}

Object* Dictionary::add(const Object& ob)
{
    assertArgClass(ob,class_LookupKey,"add");
    return Set::add(ob);
}

Assoc* Dictionary::addAssoc(const Object& key, const Object& value)
{
    Assoc* a = new Assoc(key,value);
    Assoc* b = (Assoc*)Set::add(*a);
    if (a != b) {
        delete a;
        //DTerror("OOPS_DUPKEY,DEFAULT,this,className(),\"addAssoc\",key.className(),&key",className());
        DTerror("Tried to add duplicate key: ",className());
    }
    return b;
}

Collection& Dictionary::addContentsTo(Collection& cltn) const
{
    DO(*this,LookupKey*,a) cltn.add(*(a->value())); DONE
    return cltn;
}

Object* Dictionary::remove(const Object& ob)
{
    assertArgClass(ob,class_LookupKey,"remove");
    return Set::remove(ob);
}

Object* Dictionary::atKey(const Object& key) const
{
    register Object* p = findObjectWithKey(key);
    if (p==nil)
    {
        //DTerror("OOPS_KEYNOTFOUND,DEFAULT,this,className(),key.className(),&key",className());
        DTerror("Key not found: ",className());     // aborts, return not executed
        return (Object*)NULL;                       // avoids Warning message
    } else return ((LookupKey*)p)->value();
}

Object* Dictionary::atKey(const Object& key, const Object& newValue)
{
    register Object* p = findObjectWithKey(key);
    if (p==nil)
    {
        //DTerror("OOPS_KEYNOTFOUND,DEFAULT,this,className(),key.className(),&key",className());
        DTerror("Key not found: ",className());     // aborts, return not executed
        return (Object*)NULL;                       // avoids Warning message
    } else return ((LookupKey*)p)->value(newValue);
}

LookupKey& Dictionary::assocAt(const Object& key) const
{
    return *(LookupKey*)findObjectWithKey(key);
}

Collection& Dictionary::addKeysTo(Collection& cltn) const
{
    DO(*this,LookupKey*,a) cltn.add(*a->key()); DONE
    return cltn;
}

Collection& Dictionary::addValuesTo(Collection& cltn) const
{
    return addContentsTo(cltn);
}

Object* Dictionary::keyAtValue(const Object& val) const
{
    DO(*this,LookupKey*,a)
        if (val.isEqual(*a->value())) return a->key();
    DONE
    return (Object*)nil;
}

unsigned Dictionary::occurrencesOf(const Object& val) const
{
    register unsigned n =0;
    DO(*this,LookupKey*,a) if (val.isEqual(*a->value())) n++; DONE
    return n;
}

bool Dictionary::includesAssoc(const LookupKey& asc) const
{
    register Object* p = findObjectWithKey(asc);
    if (p==nil) return NO;
    return (asc.value())->isEqual(*((LookupKey*)p)->value());
}

bool Dictionary::includesKey(const Object& key) const
{
    if (findObjectWithKey(key) == nil) return NO;
    else return YES;
}

bool Dictionary::isEqual(const Object& ob) const
{
    return ob.isSpecies(class_Dictionary) && *this==*(Dictionary*)&ob;
}

const Class* Dictionary::species() const { return &class_Dictionary; }

LookupKey& Dictionary::removeAssoc(const LookupKey& asc)
{
    return *(LookupKey*)remove(asc);
}

LookupKey& Dictionary::removeKey(const Object& key)
{
    return removeAssoc(assocAt(key));
}

