/* Assoc.c -- implementation of key-value association

Function:

Objects of class Assoc associate a key object with a value object.  They
are used to implement Dictionaries, which are Sets of Associations.

*/

#include "assoc.h"

#define THIS    Assoc
#define BASE    LookupKey
// DEFINE_CLASS(THIS,BASE);
DEFINE_CLASS(Assoc, LookupKey);

Assoc::Assoc(const Object& newKey, const Object& newValue)
: LookupKey(newKey)
{
    avalue = (Object*)&newValue;
}

Object* Assoc::value()  const { return avalue; }

Object* Assoc::value(const Object& newvalue)
{
    Object* temp = avalue;
    avalue = (Object*)&newvalue;
    return temp;
}

void Assoc::deepenShallowCopy()
{
    BASE::deepenShallowCopy();
    avalue = avalue->deepCopy();
}

void Assoc::printOn(ostream& strm) const
{
    strm << className() << "("; BASE::printOn(strm);
    strm << "="; avalue->printOn(strm); strm << ")";
}
