(*-------------------------------------------------------------------------*)
(*                 Sigt  -- Significance of t distribution                 *)
(*-------------------------------------------------------------------------*)

FUNCTION Sigt( t , Df : REAL ) : REAL;

(*-------------------------------------------------------------------------*)
(*                                                                         *)
(*       Function:  Sigt                                                   *)
(*                                                                         *)
(*       Purpose:   Evaluates t distribution probability ( 2 - tailed )    *)
(*                                                                         *)
(*       Calling Sequence:                                                 *)
(*                                                                         *)
(*            P     := Sigt( F , Df );                                     *)
(*                                                                         *)
(*                 t      --- t-value                                      *)
(*                 Df     --- degrees of freedom                           *)
(*                                                                         *)
(*                 P      --- Resultant probability (two-tailed)           *)
(*                                                                         *)
(*       Calls:                                                            *)
(*                                                                         *)
(*            CdBeta                                                       *)
(*                                                                         *)
(*       Method:                                                           *)
(*                                                                         *)
(*            The input values are transformed to match the                *)
(*            requirements of the Beta distribution.  Function CDBeta      *)
(*            provides the corresponding cumulative Beta distribution      *)
(*            probability.                                                 *)
(*                                                                         *)
(*            An error in the input arguments results in a returned        *)
(*            probability of -1.                                           *)
(*                                                                         *)
(*-------------------------------------------------------------------------*)

CONST
   Dprec   = 12;
   MaxIter = 200;

VAR
   Iter:   INTEGER;
   Cprec:  REAL;
   Ifault: INTEGER;
   Pval:   REAL;

BEGIN (* Sigt *)

   Pval := -1.0;

   IF( Df > 0.0 ) THEN
      BEGIN
         Pval   := CDBeta( Df / ( Df + t * t ), Df / 2.0, 0.5,
                           Dprec, MaxIter, Cprec, Iter, Ifault );
         IF Ifault <> 0 THEN Pval := -1.0;
      END;

   Sigt := Pval;

END   (* Sigt *);