{This program belongs to the KLAAS DE LUL PROGRAM and shows the features
 of the extended edit control.}
program ExtEditApp;

{$R KLaas.RES}

uses WinTypes, WinProcs, Win31, Objects, OWindows, ODialogs, strings;

const
  DLLName = 'ExtEdit.DLL';
  cm_About = 101;
  cm_Cancel = 2;
const
  em_DLLNotFound = 1;

type
  PeditWindow = ^TeditWindow;
  TeditWindow = object(TDlgWindow)
    constructor Init(AParent: PWindowsObject; AName: PChar);
    procedure CMlul(var Msg: TMessage);
      virtual cm_First + cm_Cancel;
  end;

  PEditApp = ^TEditApp;
  TEditApp = object(TApplication)
    lib : Thandle;
    constructor Init(AName: PChar);
    destructor Done; virtual;
    procedure InitMainWindow; virtual;
    procedure Error(ErrorCode: Integer); virtual;
  end;

  datarec = record
            str1,str2,str3,str4,str5,str6,str7,str8,str9,str10 : ARRAY[0..100] OF CHAR;
            klaas : ARRAY[0..1] OF WORD;
            end;


  PStepWindow = ^TStepWindow;
  TStepWindow = object(TWindow)
    constructor Init(AParent: PWindowsObject; AName: PChar);
    procedure CMAbout(var Msg: TMessage);
      virtual cm_First + cm_About;
    END;

VAR data : datarec;

PROCEDURE TEditWindow.cmlul(VAR Msg:Tmessage);
BEGIN
CloseWindow;
END;

procedure TstepWindow.CMAbout(var Msg: TMessage);
VAR PTheDialog : PeditWindow;
BEGIN
  PtheDialog := New(PeditWindow, Init(Application^.MainWindow, 'ABOUTBOX'));
  PtheDialog^.TransferBuffer := @Data;
  if Application^.ExecDialog(PtheDialog) <> idCancel then
  begin
  End;
END;

CONSTRUCTOR TStepWindow.Init(AParent:PwindowsObject;AName:Pchar);
BEGIN
inherited Init(AParent, AName);
Attr.Menu := LoadMenu(HInstance, 'TheMenu');
END;


constructor TEditWindow.Init(AParent: PWindowsObject; AName: PChar);
var
  AControl: PControl;
  i: Integer;
begin
  inherited Init(AParent, AName);
  AControl := New(PEdit, InitResource(@Self, 1001,101));
  AControl := New(PEdit, InitResource(@Self, 1002,101));
  AControl := New(PEdit, InitResource(@Self, 1003,101));
  AControl := New(PEdit, InitResource(@Self, 1004,101));
  AControl := New(PEdit, InitResource(@Self, 1005,101));
  AControl := New(PEdit, InitResource(@Self, 1006,101));
  AControl := New(PEdit, InitResource(@Self, 1007,101));
  AControl := New(PEdit, InitResource(@Self, 1008,101));
  AControl := New(PEdit, InitResource(@Self, 1009,101));
  AControl := New(PEdit, InitResource(@Self, 1010,101));
  for i := 0 to 1 do
      AControl := New(PRadioButton, InitResource(@Self, 1200 + i));
end;

constructor TEditApp.Init(AName: PChar);
begin
  { Tell Windows not to display a 'DLL not found' error
    dialog if the LoadLibrary function fails.  We'll handle
    the error and inform the user ourselves.
    Note that even though this SEM_ constant is defined and
    documented only in Windows 3.1, it actually works in
    Windows 3.0 as well... }
  SetErrorMode(SEM_NoOpenFileErrorBox);
  Lib := LoadLibrary(DLLName);
  if Lib < 32 then
    Status := em_DLLNotFound
  else
    TApplication.Init(AName);
end;

destructor TEditApp.Done;
begin
  TApplication.Done;
  FreeLibrary(Lib);
end;

procedure TEditApp.InitMainWindow;
begin

  WITH data DO
     BEGIN
     STRCOPY(str1,'1');
     STRCOPY(str2,'2');
     STRCOPY(str3,'3');
     STRCOPY(str4,'4');
     STRCOPY(str5,'5');
     STRCOPY(str6,'6');
     STRCOPY(str7,'7');
     STRCOPY(str8,'8');
     STRCOPY(str9,'9');
     STRCOPY(str10,'10');
     klaas[1] := 1;
     END;
  MainWindow := New(PStepWindow, Init(nil, 'Klaas'));
end;


procedure TEditApp.Error(ErrorCode: Integer);
begin
  case ErrorCode of
    em_DLLNotFound:
      MessageBox(0, DLLName + ' not found. Please compile BITBTN.PAS ' +
        'before executing this application.', 'Fatal error',
        mb_Ok or mb_IconStop);
  else
    TApplication.Error(ErrorCode);
  end;
end;

{ TeditWindow }

var
  App: TEditApp;

begin
  App.Init('TBITBTN.DDL Demo');
  App.Run;
  App.Done;
end.
