/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import unity.io.FileManager;
import unity.operators.Operator;
import unity.relational.Relation;
import unity.relational.Tuple;

public class FileScan
extends Operator {
    protected String inFileName;
    protected BufferedInputStream inFile;
    protected Relation inputRelation;

    public FileScan(String inName, Relation r) {
        this.inFileName = inName;
        this.inputRelation = r;
        this.setOutputRelation(r);
    }

    public void init() throws FileNotFoundException, IOException {
        this.inFile = FileManager.openInputFile(this.inFileName);
    }

    public Tuple next() throws IOException {
        Tuple t = new Tuple(this.inputRelation);
        if (!t.read(this.inFile)) {
            return null;
        }
        this.incrementTuplesRead();
        return t;
    }

    public boolean hasNext() throws IOException {
        this.inFile.mark(100);
        boolean hasMore = this.inFile.read() != -1;
        this.inFile.reset();
        return hasMore;
    }

    public void close() throws IOException {
        FileManager.closeFile(this.inFile);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(250);
        sb.append("FILE SCAN: (FileName=" + this.inFileName + ")");
        return sb.toString();
    }
}

