/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import unity.functions.Expression;
import unity.functions.Function;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;

public class F_Ln
extends Function {
    private Expression expr;

    public F_Ln(Expression e) {
        this.expr = e;
        this.returnType = this.expr.getReturnType();
    }

    public Object evaluate(Tuple t) {
        Object val = this.expr.evaluate(t);
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return new Double(Math.log(((Number)val).doubleValue()));
        }
        return null;
    }

    public int getReturnType() {
        return 8;
    }

    public static int[] getParamListTypes() {
        return new int[]{Attribute.TYPE_NUMBER};
    }

    public static String getFunctionName() {
        return "LN";
    }

    public String toString(Relation relation) {
        return "LN(" + this.expr.toString(relation) + ")";
    }
}

