/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.opti;

import com.sun.org.apache.xerces.internal.impl.xs.opti.AttrImpl;
import com.sun.org.apache.xerces.internal.impl.xs.opti.DefaultDocument;
import com.sun.org.apache.xerces.internal.impl.xs.opti.ElementImpl;
import com.sun.org.apache.xerces.internal.impl.xs.opti.NodeImpl;
import com.sun.org.apache.xerces.internal.impl.xs.opti.TextImpl;
import com.sun.org.apache.xerces.internal.util.XMLSymbols;
import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SchemaDOM
extends DefaultDocument {
    static final int relationsRowResizeFactor = 15;
    static final int relationsColResizeFactor = 10;
    NodeImpl[][] relations;
    ElementImpl parent;
    int currLoc;
    int nextFreeLoc;
    boolean hidden;
    StringBuffer fAnnotationBuffer = null;

    public SchemaDOM() {
        this.reset();
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, int n, int n2) {
        ElementImpl elementImpl = new ElementImpl(n, n2);
        this.processElement(qName, xMLAttributes, elementImpl);
        this.parent = elementImpl;
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, int n, int n2) {
        ElementImpl elementImpl = new ElementImpl(n, n2);
        this.processElement(qName, xMLAttributes, elementImpl);
    }

    private void processElement(QName qName, XMLAttributes xMLAttributes, ElementImpl elementImpl) {
        int n;
        elementImpl.prefix = qName.prefix;
        elementImpl.localpart = qName.localpart;
        elementImpl.rawname = qName.rawname;
        elementImpl.uri = qName.uri;
        elementImpl.schemaDOM = this;
        Attr[] attrArray = new Attr[xMLAttributes.getLength()];
        for (n = 0; n < xMLAttributes.getLength(); ++n) {
            attrArray[n] = new AttrImpl(null, xMLAttributes.getPrefix(n), xMLAttributes.getLocalName(n), xMLAttributes.getQName(n), xMLAttributes.getURI(n), xMLAttributes.getValue(n));
        }
        elementImpl.attrs = attrArray;
        if (this.nextFreeLoc == this.relations.length) {
            this.resizeRelations();
        }
        if (this.relations[this.currLoc][0] != this.parent) {
            this.relations[this.nextFreeLoc][0] = this.parent;
            this.currLoc = this.nextFreeLoc++;
        }
        n = 0;
        int n2 = 1;
        for (n2 = 1; n2 < this.relations[this.currLoc].length; ++n2) {
            if (this.relations[this.currLoc][n2] != null) continue;
            n = 1;
            break;
        }
        if (n == 0) {
            this.resizeRelations(this.currLoc);
        }
        this.relations[this.currLoc][n2] = elementImpl;
        this.parent.parentRow = this.currLoc;
        elementImpl.row = this.currLoc;
        elementImpl.col = n2;
    }

    public void endElement() {
        this.currLoc = this.parent.row;
        this.parent = (ElementImpl)this.relations[this.currLoc][0];
    }

    void comment(XMLString xMLString) {
        this.fAnnotationBuffer.append("<!--").append(xMLString.toString()).append("-->");
    }

    void processingInstruction(String string, String string2) {
        this.fAnnotationBuffer.append("<?").append(string).append(" ").append(string2).append("?>");
    }

    void characters(XMLString xMLString) {
        for (int i = xMLString.offset; i < xMLString.offset + xMLString.length; ++i) {
            if (xMLString.ch[i] == '&') {
                this.fAnnotationBuffer.append("&amp;");
                continue;
            }
            if (xMLString.ch[i] == '<') {
                this.fAnnotationBuffer.append("&lt;");
                continue;
            }
            this.fAnnotationBuffer.append(xMLString.ch[i]);
        }
    }

    void endAnnotationElement(QName qName, boolean bl) {
        if (bl) {
            int n;
            this.fAnnotationBuffer.append("\n</").append(qName.rawname).append(">");
            ElementImpl elementImpl = (ElementImpl)this.relations[this.currLoc][1];
            if (this.nextFreeLoc == this.relations.length) {
                this.resizeRelations();
            }
            elementImpl.parentRow = this.nextFreeLoc++;
            int n2 = elementImpl.parentRow;
            boolean bl2 = false;
            for (n = 1; n < this.relations[n2].length; ++n) {
                if (this.relations[n2][n] != null) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                this.resizeRelations(n2);
            }
            this.relations[n2][n] = new TextImpl(this.fAnnotationBuffer, this, n2, n);
            this.fAnnotationBuffer = null;
        } else {
            this.fAnnotationBuffer.append("</").append(qName.rawname).append(">");
        }
    }

    void startAnnotationCDATA() {
        this.fAnnotationBuffer.append("<![CDATA[");
    }

    void endAnnotationCDATA() {
        this.fAnnotationBuffer.append("]]>");
    }

    private void resizeRelations() {
        NodeImpl[][] nodeImplArrayArray = new NodeImpl[this.relations.length + 15][];
        System.arraycopy(this.relations, 0, nodeImplArrayArray, 0, this.relations.length);
        for (int i = this.relations.length; i < nodeImplArrayArray.length; ++i) {
            nodeImplArrayArray[i] = new NodeImpl[10];
        }
        this.relations = nodeImplArrayArray;
    }

    private void resizeRelations(int n) {
        NodeImpl[] nodeImplArray = new NodeImpl[this.relations[n].length + 10];
        System.arraycopy(this.relations[n], 0, nodeImplArray, 0, this.relations[n].length);
        this.relations[n] = nodeImplArray;
    }

    public void reset() {
        int n;
        if (this.relations != null) {
            for (n = 0; n < this.relations.length; ++n) {
                for (int i = 0; i < this.relations[n].length; ++i) {
                    this.relations[n][i] = null;
                }
            }
        }
        this.relations = new NodeImpl[15][];
        this.parent = new ElementImpl(0, 0);
        this.parent.rawname = "DOCUMENT_NODE";
        this.currLoc = 0;
        this.nextFreeLoc = 1;
        for (n = 0; n < 15; ++n) {
            this.relations[n] = new NodeImpl[10];
        }
        this.relations[this.currLoc][0] = this.parent;
    }

    public void printDOM() {
    }

    public static void traverse(Node node, int n) {
        Object object;
        SchemaDOM.indent(n);
        System.out.print("<" + node.getNodeName());
        if (node.hasAttributes()) {
            object = node.getAttributes();
            for (int i = 0; i < object.getLength(); ++i) {
                System.out.print("  " + ((Attr)object.item(i)).getName() + "=\"" + ((Attr)object.item(i)).getValue() + "\"");
            }
        }
        if (node.hasChildNodes()) {
            System.out.println(">");
            n += 4;
            for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                SchemaDOM.traverse((Node)object, n);
            }
            SchemaDOM.indent(n -= 4);
            System.out.println("</" + node.getNodeName() + ">");
        } else {
            System.out.println("/>");
        }
    }

    public static void indent(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(' ');
        }
    }

    public Element getDocumentElement() {
        return (ElementImpl)this.relations[0][1];
    }

    void startAnnotation(QName qName, XMLAttributes xMLAttributes, NamespaceContext namespaceContext) {
        String string;
        String string2;
        if (this.fAnnotationBuffer == null) {
            this.fAnnotationBuffer = new StringBuffer(256);
        }
        this.fAnnotationBuffer.append("<").append(qName.rawname).append(" ");
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < xMLAttributes.getLength(); ++i) {
            string2 = xMLAttributes.getValue(i);
            string = xMLAttributes.getPrefix(i);
            vector.addElement(string2);
            this.fAnnotationBuffer.append(xMLAttributes.getQName(i)).append("=\"").append(string2).append("\" ");
        }
        Enumeration enumeration = namespaceContext.getAllPrefixes();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            string = namespaceContext.getURI(string2);
            if (vector.contains(string)) continue;
            if (string2 == XMLSymbols.EMPTY_STRING) {
                this.fAnnotationBuffer.append("xmlns").append("=\"").append(string).append("\" ");
                continue;
            }
            this.fAnnotationBuffer.append("xmlns:").append(string2).append("=\"").append(string).append("\" ");
        }
        this.fAnnotationBuffer.append(">\n");
    }

    void startAnnotationElement(QName qName, XMLAttributes xMLAttributes) {
        this.fAnnotationBuffer.append("<").append(qName.rawname).append(" ");
        for (int i = 0; i < xMLAttributes.getLength(); ++i) {
            String string = xMLAttributes.getValue(i);
            this.fAnnotationBuffer.append(" ").append(xMLAttributes.getQName(i)).append("=\"").append(SchemaDOM.processAttValue(string)).append("\" ");
        }
        this.fAnnotationBuffer.append(">");
    }

    private static String processAttValue(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

