/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/

#include "stdafx.h"
#include "cvocab.hpp"

IMPLEMENT_SERIAL( CVocabEntry, CObject, 1)

bool CVocabEntry::Contains( CString Word )
{
	int length = WordList.GetSize();

	for ( int count=0; count < length; count ++ )
	{
		if ( WordList[count] == Word )
			return true;
	}
	return false;
}

void CVocabEntry::Serialize( CArchive &ar )
{
	if ( ar.IsStoring() )
	{
		ar<<WordList.GetSize();
		for ( int i=0; i<WordList.GetSize(); i++)
		{
			ar<<WordList[i];
		}
	}
	else
	{
		int temp;
		ar>>temp;
		for ( int i=0; i<temp; i++)
		{
			CString TempString;
			ar>>TempString;
			WordList.Add(TempString);
		}
	}

}

IMPLEMENT_SERIAL( CVocab, CObject, 1)

CVocab :: CVocab ( void )
{
	Nouns.SetSize(1000);
	Verbs.SetSize(1000);
	Adjectives.SetSize(500);
	Adverbs.SetSize(500);
	Prepositions.SetSize(500);
	Pronouns.SetSize(500);
	Conjugations.SetSize(500);
}

CVocab::~CVocab()
{
	Nouns.RemoveAll();
	Verbs.RemoveAll();
	Adjectives.RemoveAll();
	Adverbs.RemoveAll();
	Prepositions.RemoveAll();
	Conjugations.RemoveAll();
}

int CVocab :: GetNoun( CString input )
{
	int noun_counter = 0;
	input.MakeUpper();

	for ( noun_counter=0; noun_counter<1000; noun_counter++ )
	{
		if ( Nouns[noun_counter].Contains( input ) )
			return	noun_counter;
	}

	return -1; // Noun Not Found
}

int CVocab :: GetVerb( CString input )
{
	int counter = 0;
	input.MakeUpper();


	for ( counter=0; counter<1000; counter++ )
	{
		if ( Verbs[counter].Contains( input ) )
			return	counter;
	}

	return -1; // Noun Not Found
}


int CVocab :: GetAdjective( CString input )
{
	int counter = 0;
	input.MakeUpper();


	for ( counter=0; counter<500; counter++ )
	{
		if ( Adjectives[counter].Contains(input) )
			return	counter;
	}

	return -1; // Noun Not Found
}

int CVocab :: GetAdverb( CString input )
{
	int counter = 0;
	input.MakeUpper();


	for ( counter=0; counter<500; counter++ )
	{
		if ( Adverbs[counter].Contains(input) )
			return	counter;
	}

	return -1; // Noun Not Found
}

int CVocab :: GetPreposition( CString input )
{
	int counter = 0;
	input.MakeUpper();


	for ( counter=0; counter<500; counter++ )
	{
		if ( Prepositions[counter].Contains(input) )
			return	counter;
	}

	return -1; // Noun Not Found
}

int CVocab :: GetPronoun( CString input )
{
	int counter = 0;
	input.MakeUpper();


	for ( counter=0; counter<500; counter++ )
	{
		if ( Pronouns[counter].Contains( input ) )
			return	counter;
	}

	return -1; // Noun Not Found
}

int CVocab :: GetConjugation( CString input )
{
	int counter = 0;
	input.MakeUpper();


	for ( counter=0; counter<500; counter++ )
	{
		if ( Conjugations[counter].Contains( input ) )
			return	counter;
	}

	return -1; // Noun Not Found
}

void CVocab :: SetVerb( CString Verb, int VerbNum )
{

	Verbs[VerbNum].Add(Verb);
}

void CVocab :: SetNoun( CString Noun, int NounNum )
{

	Nouns[NounNum].Add(Noun);
}

void CVocab :: SetAdjective ( CString Adjective, int AdjNum )
{
	Adjectives[AdjNum].Add(Adjective);
}

void CVocab :: SetAdverb ( CString Adverb, int AdverbNum )
{
	Adverbs[AdverbNum].Add(Adverb);
}

void CVocab :: SetPreposition( CString Prep, int PrepNum )
{
	Prepositions[PrepNum].Add(Prep);
}

void CVocab :: SetPronoun( CString ProNoun, int PNum )
{
	Pronouns[PNum].Add(ProNoun);
}

void CVocab :: SetConjugation( CString Conj, int ConjNum )
{
	Conjugations[ConjNum].Add(Conj);
}

void CVocab::Serialize( CArchive &ar )
{

	//Store and Retrieve vocabulary out of an archive
int count; 
int length;

if ( ar.IsStoring() )
{
	
	ar<<Verbs.GetSize();
	for ( count=0; count<Verbs.GetSize(); count++ )
	{
		Verbs[count].Serialize( ar );
	}

	ar<<Nouns.GetSize();
	for ( count=0; count<Nouns.GetSize(); count++ )
	{
		Nouns[count].Serialize( ar );
	}

	ar<<Adverbs.GetSize();
	for ( count=0; count<Adverbs.GetSize(); count++ )
	{
		Adverbs[count].Serialize( ar );
	}

	ar<<Adjectives.GetSize();
	for ( count=0; count<Adjectives.GetSize(); count++ )
	{
		Adjectives[count].Serialize( ar );
	}

	ar<<Pronouns.GetSize();
	for ( count=0; count<Pronouns.GetSize(); count++ )
	{
		Pronouns[count].Serialize( ar );
	}

	ar<<Prepositions.GetSize();
	for ( count=0; count<Prepositions.GetSize(); count++ )
	{
		Prepositions[count].Serialize( ar );
	}

	ar<<Conjugations.GetSize();
	for ( count=0; count<Conjugations.GetSize(); count++ )
	{
		Conjugations[count].Serialize( ar );
	}

}
else
{

	ar>>length;

	for ( count=0; count<length; count++ )
	{
		Verbs[count].Serialize( ar );
	}

	ar>>length;
	for ( count=0; count<length; count++ )
	{
		Nouns[count].Serialize( ar );
	}

	ar>>length;
	for ( count=0; count<length; count++ )
	{
		Adverbs[count].Serialize( ar );
	}

	ar>>length;
	for ( count=0; count<length; count++ )
	{
		Adjectives[count].Serialize( ar );
	}

	ar>>length;
	for ( count=0; count<length; count++ )
	{
		Pronouns[count].Serialize( ar );
	}

	ar>>length;
	for ( count=0; count<length; count++ )
	{
		Prepositions[count].Serialize( ar );
	}

	ar>>length;
	for ( count=0; count<length; count++ )
	{
		Conjugations[count].Serialize( ar );
	}
}

}


