\ io.f for advtr.f  Leo Wong 11 June 02003 fyj +
\ I/O routines ( speak pspeak rspeak yesm yesr ciao )

\ speak Print the message which starts at ca.
\   Precede it with a blankline unless blklin is false.
: speak  ( a -- )
   ?DUP IF @ ?DUP IF
        DUP CHAR+ S" >$<" TUCK COMPARE IF
        blklin IF CR THEN
        BEGIN COUNT DUP WHILE 2DUP CR TYPE CHARS + REPEAT DROP
        THEN DROP
   THEN THEN ;

\ Find the skip+1st message from msg and display it.  Msg should
\ be the index of the inventory message for the object.
\ (inven+n+1 message is prop = n message).
: pspeak  ( msg skip -- )
   DUP 0< 
   IF DROP ptext @ COUNT word> 2DROP skip-white CR TYPE
   ELSE >R ptext @ COUNT CHARS +
   BEGIN COUNT DUP WHILE 2DUP word> EVALUATE 100 / R@ = >R
    S" >$<" SEARCH 0= R> AND
    IF skip-white CR TYPE ELSE 2DROP THEN CHARS + REPEAT 2DROP 
   R> DROP THEN ;

\ Display the i-th "random" message (Section 6 of database)
: rspeak  ( i -- )
   rtext speak ;

\ Display the i'th "magic" message (Section 12 of database)
: mspeak  ( i -- )
   mtext speak ;
   

\ getin in utils.f

\ Print message x, wait for yes/no answer.  If yes, print y and leave
\ yea true; if no, print z and leave yea falSe.  Textpointer is either
\ rspeak or mspeak 
: y/n ( -- -1|1 )
   BEGIN
    getin word1 COUNT supper
    word1 CHAR+ DUP
    S" YES" TUCK s= SWAP C@ [CHAR] Y = OR -1 AND ?DUP 0= WHILE
    word1 CHAR+ DUP
    S" NO"  TUCK s= SWAP C@ [CHAR] N = OR  1 AND ?DUP 0= WHILE
    CR ." Please answer the question." 
   REPEAT THEN ;

: yesx ( x y z texttype --  flag ) 
   >R ROT R@  EXECUTE speak
   y/n 0< DUP 2SWAP ROT IF SWAP THEN NIP R> EXECUTE speak  ;

\ Yesx with arbitrary messages from Section 6
: yesr ( x y z -- flag )
   ['] rtext yesx ;

\ Yesx with magic messages from Section 12
: yesm ( x y z -- flag )
   ['] mtext yesx ;

\ append ca u to worda at PAD; return PAD and length
\ This will probably have to be changed
: a5toa1  ( worda ca u1 -- pad u2 )
    ROT COUNT PAD puts  PAD append  PAD count ;

\ ciao Exit after issuing reminder to save new core image.
\   Used when suspending and when creating new version via magic mode.
\   On some systems, the core image is lost once the program exits.
\   If so, set message = 31 instead of 32
: ciao ( -- )
   32 DUP mspeak 31 = IF getin THEN QUIT ;
