var code = ""
var fruits = []

var labels = {}
var synonyms = {}

var notes = {}
var state = {head: -1, style: "box"}
	
var commandHistory = []
var commandHistoryPointer = 0

var screenHistory = []
var screenHistoryPointer = 0
var autoClear = false

var autocompleteWords = []
var suspendAutocomplete
var previousValue
var importantWords = []

var moveLog = []
var commandLog = []

var backgrounds = {}
	
var dos = []
var backtracks = []
var go = true
	
var jitter = 10
var madness = 0
	
function Keypress(e) {
	if (go) Say("HUM! Is that why the clause below exists?")
	
	if (e.keyCode == 13 || go) {
		if (_commandline.value == "g" && commandHistory.length > 0)
			_commandline.value = commandHistory[commandHistory.length - 1]
		
		if (_commandline.value != "" && (commandHistory.length == 0 || commandHistory[commandHistory.length - 1] != _commandline.value))
			commandHistory.push(_commandline.value)
		
		if (_commandline.value.charAt(0) == "@") {
			try {
				eval(_commandline.value.substr(1))
			} catch (e) {
				Say(e.toString(), "box error")
			}
		}

		var tokens = _commandline.value.toLowerCase().split(' ')

		autocompleteWords = autocompleteWords.concat(tokens)
		
		for(var i = 0; i < tokens.length; i++) {
			if (synonyms[tokens[i]])
				tokens[i] = synonyms[tokens[i]]
		}

		var value = tokens.join(" ")
		
		commandLog.push (value)
		
		for(var i = dos.length - 1; i >= 0; i--) {
			var miss = false
			
			for(var j = 0; j < dos[i].tokens.length; j++) {
				var pattern = new RegExp(dos[i].tokens[j], "gi")
				
				if (!pattern.test(value)) {
					miss = true
				}
			}
			
			if (!miss) {
				Go(dos[i].target)
				break
			}
		}
		
		TimeFloats()
		Fadeout()

		Main()
		
		Preload()

		commandHistoryPointer = commandHistory.length

		_commandline.value = ""
	
	} else if (e.keyCode == 32) {
		if (_commandline.value.length == 0) {
			Main()
			e.preventDefault()
		}
	
	} else if (e.keyCode == 9) {
		DoAutocomplete()
		_commandline.value += " "
		e.preventDefault()
	
/*	} else if (e.keyCode == 27) {
		suspendAutocomplete = true
		_autocomplete.value = ""
		e.preventDefault()*/
		
	} else if (e.keyCode == 38) {
		History(-1)
		
	} else if (e.keyCode == 40) {
		History(1)
	}
}

function History(dir) {
	commandHistoryPointer += dir
	if (commandHistoryPointer < 0) commandHistoryPointer = 0
	if (commandHistoryPointer > commandHistory.length) commandHistoryPointer = commandHistory.length

	if (commandHistoryPointer == commandHistory.length) {
		_commandline.value = ""
		return
	}

	_commandline.value = commandHistory[commandHistoryPointer]
}

function UpdateAutocomplete () {
	if (previousValue == _commandline.value || suspendAutocomplete) return
	previousValue = _commandline.value
	
	if (_commandline.value.charAt(0) == "@") _commandline.style.color = "red"
	//else _commandline.style.color = "white"
	
	_autocomplete.style.color = _commandline.style.color
	
	for(var i = _commandline.value.length - 1; i >= 0; i--) {
		if (_commandline.value.charCodeAt(i) == 32) break
	}
	var token = _commandline.value.slice(i + 1).toLowerCase()
	
	if (token.length != 0) {		
		for(var i = autocompleteWords.length - 1; i >= 0; i--) {
			var suggestedCompletion = autocompleteWords[i]
			
			if (suggestedCompletion.length > 3 && suggestedCompletion.indexOf(token) == 0) {
				_autocomplete.value = _commandline.value + suggestedCompletion.slice(token.length)
				return
			}
		}
	}
		
	_autocomplete.value = ""
	
}

function DoAutocomplete () {
	if (!suspendAutocomplete && _autocomplete.value != "") {
		_commandline.value = _autocomplete.value
	}
	
	suspendAutocomplete = false
}

function MouseWheel (e) {
	if (e.wheelDelta > 1) {
		if (screenHistoryPointer == screenHistory.length) {
			_output.style.display = "none"
			_history.style.display = "block"
		}
		
		screenHistoryPointer--
		if (screenHistoryPointer < 0) screenHistoryPointer = 0
	} else {
		if (screenHistoryPointer == screenHistory.length) Main()
		
		screenHistoryPointer++
		if (screenHistoryPointer > screenHistory.length) screenHistoryPointer = screenHistory.length
		
		if (screenHistoryPointer == screenHistory.length) {
			_history.style.display = "none"
			_output.style.display = "block"
		}
	}
	
	if (screenHistoryPointer != screenHistory.length) {
		_history.innerHTML = screenHistory[screenHistoryPointer]
	}
}

function ClickAnywhere (e) {
	if (screenHistoryPointer < screenHistory.length) {
		screenHistoryPointer = screenHistory.length
		_history.style.display = "none"
		_output.style.display = "block"
	}
	
	if (e.button == 0) Main()
	
	_commandline.focus()
}

function Main () {
	go = true
	
	while (go) {
		state.head++
		if (state.head < 0 || state.head >= fruits.length) {
			Say("Out of bounds", "box error")
			break
		}
		
		Run(fruits[state.head])
	}
}

function Run (line) {
	if (line[0] != "\t") {
		Say(line)
	} else {
		try {
			eval(line)
		} catch (error) {
			Say(error + "</br>" + line, "box error")
		}
	}
}

function Say(text, c) {
	if (typeof text != "string") text = text.toString()
	if (!c) c = state.style
	go = false
	
	if (c != "box error") text = Substitutions(text)
	
	var node=document.createElement("P")
	node.setAttribute("Class", c)
		
	if (jitter > 0 && window.getComputedStyle(node).position == "relative") {
		node.style.left = (node.style.left + Math.random() * jitter * 2 - jitter) + "px"
		node.style.top = (node.style.top + Math.random() * jitter * 2 - jitter) + "px"
	}
	if (madness > 0)
		node.style.transform = "rotate(" + (Math.random() * madness * 2 - madness) + "deg)"
	
	autocompleteWords = autocompleteWords.concat(text.replace(/[^\w\s]/g, "").toLowerCase().split(' '))
	autocompleteWords = autocompleteWords.concat(importantWords)	
	
	if (autoClear) Clear()
	
	_output.appendChild(node)
	node.innerHTML = text
	
	if (_commandline.getBoundingClientRect().top < ScreenHeight() / 2)
		var target = ScreenHeight()
	else
		var target = _commandline.getBoundingClientRect().top
	
	if (node.getBoundingClientRect().bottom > target) {
		_output.removeChild(node)
		
		Clear()
	
		_output.appendChild(node)
	}
	
	return node
}

function Substitutions(text) {
	while (inlineCommands = text.match(/\[[^\]]+\]/g)) {
		for (var i = 0; i < inlineCommands.length; i++) { 
			try {
				var returnedValue = eval(inlineCommands[i].slice(1, -1))
			} catch (e) {
				text = e + "</br>" + inlineCommands[i].slice(1, -1)
				c = "box error"
			}
			text = text.replace (inlineCommands[i], returnedValue)
		}
	}
	
	while (clickCommands = text.match(/{[^}]+}/g)) {
		for (var i = 0; i < clickCommands.length; i++) {
			var halves = clickCommands[i].slice(1, -1).split('|')
			var returnedValue = "<span onclick='" + halves[0] + "; event.stopPropagation()' onmousedown='event.preventDefault()' class='click'>" + halves[1] + "</span>"
			
			text = text.replace (clickCommands[i], returnedValue)
		}
	}
	
	return text
}

function Choice() {
	var node = document.createElement("div")
	node.setAttribute("Class", "choice")
	node.setAttribute("Id", "choice")
	
	var text = ""
	for (var index = 0; index < arguments.length; index += 2) {
		text += "<p onclick = 'ChoiceClick(event, \"" + arguments[index + 1] + "\")'>"
		text += arguments[index]
		text += "</p>"
	}

	node.innerHTML = text

	document.body.appendChild(node)	
}

function Float(text, target, duration, mouseover) {
	var node = document.createElement("P")
	node.setAttribute("Class", "float")
	node.setAttribute("OnClick", "Go (event.currentTarget.target)")
	if (typeof target == "string")
		node.target = target.toLowerCase()
	else if (target)
		node.target = target
	else
		node.target = text
	node.ticks = duration
	node.tokens = text.toLowerCase().split(' ')
	node.dx = (Math.random() - 0.5) * 0.01
	node.dy = (Math.random() - 0.5) * 0.01
	
	if (mouseover) {
		node.onmouseover = function () {this.innerHTML = mouseover}
		node.onmouseout = function () {this.innerHTML = text}
	}
	
	node.innerHTML = text
	
	_output.appendChild(node)
	
	node.style.left = (Math.random() * (window.innerWidth - node.clientWidth)) + "px"
	node.style.top = (Math.random() * (window.innerHeight - node.clientHeight - 100)) + "px"
}

function Do(text, target) {
	var d = {}
	d.tokens = text.toLowerCase().split(' ')
	if (typeof target == "string")
		d.target = target.toLowerCase()
	else
		d.target = target
		
	dos.push(d)
}

function Drift() {
	var i = 0
	var time = new Date().getTime()

	while (floats[i]) {
		if (Math.random() < 0.1) floats[i].dx += 0.01
		if (Math.random() < 0.1) floats[i].dx -= 0.01
		if (Math.random() < 0.1) floats[i].dy += 0.01
		if (Math.random() < 0.1) floats[i].dy -= 0.01
		
		floats[i].style.left = parseFloat(floats[i].style.left) + floats[i].dx + "px"
		floats[i].style.top = parseFloat(floats[i].style.top) + floats[i].dy + "px"
		i++
	}
}

function TimeFloats () {
	var j = 0
	
	while (j < floats.length) {
		floats[0].ticks--
		if (floats[0].ticks == 0)
			floats[0].parentNode.removeChild(floats[0])
		else
			j++
	}
}

function Go (target) {
	if (typeof target == "function") {
		target()
		return
	}
	
	target = target.toLowerCase()
	state.segment = target
	
	backtracks.push(state.head)

	if (labels[target] != undefined)
		state.head = labels[target]
	else
		Say("No such label '" + target + "'", "box error")
	
	moveLog.push(target)
	
	dos = []
}

function Wait () {
	state.head--
	go = false
}

function Backtrack () {
	state.head = backtracks.pop()
}

function Style (text) {
	state.style = text
}

function Sprite (source, position) {
	var img = document.getElementById(position)
	if (img) {
		if (source == "none") {
			img.style.display = "none"
		} else {
			img.src = source
			img.style.display = "inline"
		}
	} else
		Say("No sprite position " + position, "box error")
}

function Bg (source) {
	 document.body.background = source

	Clear()
}

function Fx (source) {
	if (!Audio) return
	var snd = new Audio(source)
	snd.play()
}

function Note (category, name, text, quantity) {
	
}

function Fadeout () {
	var i = 0

	while (boxes[i]) {
		boxes[i].className += " grey"
		i++
	}
}

function Clear (type) {
	if (!type) type = "box"
	var elements = output.children
	var i = 0

	if (type == "box" && elements.length > 0) {
		while (elements[i]) {
			elements[i].className += " history"
			i++
		}
		
		screenHistory.push (_output.innerHTML)
		screenHistoryPointer = screenHistory.length
	}

	while (elements[0]) {
		elements[0].parentNode.removeChild(elements[0])
	}
}

function ClearDos (category) {
	i = dos.length
	while (i > 0) {
		i--
		if (dos[i].category == category) dos.splice (i, 1)
	}	
}