import "story/trial2"

function recess()
	clearImage()
	clearText()
	text [[The Court is now in recess. With her piercing gaze gone, the turned back of the Queen's statue sinks into the shadows at the back of the court.]]

	image("courtroom", "cover")

	jump "recess_hub"
end

function recess_hub()
	image("courtroom", "cover")
	if visited("recess_emblem") and visited("recess_cheat") and recessHobsonLicence then
		jump "recess_finish"
	end

	choiceOnce([[Talk to Leofric.]], "recess_leofric")
	if recessVulturesArguing then
		choice([[Attempt to talk to the lawyers.]], "recess_vulturesArgue")
	else
		if visited("recess_leofwine") then
			choice([[Try and bolster Leofwine's confidence.]], "recess_bolster")
		else
			choice([[Talk to Leofwine.]], "recess_leofwine")
		end
	end
	if not recessHobsonLicence then
		choice([[Talk to Hobson.]], "recess_hobson")
	else
		choice([[Attempt to talk to Hobson.]], "recess_hobson")
	end
	choice([[Talk to Scowles.]], "recess_scowles")
	choice([[Investigate the courtroom.]], "recess_investigate")
end

function recess_leofric()
	image "vultures"

	text [["Hullo, Leofric," you say, "how are you feeling about my chances of clearing my name and becoming a Citizen?"]]

	text [["You cannot distract me again," Leofric spits. "Whenever you come over here, smiling, you embolden Leofwine to make some spurious argument or other, which must then be carefully rebutted to save him from falling further into error. I will *not* allow you to waste my time any longer."]]

	jump "recess_hub"
end

function recess_leofwine()
	image "vultures"

	text [[Leofwine is holding his head up in the air, as straight as a war-pennant. His neck appears to be shaking.]]

	text [["Ah, Leofwine?" you ask. "How are you feeling?"]]

	text [[Immediately, Leofwine's head drops to the floor, like someone had knifed a marionette string holding it up.]]

	text [["Confident," he gurgles.]]

	choice([["You don't *seem* confident."]], "recess_leofwineConfident")
end

function recess_leofwineConfident()
	text [["Why shouldn't I be confident?" he continues. "I am winning a case. This has never happened before. I have every bit of confidence in my expertise, and in my client!"]]

	choice([["You've never won a case before?"]], "recess_neverWon")
end

function recess_neverWon()
	text [["Of course I haven't," Leofwine says. "I did not know that it was a possibility. And I do not know what will happen if I win! But I have the full confidence in the court to enact the proceedings in a satisfactory and robust manner, whatever the outcome."]]

	choice([["What should we do next?"]], "recess_doNext")
end

function recess_doNext()
	text [["Wait, and prepare," he squeaks. "Before long, the Remembrancer will return. *Tregaskis v Penhaligon* is none too well known a case - he had no idea he would have to take it with him.]]

	text [["Milpreve is usually well-prepared. Everything in the records becomes law, you see. More or less, anyway.]]

	text [["So! We too should make ourselves ready. Er. To the greatest extent possible." He shuffles awkwardly on his perch. "Remain confident!"]]

	text [[He still doesn't seem very confident.]]

	jump "recess_hub"
end

function recess_bolster()
	image "vultures"

	text [[You beckon Leofwine's neck closer towards you, away from his brother.]]

	text [["Dearest Leofwine!" you tell him. "If I may tell you, if you had not thought of that *Tregaskis v Penhaligon* idea, it would all be over! You're really very clever."]]

	text [[Leofwine nods as if he is already aware of how clever he is. He does not seem ungrateful, but it does not seem the problem lies with his intellectual pride.]]

	choice([["You've studied so hard. How could it be that someone like you could *never* win?"]], "recess_studied")
end

function recess_studied()
	if not visited("recess_studied") then
		text [[Leofwine glances over at his brother with obvious discomfort. Then he turns to you.]]

		text [["I cannot say," he says.]]

		text [[You sense he would love to tell you more, but with his physical situation, it does not seem like he will ever be able to say what is on his mind without Leofric hearing.]]
	end

	choiceOnce([["Is Milpreve biased against you?"]], "recess_biased")
	choiceOnce([["Is this the fault of the nefarious Leofric?"]], "recess_nefarious")
	choiceOnce([["But there must have been a time when you nearly won a case?"]], "recess_nearly")
end

function recess_biased()
	text [[You have barely finished asking the question before Leofwine's eyes widen perfectly round. He gestures at you with his beak for you to stop.]]

	text [["The court is fair, practical, and equitable," he responds. "The eyes of justice, and the eyes of precedence… under the fierce bronze eyes of the Queen!"]]

	text [[But the Queen's eyes on that statue are smooth marble, and perfectly empty. There is only one pair of eyes in this courtroom that are fierce and bronze, and they belong to Milpreve.]]

	jump "recess_studied"
end

function recess_nefarious()
	text [["You *must* be aware that I can hear you." Leofric responds. He sounds bored. "I merely carry out my task as a prosecutor. My record of success is no testament to my learning *or* that of my opponent – merely to the swift and just operation of the law, and the sagaciousness of the City's judgement in deciding which cases to prosecute."]]

	jump "recess_studied"
end

function recess_nearly()
	text [["Oh, yes! Several times, in fact." Leofwine puffs out their shared chest in pride. "In fact, one of my favourites was the case of *Edmund Hobson v The City of Gallos…*"]]

	text [[Leofric closes his eyes laterally. "Not this business again."]]

	text [["Stablemaster Hobson was accused of trying to use Ragwort, that absurdly hydromelated horse he's always tinkering with, to abscond from the city!]]

	text [["Of course, everybody knows that Hobson is always doing strange things for no reason, so there was no doubt in my mind he was innocent."]]

	text [["Yes," Leofric cuts in, "but the judge ruled against you. Hobson was sentenced to death, in accordance with statute, and subsequently allowed to return to society."]]

	text [[Hobson waves at you from the other side of the room. "The noose was itchy!"]]

	choice([["So is that how Hobson… ended up like he is?"]], "recess_skeleton")
end

function recess_skeleton()
	text [["Not at all," Leofric says, "that happened due to the passage of time, as is typical. As for what pushed him off in the first place, even he doesn't remember. Could have been anything. Horse accident. In any case the hanging was something of a formality."]]

	text [["His condition was fundamental to my defence," Leofwine continues, animated. "The only meaningful escape from Gallos would be to return overward. If Hobson set one phalange outside of the Undermarch, that which sustains his *animus* would disappear and he would cease to exist. Therefore, the crime he was accused of would be impossible to commit!"]]

	text [["Don't be ridiculous," snaps Leofric. "As was made clear at the time, the fact that a criminal intention cannot be enacted by the perpetrator does not prevent it from being a crime, as was confirmed by the precedent of *Piekarski v Allbright*–"]]

	text [["A case that *could not be more different*, as I'm sure you recall, being as it concerned a commercial transaction which formed the subject of a contractual agreement between the two parties, the *breach* of which placed Allbright in violation of–"]]

	text [[It looks like this might continue for some time.]]

	recessVulturesArguing = true

	jump "recess_hub"
end

function recess_vulturesArgue()
	image "vultures"

	text [[You wave your hand to catch the birds' attention, but are met with only flying down-feathers and squawks.]]

	vultureNonsense()

	text [[You doubt they would notice even if the Queen's statue got up and walked away.]]

	jump "recess_hub"
end

function recess_hobson()
	image "hobson"
	if not visited("recess_hobson") then
		text [[Hobson is sitting with his hands in his lap. You doubt he was paying much attention to the hearing.]]

		text [[Before you can greet him, he shows the back of his left hand to you, his fingers set in a complex position.]]

		text [["Do you know what chord this is?" he asks you. "With my thumb, here, on the second fret."]]

		choice([["E?"]], "recess_hobsonChord")
		choice([["D?"]], "recess_hobsonChord")
		choice([["…Q?"]], "recess_hobsonChord")
		choice([["I don't know."]], "recess_hobsonChord")
	elseif recessHobsonLicence then
		jump "recess_hobsonIgnore"
	else
		text [["No oratorios, no operettas, not so much as an ostinato," Hobson sighs. "Without a licence, I'm not permitted so much as one of those Mercerius temperance serenades that even children mock. If only Her Serenity's bureaucrats could understand the artistic soul!"]]

		jump "recess_luteHub"
	end
end

function recess_hobsonChord()
	text [["That's Vera Vincent's signature chord! She developed it with the freedom afforded in Gallos. Sadly," his hand relaxes – "too much of the Queen's sleep was impeded by Vera and her school, and now research into dissonance is far more regulated.]]

	text [["Imagine! If I had a lute licence, I could bring about the next evolution in music! But that small-minded snake won't accept that anything should change."]]

	jump "recess_luteHub"
end

function recess_luteHub()
	if recessLuteLicence then
		choice([[Issue Hobson with a lute licence.]], "recess_issueLicence")
	end
	choice([["That's a shame. Thank you for talking with me, Hobson." (Leave him alone.)]], "recess_hub")
end

function recess_issueLicence()
	text [[You hand him the square of vellum.]]

	text [["Here you go, Hobson," you tell him.]]

	text [[Hobson picks it from your hands and turns it over. When he notices the red border, his jaw unhinges spectacularly.]]

	text [["*Ouughnthhieeeaooiieehhh?!*" he attempts. Then snaps his jawbone back into place with his other hand, and says, "excuse me, I have temporomandibular issues. 'You're issuing me a lute licence?!'"]]

	text [[Without waiting for your reply, he spreads it open on the desk in front of him. He stares with his eyeless sockets into your face, overcome with emotion. Then he takes a smart writing-pen out of his breast pocket and signs his name.]]

	text [["Look at that," he breathes. "Look at it!"]]

	recessHobsonLicence = true

	choice([[Look at it.]], "recess_licenceLook")
end

function recess_licenceLook()
	text [["I am looking," you tell him. "That's both of your signatures. Yours, and Milpreve's."]]

	text [[Hobson unexpectedly bangs his fist on top of it.]]

	text [["That, my dear friend, is the beginning of the new era! Now I can complete learning Vera Vincent's cadenza in *The Merrie Storm-Caller of Penrood*."]]

	text [[You have never heard of such a thing.]]
	choice([["That sounds dramatic."]], "recess_luteDramatic")
	choice([["That sounds difficult."]], "recess_luteDifficult")
	choice([["That sounds loud."]], "recess_luteLoud")
end

function recess_luteDramatic()
	text [["It certainly is. The third movement, where the Storm-Caller howls for her dead lover and causes a lightning bolt to strike her heart, and then the two join their hands together in the Overplane, never fails to raise a tear." Hobson wipes a crumb out of the back of his empty eye socket.]]

	jump "recess_hub"
end

function recess_luteDifficult()
	text [["Did you know that Vera Vincent plays 18.6 notes per second in the opening movement?" Hobson seems to be signifying agreement. "It's her second fastest bravura passage, actually ahead of the iconic cadenza in *O, Cithara Deo Sentire Incipio*, but behind the crescendo in the third movement of *The Braggadocious Gnat*.]]

	text [["I can play about… I can almost get up to 4 notes per second, if it's a warm day."]]
	jump "recess_hub"
end

function recess_luteLoud()
	text [["Oh, it will be, tremendously." He leans in with a phalange tucked under his chin. "Vera Vincent's secret was catgut made from actual cats."]]
	jump "recess_hub"
end

function recess_hobsonIgnore()
	text [[Hobson does not pay any attention to you. He is staring at the lute licence on the desk in front of him, before occasionally fingering out an imaginary chord and humming the same tuneless string of notes he was plucking out in the stables.]]

	text [[You decide to leave him alone.]]
	jump "recess_hub"
end

function recess_scowles()
	text [[As you lift your gaze to Scowles's face, an enormous strength from beneath the voids of his eyes makes you fall silent. With a conviction that is not your own, you believe that you will succeed, and that you are loved.]]

	jump "recess_hub"
end

function recess_investigate()
	if not recessVulturesArguing then
		image "vultures"
		text [["Will the defendant please be seated!" Leofric snaps. "We cannot have every malefactor cantering about the hearing-room."]]

		text [[You look at Leofwine. He makes an indeterminate whimper through his see-through nostrils.]]

		jump "recess_hub"
	end

	image("courtroom", "cover")
	line [[What do you want to investigate?]]
	choice("Milpreve's papers.", "recess_papers")
	choice("The statue of the Queen.", "recess_statue")
end

function recess_papers()
	image("courtroom", "cover")

	if not visited("recess_papers") then
		text [[You wait for the lawyers to begin arguing again before slipping around behind Milpreve's chair. The lectern in front of him is piled thick with books and documents.]]

		text [[Most of the documents appear to be meaningless lists, but a few of the books catch your eye. Where do you wish to start?]]
	else
		text [[The lawyers are still hurling technicalities at each other. Milpreve has not yet returned.]]
	end

	choiceOnce([[Flip through *"Philosophia Extraordinaria Omnia"*]], "recess_omnia")
	choice([[Examine *"The Philosopher's Kingdom: How Thaumistics, Glamours and Magnificences Will Guarantee a Euphoria of Purpose Within Gallos, and Her Subjects and Objects*" by Gwenhaela Ros]], "recess_gallosBook")
	choiceOnce([[Peruse "*Lute Concerto No. 3 in E minor, Op. 12* by Gaspar Mercerius - Partbook"]], "recess_concerto")
	choice([[Leave the papers alone.]], "recess_hub")
end

function recess_omnia()
	text [[You will never be able to 'flip' through this overpowering, gilt-edged tome. The cover makes an audible thump as it falls against the wood of the lectern - mercifully, the birds do not appear to have noticed.]]

	text [[The type in the book is miniscule and even blurry. Was he using this as reference for his philosophy questions?]]

	choice([[There are papers stuck in the book.]], "recess_testPapers")
end

function recess_testPapers()
	text [[You open the book up on the appropriate page and take out the document. It is a stack of handwritten sheets and diagrams. The headings on the pages say things like "Galatology" and "Undermarch Spheres" - you infer that these are the answers to the philosophy test.]]

	jump "recess_cramOrCheat"
end

function recess_cramOrCheat()
	choiceOnce([[Cram!]], "recess_cram")
	choice([[Cheat!]], "recess_cheat")
end

function recess_cram()
	text [[The handwriting on the sheets is almost impenetrable. You squint.]]

	text [[*AntiLun. (fix var.) Right-Hand re vit 0/32 plastus 4th-orb vit., Sol situ. Mouth-Tongue re echo 12th, perl ax. Left-Hand ag. via TrueLun. 2nd…*]]

	text [[You rub the space between your eyebrows. Even if you could understand this, it would be absolute nonsense!]]

	text [[You know from your apothecary examinations that given a day's practice, you can recite a couple of pages of text that you do not understand. Memorising all this before Milpreve's return is impossible. You've forgotten it already!]]

	jump "recess_cramOrCheat"
end

function recess_cheat()
	text [[You turn over the papers to their blank side, take Milpreve's pen, and scribble down the answers you learned by rote for your most recent examination.]]

	text [[Your handwriting is large and legible compared to Milpreve's paranoid scrawl – should you have tried to forge his handwriting?]]

	text [[Maybe you should have thought of that before. It is too late now.]]

	jump "recess_papers"
end

function recess_gallosBook()
	text [[Gwenhaela Ros… is this book by *the* Gwenhaela? You glance over to the statue for answers. Her hair is crowned in flowers; her turned back says nothing.]]

	text [[You hoped the book would reveal some legal loophole that would allow you to turn the case to your advantage, but skimming it reveals it to be less a textbook than a manifesto. The redundant headings and rather circular, overexcited prose create the picture of a woman who wanted nothing more than the ability to close herself into a little room to read whatever books she wanted all day.]]

	text [[You recall a few arguments you have had with your mother about your similar aspirations, and wince. Better set this down before you start to get ideas.]]

	jump "recess_papers"
end

function recess_concerto()
	text [[This is the book Milpreve laid under his chair - it is soaking wet. You flip through several pages of sheet music. All you are capable of reading on sight is the lyrics, which take rather self-pitying stock of Mercerius's squabbles with his wife and the humiliations of being forced to play his lute outside.]]

	text [[Throughout the partbook, passages were highlighted with coloured ink, which have now bled all over it. Margin notes warn an 'examiner' to pay close attention to interpretation of these passages.]]

	text [[It seems that on Milpreve's way to the hearing-room, he dropped the partbook into the waterway. You assume this is why he reconsidered the idea of a musical proficiency assessment.]]

	text [[In the back cover is a paper pocket.]]

	choice([[Open the pocket.]], "recess_pocket")
end

function recess_pocket()
	text [[Inside the pocket are a selection of brightly coloured plectrum-quills and a folded piece of vellum with formal-looking red corners. You open it up.]]

	text [[THIS DOCUMENT CERTIFIES THAT THE BEARER IS A LUTE-PLAYER OF ADEQUATE PROFICIENCY, AND IS LICENSED TO MANIPULATE SAID INSTRUMENT IN APPROPRIATE MANNERS, SUBJECT TO THE CITY RULING ON AUDITORY NUISANCES, AND SUCH OTHER LAWS AS ARE APPLICABLE]]

	text [[At the bottom, next to the legend "AESTHETICS EXAMINER REGENT", is the signature of Milpreve. The assignee is left blank.]]

	choice([[Pocket the lute licence.]], "recess_takeLicence")
end

function recess_takeLicence()
	text [[You wipe its surface dry on your skirts, then fold it back up and put it in your pouch.]]

	recessLuteLicence = true

	jump "recess_papers"
end

function recess_statue()
	image "statue"

	if not visited("recess_statue") then
		text [[You stand at the foot of the Queen's statue and look up. Almost twice the size of a person's, the Queen's marble back is carved in an imitation of drape that lacks all transparency and movement. Instead, it gives an impression of stillness and solidity, like a pillar. On the middle of her back is a brass emblem.]]
	else
		text [[You look more carefully at the statue of the Queen, but nothing else is revealed to you. The same lifeless marble; the same neglected brass seal on her back, bearing the same funereal daylilies blooming around a Moon.]]
	end

	jump "recess_statueHub"
end

function recess_statueHub()
	choiceOnce([[Curtsy to her.]], "recess_curtsy")
	choiceOnce([[Attempt to hit her.]], "recess_hit")
	choiceOnce([[Look at the emblem.]], "recess_emblem")
	choice([[Step away from the statue.]], "recess_hub")
end

function recess_curtsy()
	if not visited("recess_hit") then
		text [[You do so.]]

		text [[Hobson, seeing you, gives you a thumbs up.]]
	else
		text [[With some disgust, you drop into a curtsy.]]

		text [["I'm sorry," you say.]]

		text [[Hobson, seeing you, relaxes.]]
	end
	jump "recess_statueHub"
end

function recess_hit()
	text [[The unfairness of everything that has been done to you and the humiliations of this ridiculous place boil up inside you like an unwatched porridge-pot. You make a strangled yelp of rage before slapping at the statue's thighs – as high as you can reach.]]

	text [[Ouch!]]

	text [[You glance over at the lawyers, who do not appear to have noticed you. But Hobson has, and you think you notice concern on his toothy face.]]

	text [[You clench your stinging palm into a fist, and resolve to keep a better handle on your emotions. Act like that again and it is over!]]

	jump "recess_statueHub"
end

function recess_emblem()
	text [[The brass on the emblem has tarnished from the exact lack of maintenance that you described to Milpreve in the trial.]]

	text [[It is a rounded ornament, a panel set into the centre of the statue's back, about the width of your hand.]]

	choice([[Get on tiptoes and squint.]], "recess_design")
end

function recess_design()
	text [[The design shows an entwined knot of daylilies.]]

	text [[Daylily blooms are useful for emesis during childbirth, and are easy to cultivate, but each flower only lasts for one day. This makes daylilies useless for nighttime emergencies and a popular motif on mourning-rings.]]

	text [[In the centre of the ring of daylilies is the Moon. Luna is revered by alchemists as a symbol of femininity, knowledge, and the *anima*.]]

	choice([[What's the *anima?*]], "recess_anima")
end

function recess_anima()
	text [[The soul is made of a male half, which is the *animus*, and the female half, which is the *anima*. The *animus* only exists for a short time, but the *anima* is forever.]]

	text [[The *anima* is the energy of sleep, dreams, inspiration, prayer, and those rare emotions that we feel outside of our bodies. It's known to be sensitive to aromatic herbs like hypericum, hemp, iboga and sleeping-poppy.]]

	text [[When the *animus*, which pumps the heart and inflates the lungs, fades from the body, the *anima* is released from it as well. Everybody agrees that it persists, although nobody agrees on where it goes or where it came from in the first place.]]

	text [[Philosophers say the *anima* becomes part of causality, which is how the dead sometimes appear to the living. Priests say the *anima* returns to God.]]

	text [[People who don't study religion or philosophy - which is most people - say that the *anima* goes to the Overplane where lovers are reunited, but only characters in depressing romantic poetry take it very seriously.]]

	text [[Children too young to understand any of this are taught that, when people die, they go to the Moon. In fact, this used to be the commonly-accepted belief at the time of the Second Empire, whose mighty civilisation was torn apart by a religious war ignited by the invention of the telescope.]]

	jump "recess_statueHub"
end

function recess_finish()
	jump "trial2"
end
