/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.Util;

class SwitchCmd
implements Command {
    private static final String[] validCmds = new String[]{"-exact", "-glob", "-regexp", "--"};
    private static final int EXACT = 0;
    private static final int GLOB = 1;
    private static final int REGEXP = 2;
    private static final int LAST = 3;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        TclObject[] switchArgv = null;
        int mode = 0;
        int i = 1;
        while (i < argv.length) {
            if (!argv[i].toString().startsWith("-")) break;
            int opt = TclIndex.get((Interp)interp, (TclObject)argv[i], (String[])validCmds, (String)"option", (int)1);
            if (opt == 3) {
                ++i;
                break;
            }
            if (opt > 3) {
                throw new TclException(interp, "SwitchCmd.cmdProc: bad option " + opt + " index to validCmds");
            }
            mode = opt;
            ++i;
        }
        if (argv.length - i < 2) {
            throw new TclNumArgsException(interp, 1, argv, "?switches? string pattern body ... ?default body?");
        }
        String string = argv[i].toString();
        if (argv.length - ++i == 1) {
            switchArgv = TclList.getElements(interp, argv[i]);
            i = 0;
        } else {
            switchArgv = argv;
        }
        while (i < switchArgv.length) {
            if (i == switchArgv.length - 1) {
                throw new TclException(interp, "extra switch pattern with no body");
            }
            boolean matched = false;
            String pattern = switchArgv[i].toString();
            if (i == switchArgv.length - 2 && pattern.equals("default")) {
                matched = true;
            } else {
                switch (mode) {
                    case 0: {
                        matched = string.equals(pattern);
                        break;
                    }
                    case 1: {
                        matched = Util.stringMatch(string, pattern);
                        break;
                    }
                    case 2: {
                        matched = Util.regExpMatch(interp, string, switchArgv[i]);
                        break;
                    }
                }
            }
            if (matched) {
                int body = i + 1;
                while (true) {
                    if (body >= switchArgv.length) {
                        throw new TclException(interp, "no body specified for pattern \"" + switchArgv[i] + "\"");
                    }
                    if (!switchArgv[body].toString().equals("-")) break;
                    body += 2;
                }
                try {
                    interp.eval(switchArgv[body], 0);
                    return;
                }
                catch (TclException e) {
                    if (e.getCompletionCode() == 1) {
                        interp.addErrorInfo("\n    (\"" + switchArgv[i] + "\" arm line " + interp.errorLine + ")");
                    }
                    throw e;
                }
            }
            i += 2;
        }
    }

    SwitchCmd() {
    }
}

