/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.TclToken;

class TclParse {
    char[] string;
    int endIndex;
    int commentStart;
    int commentSize;
    int commandStart;
    int commandSize;
    int numWords;
    TclToken[] tokenList;
    int numTokens;
    int tokensAvailable;
    Interp interp;
    String fileName;
    int lineNum;
    int termIndex;
    boolean incomplete;
    int result;
    static final int NUM_STATIC_TOKENS = 20;

    TclParse(Interp interp, char[] cArray, int n, String string, int n2) {
        this.interp = interp;
        this.string = cArray;
        this.endIndex = n;
        this.fileName = string;
        this.lineNum = n2;
        this.tokenList = new TclToken[20];
        this.tokensAvailable = 20;
        this.numTokens = 0;
        this.numWords = 0;
        this.commentStart = -1;
        this.commentSize = 0;
        this.commandStart = -1;
        this.commandSize = 0;
        this.incomplete = false;
    }

    TclToken getToken(int n) {
        while (n >= this.tokensAvailable) {
            this.expandTokenArray();
        }
        if (this.tokenList[n] == null) {
            this.tokenList[n] = new TclToken();
        }
        return this.tokenList[n];
    }

    void expandTokenArray() {
        this.tokensAvailable *= 2;
        TclToken[] tclTokenArray = new TclToken[this.tokensAvailable];
        System.arraycopy(this.tokenList, 0, tclTokenArray, 0, this.tokenList.length);
        this.tokenList = tclTokenArray;
    }

    public String toString() {
        return this.get().toString();
    }

    TclObject get() {
        TclObject tclObject = TclList.newInstance();
        try {
            if (this.commentSize > 0) {
                TclList.append(this.interp, tclObject, TclString.newInstance((String)new String(this.string, this.commentStart, this.commentSize)));
            } else {
                TclList.append(this.interp, tclObject, TclString.newInstance((String)"-"));
            }
            if (this.commandStart >= this.endIndex + 1) {
                this.commandStart = this.endIndex;
            }
            String string = new String(this.string, this.commandStart, this.commandSize);
            TclList.append(this.interp, tclObject, TclString.newInstance((String)string));
            TclList.append(this.interp, tclObject, TclInteger.newInstance(this.numWords));
            int n = 0;
            while (n < this.numTokens) {
                String string2;
                TclToken tclToken = this.tokenList[n];
                switch (tclToken.type) {
                    case 1: {
                        string2 = "word";
                        break;
                    }
                    case 2: {
                        string2 = "simple";
                        break;
                    }
                    case 4: {
                        string2 = "text";
                        break;
                    }
                    case 8: {
                        string2 = "backslash";
                        break;
                    }
                    case 16: {
                        string2 = "command";
                        break;
                    }
                    case 32: {
                        string2 = "variable";
                        break;
                    }
                    default: {
                        string2 = "??";
                    }
                }
                TclList.append(this.interp, tclObject, TclString.newInstance((String)string2));
                TclList.append(this.interp, tclObject, TclString.newInstance((String)tclToken.getTokenString()));
                TclList.append(this.interp, tclObject, TclInteger.newInstance(tclToken.numComponents));
                ++n;
            }
            int n2 = this.commandStart + this.commandSize;
            TclList.append(this.interp, tclObject, TclString.newInstance((String)new String(this.string, n2, this.endIndex - n2)));
        }
        catch (TclException tclException) {}
        return tclObject;
    }
}

