/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import tcl.lang.Channel;
import tcl.lang.ConsoleEvent;
import tcl.lang.Interp;
import tcl.lang.Parser;
import tcl.lang.StdChannel;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;

class ConsoleThread
extends Thread {
    Interp interp;
    Vector historyObjs;
    StringBuffer sbuf;
    private Channel in;
    private Channel out;
    private Channel err;

    ConsoleThread(Interp interp) {
        this.interp = interp;
        this.sbuf = new StringBuffer();
        this.historyObjs = new Vector();
        this.out = new StdChannel("stdout");
        this.err = new StdChannel("stderr");
    }

    public synchronized void run() {
        this.put(this.out, "% ");
        while (true) {
            TclObject tclObject;
            this.sbuf.append(this.getLine());
            Object object = this.sbuf.toString();
            if (Parser.commandComplete((String)object, ((String)object).length())) {
                Object object2;
                int n;
                Object object3;
                object = new ConsoleEvent(this.interp, this.sbuf.toString());
                this.interp.getNotifier().queueEvent((TclEvent)object, 0);
                ((TclEvent)object).sync();
                if (((ConsoleEvent)object).evalResult != null) {
                    object3 = ((ConsoleEvent)object).evalResult;
                    if (((TclObject)object3).stringRep == null) {
                        ((TclObject)object3).stringRep = ((TclObject)object3).internalRep.toString();
                    }
                    if (((String)(object3 = ((TclObject)object3).stringRep)).length() > 0) {
                        Channel channel = this.out;
                        this.put(channel, (String)object3);
                        this.put(channel, "\n");
                    }
                    n = 0;
                    try {
                        object2 = this.interp;
                        object2 = ((Interp)object2).varFrame.getVar("historyLimit", 2049);
                        if (object2 != null) {
                            n = TclInteger.get(this.interp, (TclObject)object2);
                        }
                    }
                    catch (TclException tclException) {}
                    if (n > 0) {
                        this.historyObjs.addElement(((ConsoleEvent)object).evalResult);
                    } else {
                        ((ConsoleEvent)object).evalResult.release();
                    }
                    if (this.historyObjs.size() > n && this.historyObjs.size() > 0) {
                        object2 = (TclObject)this.historyObjs.elementAt(0);
                        this.historyObjs.removeElementAt(0);
                        ((TclObject)object2).release();
                    }
                } else {
                    object3 = ((ConsoleEvent)object).evalException;
                    n = ((TclException)object3).getCompletionCode();
                    if (n != 2 || (n = this.interp.updateReturnInfo()) != 0) {
                        switch (n) {
                            case 1: {
                                object2 = this.err;
                                Object object4 = this.interp.getResult();
                                if (((TclObject)object4).stringRep == null) {
                                    ((TclObject)object4).stringRep = ((TclObject)object4).internalRep.toString();
                                }
                                object4 = ((TclObject)object4).stringRep;
                                this.put((Channel)object2, (String)object4);
                                this.put((Channel)object2, "\n");
                                break;
                            }
                            case 3: {
                                object2 = this.err;
                                this.put((Channel)object2, "invoked \"break\" outside of a loop");
                                this.put((Channel)object2, "\n");
                                break;
                            }
                            case 4: {
                                object2 = this.err;
                                this.put((Channel)object2, "invoked \"continue\" outside of a loop");
                                this.put((Channel)object2, "\n");
                                break;
                            }
                            default: {
                                object2 = this.err;
                                Object object4 = "command returned bad code: " + n;
                                this.put((Channel)object2, (String)object4);
                                this.put((Channel)object2, "\n");
                            }
                        }
                    }
                }
                this.sbuf.setLength(0);
                try {
                    object3 = this.interp;
                    tclObject = ((Interp)object3).varFrame.getVar("tcl_prompt1", 1);
                }
                catch (TclException tclException) {
                    tclObject = null;
                }
                if (tclObject != null) {
                    try {
                        if (tclObject.stringRep == null) {
                            tclObject.stringRep = tclObject.internalRep.toString();
                        }
                        this.interp.eval(tclObject.stringRep, 1);
                    }
                    catch (TclException tclException) {
                        this.put(this.out, "% ");
                    }
                    continue;
                }
                this.put(this.out, "% ");
                continue;
            }
            try {
                object = this.interp;
                tclObject = ((Interp)object).varFrame.getVar("tcl_prompt2", 1);
            }
            catch (TclException tclException) {
                tclObject = null;
            }
            if (tclObject != null) {
                try {
                    if (tclObject.stringRep == null) {
                        tclObject.stringRep = tclObject.internalRep.toString();
                    }
                    this.interp.eval(tclObject.stringRep, 1);
                }
                catch (TclException tclException) {
                    this.put(this.out, "> ");
                }
                continue;
            }
            this.put(this.out, "> ");
        }
    }

    private String getLine() {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        try {
            System.in.available();
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl) {
            try {
                while (System.in.available() == 0) {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                System.exit(0);
            }
            catch (EOFException eOFException) {
                System.exit(0);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(0);
            }
        }
        char c2 = ' ';
        do {
            c = ' ';
            try {
                int n = System.in.read();
                if (n == -1) {
                    if (stringBuffer.length() == 0) {
                        System.exit(0);
                    } else {
                        return stringBuffer.toString();
                    }
                }
                if ((c = (char)((char)n)) == '\r') {
                    n = System.in.read();
                    if (n == -1) {
                        if (stringBuffer.length() == 0) {
                            System.exit(0);
                        } else {
                            return stringBuffer.toString();
                        }
                    }
                    if ((c2 = (char)((char)n)) == '\n') {
                        c = c2;
                    } else {
                        stringBuffer.append(c);
                        c = c2;
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(0);
            }
            stringBuffer.append(c);
        } while (c != 10);
        return stringBuffer.toString();
    }

    private void putLine(Channel channel, String string) {
        this.put(channel, string);
        this.put(channel, "\n");
    }

    private void put(Channel channel, String string) {
        try {
            this.out.write(this.interp, string);
            return;
        }
        catch (Exception exception) {
            throw new TclRuntimeError("unexpected Exception " + exception);
        }
    }
}

