/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import tcl.lang.ClassRep;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

class JavaInfoCmd
implements Command {
    private static final String[] validCmds = new String[]{"class", "baseclass", "dimensions", "events", "fields", "methods", "constructors", "properties", "superclass"};
    private static final int CLASS = 0;
    private static final int BASECLASS = 1;
    private static final int DIMENSIONS = 2;
    private static final int EVENTS = 3;
    private static final int FIELDS = 4;
    private static final int METHODS = 5;
    private static final int CONSTRUCTORS = 6;
    private static final int PROPERTIES = 7;
    private static final int SUPERCLASS = 8;
    private static final String[] propOpts = new String[]{"-type"};
    private static final String[] methOpts = new String[]{"-type", "-static"};
    static final int TYPE_OPT = 0;
    static final int STATIC_OPT = 1;

    /*
     * Unable to fully structure code
     */
    public void cmdProc(Interp var1_1, TclObject[] var2_2) throws TclException {
        var3_3 = var2_2.length - 1;
        var4_4 = false;
        var5_5 = false;
        if (var2_2.length < 2) {
            throw new TclNumArgsException(var1_1, 1, var2_2, "option ?arg arg ...?");
        }
        var9_6 = TclIndex.get(var1_1, var2_2[1], JavaInfoCmd.validCmds, "option", 0);
        switch (var9_6) {
            case 1: {
                if (var2_2.length != 3) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "objOrClass");
                }
                var7_7 = JavaInfoCmd.getClassFromObj(var1_1, var2_2[2]);
                var10_15 = JavaInfoCmd.getBaseNameFromClass(var7_7);
                if (var10_15 == null) {
                    var1_1.resetResult();
                    return;
                }
                var1_1.setResult(TclString.newInstance((String)var10_15));
                return;
            }
            case 0: {
                if (var2_2.length != 3) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "javaObj");
                }
                var8_22 = ReflectObject.get(var1_1, var2_2[2]);
                var10_16 = JavaInfoCmd.getNameFromClass(var8_22.getClass());
                if (var10_16 == null) {
                    var1_1.resetResult();
                    return;
                }
                var1_1.setResult(TclString.newInstance((String)var10_16));
                return;
            }
            case 2: {
                if (var2_2.length != 3) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "objOrClass");
                }
                var7_8 = JavaInfoCmd.getClassFromObj(var1_1, var2_2[2]);
                var10_17 = JavaInfoCmd.getNumDimsFromClass(var7_8);
                var1_1.setResult(TclInteger.newInstance(var10_17));
                return;
            }
            case 3: {
                if (var2_2.length != 3) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "javaObj");
                }
                var7_9 = JavaInfoCmd.getClassFromObj(var1_1, var2_2[2]);
                try {
                    var10_18 = Introspector.getBeanInfo(var7_9);
                }
                catch (IntrospectionException v0) {
                    ** GOTO lbl54
                }
                var11_23 = var10_18.getEventSetDescriptors();
                if (var11_23 != null) {
                    var12_24 = TclList.newInstance();
                    var13_25 = 0;
                    while (var13_25 < var11_23.length) {
                        TclList.append(var1_1, var12_24, TclString.newInstance((String)var11_23[var13_25].getListenerType().getName()));
                        ++var13_25;
                    }
                    var1_1.setResult(var12_24);
                    return;
                }
lbl54:
                // 3 sources

                var1_1.resetResult();
                return;
            }
            case 4: {
                if (var3_3 < 2 || var3_3 > 4) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "?-type? ?-static? objOrClass");
                }
                var10_19 = 2;
                while (var10_19 < var3_3) {
                    var9_6 = TclIndex.get(var1_1, var2_2[var10_19], JavaInfoCmd.methOpts, "option", 0);
                    switch (var9_6) {
                        case 1: {
                            var4_4 = true;
                            break;
                        }
                        case 0: {
                            var5_5 = true;
                        }
                    }
                    ++var10_19;
                }
                var7_10 = JavaInfoCmd.getClassFromObj(var1_1, var2_2[var3_3]);
                var6_26 = JavaInfoCmd.getFieldInfoList(var1_1, var7_10, var4_4, var5_5);
                var1_1.setResult(var6_26);
                return;
            }
            case 5: {
                if (var3_3 < 2 || var3_3 > 4) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "?-type? ?-static? objOrClass");
                }
                var10_20 = 2;
                while (var10_20 < var3_3) {
                    var9_6 = TclIndex.get(var1_1, var2_2[var10_20], JavaInfoCmd.methOpts, "option", 0);
                    switch (var9_6) {
                        case 1: {
                            var4_4 = true;
                            break;
                        }
                        case 0: {
                            var5_5 = true;
                        }
                    }
                    ++var10_20;
                }
                var7_11 = JavaInfoCmd.getClassFromObj(var1_1, var2_2[var3_3]);
                var6_27 = JavaInfoCmd.getMethodInfoList(var1_1, var7_11, var4_4, var5_5);
                var1_1.setResult(var6_27);
                return;
            }
            case 6: {
                if (var2_2.length != 3) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "objOrClass");
                }
                var7_12 = JavaInfoCmd.getClassFromObj(var1_1, var2_2[var3_3]);
                var6_28 = JavaInfoCmd.getConstructorInfoList(var1_1, var7_12);
                var1_1.setResult(var6_28);
                return;
            }
            case 7: {
                if (var3_3 < 2 || var3_3 > 3) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "?-type? objOrClass");
                }
                if (var3_3 == 3) {
                    var9_6 = TclIndex.get(var1_1, var2_2[2], JavaInfoCmd.propOpts, "option", 0);
                    var5_5 = true;
                }
                var7_13 = JavaInfoCmd.getClassFromObj(var1_1, var2_2[var3_3]);
                var6_29 = JavaInfoCmd.getPropInfoList(var1_1, var7_13, var5_5);
                var1_1.setResult(var6_29);
                return;
            }
            case 8: {
                if (var2_2.length != 3) {
                    throw new TclNumArgsException(var1_1, 2, var2_2, "objOrClass");
                }
                var7_14 = JavaInfoCmd.getClassFromObj(var1_1, var2_2[2]).getSuperclass();
                var10_21 = "";
                if (var7_14 != null) {
                    var10_21 = JavaInfoCmd.getNameFromClass(var7_14);
                }
                if (var10_21 == null) {
                    var1_1.resetResult();
                    return;
                }
                var1_1.setResult(TclString.newInstance((String)var10_21));
                return;
            }
        }
    }

    private static Class getClassFromObj(Interp interp, TclObject tclObject) throws TclException {
        Class clazz;
        try {
            clazz = ReflectObject.get(interp, tclObject).getClass();
        }
        catch (TclException tclException) {
            try {
                clazz = ClassRep.get(interp, tclObject);
            }
            catch (TclException tclException2) {
                throw new TclException(interp, "unknown java class or object \"" + tclObject + "\"");
            }
        }
        return clazz;
    }

    private static TclObject getPropInfoList(Interp interp, Class clazz, boolean bl) throws TclException {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            throw new TclException(interp, introspectionException.toString());
        }
        PropertyDescriptor[] propertyDescriptorArray = null;
        propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        TclObject tclObject = TclList.newInstance();
        int n = 0;
        while (n < propertyDescriptorArray.length) {
            TclObject tclObject2;
            TclObject tclObject3 = TclList.newInstance();
            if (bl && (tclObject2 = TclString.newInstance((String)propertyDescriptorArray[n].getPropertyType().getName())) != null) {
                TclList.append(interp, tclObject3, tclObject2);
            }
            tclObject2 = TclString.newInstance((String)propertyDescriptorArray[n].getName());
            TclList.append(interp, tclObject3, tclObject2);
            TclList.append(interp, tclObject, tclObject3);
            ++n;
        }
        return tclObject;
    }

    private static TclObject getFieldInfoList(Interp interp, Class clazz, boolean bl, boolean bl2) throws TclException {
        Field[] fieldArray;
        try {
            fieldArray = clazz.getFields();
        }
        catch (SecurityException securityException) {
            throw new TclException(interp, securityException.toString());
        }
        TclObject tclObject = TclList.newInstance();
        int n = 0;
        while (n < fieldArray.length) {
            boolean bl3;
            boolean bl4 = bl3 = (fieldArray[n].getModifiers() & 8) > 0;
            if (bl3 == bl) {
                TclObject tclObject2 = TclList.newInstance();
                String string = fieldArray[n].getName();
                TclObject tclObject3 = TclString.newInstance((String)string);
                TclList.append(interp, tclObject2, tclObject3);
                Class<?> clazz2 = fieldArray[n].getDeclaringClass();
                if (!clazz2.equals(clazz)) {
                    int n2 = 0;
                    while (n2 < fieldArray.length) {
                        Class<?> clazz3;
                        if (n2 != n && string.equals(fieldArray[n2].getName()) && clazz2.isAssignableFrom(clazz3 = fieldArray[n2].getDeclaringClass())) {
                            tclObject3 = TclString.newInstance((String)clazz2.getName());
                            TclList.append(interp, tclObject2, tclObject3);
                            break;
                        }
                        ++n2;
                    }
                }
                if (bl2) {
                    TclObject tclObject4 = TclList.newInstance();
                    tclObject3 = TclString.newInstance((String)JavaInfoCmd.getNameFromClass(fieldArray[n].getType()));
                    TclList.append(interp, tclObject4, tclObject3);
                    TclList.append(interp, tclObject4, tclObject2);
                    TclList.append(interp, tclObject, tclObject4);
                } else {
                    TclList.append(interp, tclObject, tclObject2);
                }
            }
            ++n;
        }
        return tclObject;
    }

    private static TclObject getMethodInfoList(Interp interp, Class clazz, boolean bl, boolean bl2) throws TclException {
        Method[] methodArray;
        try {
            methodArray = clazz.getMethods();
        }
        catch (SecurityException securityException) {
            throw new TclException(interp, securityException.toString());
        }
        new Hashtable(methodArray.length + 1);
        TclObject tclObject = TclList.newInstance();
        int n = 0;
        while (n < methodArray.length) {
            boolean bl3;
            boolean bl4 = bl3 = (methodArray[n].getModifiers() & 8) > 0;
            if (bl3 == bl) {
                TclObject tclObject2 = TclList.newInstance();
                TclObject tclObject3 = TclString.newInstance((String)methodArray[n].getName());
                TclList.append(interp, tclObject2, tclObject3);
                Class<?>[] classArray = methodArray[n].getParameterTypes();
                int n2 = 0;
                while (n2 < classArray.length) {
                    tclObject3 = TclString.newInstance((String)JavaInfoCmd.getNameFromClass(classArray[n2]));
                    TclList.append(interp, tclObject2, tclObject3);
                    ++n2;
                }
                if (bl2) {
                    TclObject tclObject4 = TclList.newInstance();
                    TclObject tclObject5 = TclList.newInstance();
                    Class<?>[] classArray2 = methodArray[n].getExceptionTypes();
                    int n3 = 0;
                    while (n3 < classArray2.length) {
                        TclList.append(interp, tclObject5, TclString.newInstance((String)classArray2[n3].getName()));
                        ++n3;
                    }
                    TclList.append(interp, tclObject4, TclString.newInstance((String)JavaInfoCmd.getNameFromClass(methodArray[n].getReturnType())));
                    TclList.append(interp, tclObject4, tclObject2);
                    TclList.append(interp, tclObject4, tclObject5);
                    TclList.append(interp, tclObject, tclObject4);
                } else {
                    TclList.append(interp, tclObject, tclObject2);
                }
            }
            ++n;
        }
        return tclObject;
    }

    private static TclObject getConstructorInfoList(Interp interp, Class clazz) throws TclException {
        Constructor<?>[] constructorArray;
        try {
            constructorArray = clazz.getConstructors();
        }
        catch (SecurityException securityException) {
            throw new TclException(interp, securityException.toString());
        }
        TclObject tclObject = TclList.newInstance();
        int n = 0;
        while (n < constructorArray.length) {
            TclObject tclObject2 = TclList.newInstance();
            TclObject tclObject3 = TclString.newInstance((String)constructorArray[n].getName());
            TclList.append(interp, tclObject2, tclObject3);
            Class<?>[] classArray = constructorArray[n].getParameterTypes();
            int n2 = 0;
            while (n2 < classArray.length) {
                tclObject3 = TclString.newInstance((String)JavaInfoCmd.getNameFromClass(classArray[n2]));
                TclList.append(interp, tclObject2, tclObject3);
                ++n2;
            }
            TclList.append(interp, tclObject, tclObject2);
            ++n;
        }
        return tclObject;
    }

    static int getNumDimsFromClass(Class clazz) {
        Class<?> clazz2 = clazz;
        int n = 0;
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
            ++n;
        }
        return n;
    }

    static String getNameFromClass(Class clazz) {
        String string = "";
        Class<?> clazz2 = clazz;
        while (clazz2.isArray()) {
            string = String.valueOf(string) + "[]";
            clazz2 = clazz2.getComponentType();
        }
        return String.valueOf(clazz2.getName()) + string;
    }

    private static String getBaseNameFromClass(Class clazz) {
        Class<?> clazz2 = clazz;
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
        }
        return clazz2.getName();
    }

    JavaInfoCmd() {
    }
}

