(*
$File: Compiler/CompilerDynamicBasis.sml $
$Date: 1992/09/17 14:17:47 $
$Revision: 1.1 $
$Locker:  $
*)

(*$CompilerDynamicBasis:
	COMPILER_ENV DYNAMIC_ENV REPORT PRETTYPRINT COMPILER_DYNAMIC_BASIS
 *)
functor CompilerDynamicBasis(structure CompilerEnv: COMPILER_ENV
			     structure DynamicEnv: DYNAMIC_ENV

			     structure Report: REPORT

			     structure PP: PRETTYPRINT
			     sharing type CompilerEnv.StringTree
			                  = DynamicEnv.StringTree
					  = PP.StringTree
				 and type PP.Report = Report.Report
			    ): COMPILER_DYNAMIC_BASIS =
  struct
    type CEnv = CompilerEnv.CEnv
    type DEnv = DynamicEnv.DEnv

    type Basis = {compilerEnv: CEnv, dynamicEnv: DEnv}

    fun mkBasis(ce, de) = {compilerEnv=ce, dynamicEnv=de}
    fun deBasis{compilerEnv=ce, dynamicEnv=de} = (ce, de)
      
    fun E_in_B x = x
    fun E_of_B x = x
    fun B_plus_B({compilerEnv=ce, dynamicEnv=de},
		 {compilerEnv=ce', dynamicEnv=de'}
		) =
      {compilerEnv=CompilerEnv.plus(ce, ce'),
       dynamicEnv=DynamicEnv.plus(de, de')
      }

    val emptyBasis =
      mkBasis(CompilerEnv.emptyCEnv, DynamicEnv.emptyDEnv)

    val initialBasis =
      mkBasis(CompilerEnv.initialCEnv, DynamicEnv.emptyDEnv)

    type StringTree = PP.StringTree
    fun layoutBasis{compilerEnv=ce, dynamicEnv=de} =
      PP.NODE{start="{", finish="}", indent=1, childsep=PP.RIGHT "; ",
	      children=[CompilerEnv.layoutCEnv ce,
			DynamicEnv.layoutDEnv de
		       ]
	     }

    type Report = Report.Report
    fun reportBasis _ = Report.line "<unimplemented: reportBasis>"
  end;
