(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Thu Nov  2 21:55:32 1989 by muller         *)
(*      modified on Fri Sep 29 15:11:26 1989 by kalsow         *)
(*      modified on Sun May  7 15:35:59 1989 by stolfi         *)

INTERFACE Address;

(* Some standard operations on ADDRESS.

   This package defines some standard types and operations
   on ADDRESS.  When (if) Modula-3 has generics, this interface
   will be useful.

   Index: addresses, exported
*)

TYPE T = ADDRESS;

PROCEDURE New (value: T): REF T;
(* Allocates and initializes a new heap value *)

PROCEDURE NewArray (size: CARDINAL;  value: T := NIL): REF ARRAY OF T;
(* Allocates a new array from the heap
  and initializes all its elements with the given value *)

PROCEDURE UntracedNew (value: T): UNTRACED REF T;
(* Allocates and initializes a new untraced value *)

PROCEDURE UntracedNewArray (size: CARDINAL;  value: T := NIL):
                                                       UNTRACED REF ARRAY OF T;
(* Allocates a new untraced array from the heap
  and initializes all its elements with the given value *)

PROCEDURE Compare (a, b: T): INTEGER;
(* == RETURN (a - b) *)

PROCEDURE Lt (a, b: T): BOOLEAN;
(* == RETURN (a < b) *)

PROCEDURE Eq (a, b: T): BOOLEAN;
(* == RETURN (a = b) *)

PROCEDURE Hash (a: T): INTEGER;
(* returns a suitable hash value *)

END Address.
