(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Wed Nov 18 12:58:54 MET 1992 by preschern                *)

INTERFACE DOSTextRd;

(* A DOSTextRd.T is a "transparent filter". All operations performed on the
   parent are actually performed on the child; 
   
   The argument to DOSTextRd.New is a (just opened) reader for a DOS 
   file opened in binary mode. This reader maps this DOS "binary" file
   to a DOS text file.
   CR/LF combinations are mapped to LF. Ctrl Z (DOS eof) is ignored.
   Note: this implementation assumes that no operations take place on the
         reader given as argument to New. All operations should be done 
         on T.
*)

IMPORT Rd;

TYPE T <: Rd.T;

PROCEDURE New (rd: Rd.T): T;

END DOSTextRd.

