(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Fri Jan 31 10:11:32 PST 1992 by kalsow     *)
(*      modified on Tue Sep 25 00:38:09 1990 by muller         *)

INTERFACE RTTypeFP;

(* This interface provides a safe interface to the runtime
   type system's fingerprints.  *)

IMPORT RT0;

TYPE
  Typecode    = RT0.Typecode;
  Fingerprint = RT0.Fingerprint;
  (* a fingerprint is a 64-bit hash value computed from a type's
     declaration.  The probability of distinct types having the
     same fingerprint is very small. *)

PROCEDURE UIDToFingerprint (id: INTEGER): Fingerprint;
(* returns the fingerprint corresponding to the compiler generated 'id'.
   It is a checked runtime error if 'id' is not registered. *)

PROCEDURE ToFingerprint (tc: Typecode): Fingerprint;
(* returns the fingerprint corresponding to 'tc'.  It is a checked
   runtime error if 'tc' is not proper. *)

PROCEDURE FromFingerprint (READONLY fp: Fingerprint): Typecode;
(* returns the typecode that corresponds to 'fp'.  If no such typecode
   exists, FromFingerprint returns NoSuchType. *)

END RTTypeFP.


