(* Copyright (C) 1990, 1992, Digital Equipment Corporation                   *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Last modified on Wed Mar  4 13:00:56 PST 1992 by muller                   *)
(*      modified on Thu Feb 27 16:03:37 PST 1992 by kalsow                   *)

UNSAFE MODULE RTMain;

IMPORT RT0, RT0u, RTHeap, RTLoader, RTMisc, RTParams, RTType, RTSignal;

<*UNUSED*> VAR copyright := ARRAY [0..36] OF TEXT {
  "              SRC Modula-3 Non-commercial License",
  "",
  "SRC Modula-3 is distributed by Digital Equipment Corporation ('DIGITAL'),",
  "a corporation of the Commonwealth of Massachusetts.  DIGITAL hereby grants",
  "to you a non-transferable, non-exclusive, royalty free worldwide license",
  "to use, copy, modify, prepare integrated and derivative works of and",
  "distribute SRC Modula-3 for non-commercial purposes, subject to your",
  "agreement to the following terms and conditions:",
  "",
  "  - The SRC Modula-3 Non-commercial License shall be included in the code",
  "    and must be retained in all copies of SRC Modula-3 (full or partial;",
  "    original, modified, derivative, or otherwise):",
  "",
  "  - You acquire no ownership right, title, or interest in SRC Modula-3",
  "    except as provided herein.",
  "",
  "  - You agree to make available to DIGITAL all improvements,",
  "    enhancements, extensions, and modifications to SRC Modula-3 which",
  "    are made by you or your sublicensees and distributed to others and",
  "    hereby grant to DIGITAL an irrevocable, fully paid, worldwide, and",
  "    non-exclusive license under your intellectual property rights,",
  "    including patent and copyright, to use and sublicense, without",
  "  limititation, these modifications.",
  "",
  "  - SRC Modula-3 is a research work which is provided 'as is',",
  "    and  DIGITAL disclaims all warranties",
  "    with regard to this software, including all implied warranties of",
  "    merchantability and fitness of purpose.  In no event shall DIGITAL be",
  "    liable for any special, direct, indirect, or consequential damages or",
  "    any damages whatsoever resulting from loss of use, data or profits,",
  "    whether in an action of contract, negligence or other tortious action,",
  "    arising out of or in connection with the use or performance of this",
  "    software. ",
  "",
  "",
  "              Copyright (C) 1990 Digital Equipment Corporation",
  "                       All Rights Reserved"
   };

(*-------------------------------- program startup/shutdown -----------------*)

PROCEDURE Run () =
  BEGIN
    RTSignal.InstallHandlers ();
    RTParams.Init ();
    RTLoader.Init ();
    RTType.Init ();
    FOR i := 0 TO RT0u.nModules - 1 DO  RT0u.modules[i].init () END;
    RTMisc.Exit (0);

    EVAL RTHeap.Allocate;
    (* an attempt to force the allocator to be initialized early *)
  END Run;

(*-------------------------------- global "map" procedure -------------------*)

PROCEDURE GlobalMapProc (p    : RT0.VisitProc;
                         arg  : REFANY;
                         mask : RT0.RefTypeSet) =
  VAR m: RT0.ModuleMapProc;
  BEGIN
    FOR i := 0 TO RT0u.nModules - 1 DO
      m := RT0u.modules[i].map;
      IF (m # NIL) THEN m (p, arg, mask) END;
    END;
  END GlobalMapProc;

BEGIN
END RTMain.

