(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Created by stolfi on Wed Aug 31 01:25:18 1988               *)
(* Last modified on Tue Jun  2 13:45:45 PDT 1992 by stolfi     *)
(*      modified on Tue Feb 11 21:39:47 PST 1992 by muller     *)


INTERFACE IntRGB;

(* Color values represented as fixed-point RGB triples.

  This interface defines a representation of color values as RGB triples
  with 10-bit fixed-point coordinates (in a linear scale) plus a
  "defined" bit.  They are used internally by the color map management
  routines.  Clients should normally use the floating-point RGB
  interface instead.

  Index: colors; graphics, colors; display, color; Trestle; VBT.

  *)

IMPORT RGB;

TYPE
  Intensity = BITS 10 FOR [0..1023];

  T = RECORD
        filler: BITS 1 FOR [0..1] := 0;
        defined: BITS 1 FOR BOOLEAN;
        r: Intensity;
        g: Intensity;
        b: Intensity;
    END;

CONST Undefined = T{defined := FALSE, r := 0, b := 0, g := 0};

CONST Default = Undefined;

PROCEDURE FromReal (r: REAL): Intensity;
  (* 
    Converts a floating point number to integer, by clipping to
    [0.0 _ 1.0], scaling to [0 .. 1023], and rounding. *)

PROCEDURE ToReal (i: Intensity): REAL;
  (* 
    Converts an integer intensity in [0..1023] to floating point and
    scales it to [0.0 _ 1.0]. *)

PROCEDURE FromRGB (rgb: RGB.T): T;
PROCEDURE ToRGB (irgb: T): RGB.T;
  (* 
    Convert between integer and floating-point RGB values
    by applying FromReal or ToReal to each coordinate. *)

PROCEDURE New (val: T := Undefined): REF T;
  (* 
    same as NEW(r); r^ := val; RETURN r *)

PROCEDURE NewArray (size: CARDINAL; val: T := Undefined): REF ARRAY OF T;
  (* 
    Returns an array of given size filled with the given value *)

TYPE 
  Byte = BITS 8 FOR [0..255];
  Bytes = ARRAY [0..BYTESIZE(T)-1] OF Byte;

PROCEDURE ToBytes(x: T): Bytes;
(* A safe LOOPHOLE of /x/ into ARRAY OF BYTE. *)

END IntRGB.

