(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Created by meehan on Fri Aug 14 22:09:04 PDT 1992                         *)
(* Last modified on Fri Aug 14 23:02:21 PDT 1992 by meehan                   *)


INTERFACE ColorNameF;

IMPORT ColorName, RGB, TxtIntTbl, TxtRefTbl;

VAR table: TxtIntTbl.T;
(* Maps NormalizeName(name) to index into Basic.  Used for name -> color. *)

TYPE Cache = MUTEX OBJECT table: TxtRefTbl.T END;

VAR nameCache: Cache;
(* cache of normalized names that have been looked up: *)
  
PROCEDURE NormalizeName (a: TEXT): TEXT;
(* Deletes all whitespace in "a" and converts to lower case *)

TYPE NotInTable = PROCEDURE (name: TEXT): RGB.T RAISES {ColorName.NotFound};

PROCEDURE LowerCaseToRGB (name: TEXT; p: NotInTable): RGB.T
  RAISES {ColorName.NotFound};

END ColorNameF.
