(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: M3LinkMap.i3                                          *)
(* Last Modified On Wed Dec  4 16:00:23 PST 1991 By kalsow     *)

INTERFACE M3LinkMap;

IMPORT M3Linker;

TYPE T     <: REFANY;
TYPE Key   =  M3Linker.Name;
TYPE Value =  REFANY;
(* NOTE: the first field of every Value must be a Key *)

PROCEDURE New (initalSize: CARDINAL): T;
(* builds, initializes and returns a new empty map *)

PROCEDURE Get (t: T;  READONLY k: Key): Value;
(* returns the element of t with key value k, NIL if no such element *)

CONST MISSING = -1;
PROCEDURE GetIndex (t: T;  READONLY k: Key): INTEGER;
(* returns the index of the element of t with key value k,
   MISSING if no such element *)

PROCEDURE GetDirect (t: T;  index: INTEGER): Value;
(* returns the value of the element in t in slot index. *)

PROCEDURE Insert (t: T;  READONLY k: Key;  v: Value);
(* inserts (k, v) into t. *)

PROCEDURE GetData (t: T): REF ARRAY OF Value;
(* returns the internal hash table *)

(***************
PROCEDURE Copy (t: T): T;
(* returns a new copy of t which contains the same elements *)
***************)

END M3LinkMap.

