(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Scanner.i3                                            *)
(* Last modified on Wed Apr 15 09:28:11 PDT 1992 by kalsow     *)

INTERFACE Scanner;

IMPORT Token, Rd, String, M3;

TYPE
  Symbol = RECORD
    token  : Token.T;
    string : String.T;
    value  : INTEGER;
    offset : INTEGER;
    defn   : M3.Value;
  END;

VAR
  cur     : Symbol; (* READONLY *)
  offset  : INTEGER;
  nLines  : INTEGER := 0; (* READONLY *)
  nPushed : INTEGER := 0; (* READONLY *)

PROCEDURE Match  (t: Token.T;  READONLY a, b: Token.Set);
PROCEDURE Match1 (t: Token.T;  READONLY a: Token.Set);

PROCEDURE MatchID  (READONLY a, b: Token.Set): String.T;
PROCEDURE MatchID1 (READONLY a: Token.Set): String.T;

PROCEDURE GetToken ();

PROCEDURE Fail (msg: TEXT;  READONLY stop: Token.Set);

PROCEDURE NoteReserved (name: String.T;  value: M3.Value);

PROCEDURE Here (VAR file: String.T;  VAR line: INTEGER);
PROCEDURE LocalHere (VAR file: String.T;  VAR line: INTEGER);

PROCEDURE Push (name: String.T;  file: Rd.T);
PROCEDURE Pop ();

PROCEDURE Initialize ();
PROCEDURE Reset ();

END Scanner.
