(*^
*)
 
RadiographApertureTrajectory[r0_, offset_, t0_, translation_, steps_:16] := 
Module[{theta}, 
	Table[ 
		N[ 
			{ 
				r0 offset^(theta / (2 Pi)) Sin[theta], 
			 	r0 offset^(theta / (2 Pi)) Cos[theta], 
			       -t0 translation^(theta / (2 Pi)) 
			} 
		], 
		{theta, 0, 2Pi, 2 Pi / steps} 
	] 
] 
  


(*


^*)