
SphereTriples::usage = "SphereTriples[{u0, u1, du}, {v0, v1, dv}] gives a list 
of triples that are on parts of great circles on the sphere through the north 
and south poles between the angles u0 and u1 with a spacing of du. The parts 
are delimited by the latitudes at the angles v0 and v1 with a spacing of dv."

( SphereTriples[{u0_, u1_, du_}, {v0_, v1_, dv_}] := Module[
	{u, v}, 
	Table[
		{
			Cos[2 N[Pi] u] Sin[N[Pi] v], 
			Sin[2 N[Pi] u] Sin[N[Pi] v], 
			Cos[N[Pi] v]
		},
		{u, u0, u1, du}, {v, v0, v1, dv}
	] 
] )

(* The following seems more elegant but must be slower:

( SphereTriples[{u0_, u1_, du_}, {v0_, v1_, dv_}] := 
	ToSphere @ GridTriples[{u0, u1, du}, {v0, v1, dv}] ) *)

