
Meet::usage = "Meet[a, b], where a and b are lines or circles, gives the 
intersection of a and b."

( MeetAux1[
	Line @ {{p1_, p2_, 0.}, {q1_, q2_, 0.}}, 
	Line @ {{r1_, r2_, 0.}, {s1_, s2_, 0.}}] := 
		(q2 - p2) (r1 - s1) - (q1 - p1) (r2 - s2) )

( MeetAux2[
	Line @ {{p1_, p2_, 0.}, {q1_, q2_, 0.}}, 
	Line @ {{r1_, r2_, 0.}, {s1_, s2_, 0.}}] := 
		(r2 - s2) (p1 - s1) - (r1 - s1) (p2 - s2) )

( Meet[l:Line @ {p_, q_}, m_Line] := 
	p + MeetAux2[l, m] / MeetAux1[l, m] (q - p) 
	/; Chop @ MeetAux1[l, m] != 0 )

( Meet[l:Line @ {p_, q_}, Circle[d_, r_]] := Block[
	{a, b, c, e, t1, t2}, 
	a = (q - p) . (q - p); 
	b = - 2 (d - p) . (q - p); 
	c = (d - p) . (d - p) - r ^ 2; 
	e = N @ Sqrt[b ^ 2 - 4 a c]; 
	t1 = (- b + e) / (2 a); 
	t2 = (- b - e) / (2 a); 
	{p + (q - p) t1, p + (q - p) t2} ]
	/; Distance[d, l] <= r )

Meet[u_Circle, l_Line] := Meet[l, u]

( Meet[u:Circle[c_, r_], v:Circle[d_, s_]] := Block[
	{w, a, b, m}, 
	w = Circle[c + r $i, 1];
	m = Invert[w] @ Meet[Invert[w] @ u, Invert[w] @ v];
	If[Distance[c + r $i, d] == s, {c + r $i, m}, m] 
] /; Abs[r - s] <= Distance[c, d] <= r + s 
)

