#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************



CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine WinVew (term)


*************************************************************
*                                                           *
*  Subroutine  Window                                       *
*                                                           *
*     This subroutine is used to ask the user to enter      *
*     the window in world coordinates.  A minor amount      *
*     of error checking is performed, mainly to make sure   *
*     the user enters the coordinates in increasing order.  *
*                                                           *
*************************************************************


        Real          Xmax, Xmin, Ymax, Ymin
        Common /data/ Xmax, Xmin, Ymax, Ymin
        Save   /data/

        Real           WXmax, WXmin, WYmax, WYmin
        Common /windw/ WXmax, WXmin, WYmax, WYmin
        Save   /windw/

        Character *10   hix, hiy, lowx, lowy
        Common /winlbl/ hix, hiy, lowx, lowy
        Save   /winlbl/

        Character ans
        Integer term

 
*       (* If the window's max & min points don't match the
*          curve's max & min points, found in 'datain'. Prompt 
*          the user if they wish to reset them as such. *)
        IF (WXmax.NE.Xmax .OR. WXmin.NE.Xmin .OR. WYmax.NE.Ymax .OR.
     +      WYmin.NE.Ymin) THEN
    1     Call clear(term)
          Write (*,10)
   10     Format (//,5x,'Do you wish to reset the window to the',/
     +              ,5x,'max and min plotting points? (Y/N)... ')
          Read (*,'(a1)',err=1) ans
          IF (ans .EQ. 'Y' .OR. ans .EQ. 'y') THEN
            WXmax = Xmax
            WXmin = Xmin
            WYmax = Ymax
            WYmin = Ymin
            Call number (WXmin, .FALSE., lowx)
            Call number (WXmax, .TRUE., hix)
            Call number (WYmin, .TRUE., lowy)
            Call number (WYmax, .TRUE., hiy)
          ELSE
*           (* Else call "window")
            Call Window (term)
          ENDIF
        ELSE
          Call Window (term)
        ENDIF
   
        RETURN
        END
