Unit ComExec; {Executes Commands}

INTERFACE

Procedure DrawTurtle(x,y:Real; Angle,Colour:integer; TurtleOn:Boolean);
Procedure WipeTurtle(x,y:Real; Angle,Colour:integer; TurtleOn:Boolean);
Procedure FWD(Distance:Integer; Var x,y:Real; Angle,Colour:Integer;
                                Pendown,TurtleOn:Boolean);
Procedure Back(Distance:Integer; Var x,y:Real; Angle,Colour:Integer;
                                 Pendown,TurtleOn:Boolean);
Procedure Right(degrees:integer; x,y:Real; Var Angle,Colour:Integer;
                TurtleOn:Boolean);
Procedure Left(degrees:integer; x,y:Real; Var Angle,Colour:Integer;
               TurtleOn:Boolean);

IMPLEMENTATION

Uses Graph,Deg2rad;

{-----------------------------------------------------------------------}
Procedure DrawTurtle(x,y:Real; Angle,Colour:Integer; TurtleOn:Boolean);
          {Used for displaying the Turtle on Screen}

Var x1,y1,x2,y2,x3,y3:Integer;

Begin
if TurtleOn=True then Begin
SetColor(Green);
Setwritemode(XorPut);
x1:=Round(x + (12*Sine(Angle-135)) );      {    }
y1:=Round(y - (12*Cosine(Angle-135)) );    {    }
x2:=Round(x + (12*Sine(Angle+135)) );      {    }
y2:=Round(y - (12*Cosine(Angle+135)) );    {    }
x3:=Round(x + (15*Sine(Angle)) );          {P1x}  {Verified:=""}
y3:=Round(y - (15*Cosine(Angle)) );        {P1y}
SetViewPort(1,1,449,369,True);
Moveto(Round(x-1),Round(y-1));
Lineto(x1-1,y1-1); Lineto(x3-1,y3-1);
Lineto (x2-1,y2-1); Lineto(Round(x-1),Round(y-1));
SetViewPort(0,0,639,479,True);
Setwritemode(Normalput);
End;
SetColor(Colour);
End;

Procedure WipeTurtle(x,y:Real; Angle,Colour:Integer; TurtleOn:Boolean);
Begin
DrawTurtle(x,y,Angle,Colour,TurtleOn);
end;

{-----------------------------------------------------------------------}
Procedure FWD(Distance:Integer; Var x,y:Real; Angle,Colour:Integer;
                                Pendown:Boolean; TurtleOn:Boolean);
          {Moves Turtle Forward or Backwards and draws a line if neccesary}

Var Ox,Oy:Integer;

Begin
Ox:=Round(x); Oy:=Round(y);
WipeTurtle(x,y,Angle,Colour,TurtleOn);
x:=x+(Distance*Sine(Angle));
y:=y-(Distance*Cosine(Angle));
If Pendown then Begin
                SetViewPort(1,1,449,369,True);
                Line(Ox-1,Oy-1,Round(x)-1,Round(y)-1);
                SetViewPort(0,0,639,479,True);
                end;
DrawTurtle(x,y,Angle,Colour,TurtleOn);
end;

{-----------------------------------------------------------------------}

Procedure Back(Distance:Integer; Var x,y:Real; Angle,Colour:Integer;
                                 Pendown:Boolean; TurtleOn:Boolean);
Begin
Distance:=-Distance;
FWD(Distance,x,y,Angle,Colour,Pendown,TurtleOn);
end;

{-----------------------------------------------------------------------}
Procedure Left(degrees:Integer; x,y:Real; Var Angle,Colour:Integer;
               TurtleOn:Boolean);
          {Rotates Turtle by the given value in degrees}

Var Done:Boolean;

Begin
WipeTurtle(x,y,Angle,Colour,TurtleOn);
Angle:=Angle-Degrees;
If Angle<0 then Angle:=(Angle Mod 360)+360;
If Angle>359 then Angle:=Angle Mod 360;
DrawTurtle(x,y,Angle,Colour,TurtleOn);
End;

{-----------------------------------------------------------------------}

Procedure Right(degrees:Integer; x,y:Real; Var Angle,Colour:Integer;
                TurtleOn:Boolean);
Begin
Degrees:=-Degrees;
Left(degrees,x,y,Angle,Colour,TurtleOn);
end;

{-----------------------------------------------------------------------}

End.