#include	<ctype.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	"wpls2rtf.h"


/* I know, some of these array sizes are *very* arbitrary	*/

uchar	extension[16];
uchar	pre[10][256];
uchar	post[64];
uchar	para[32];
uchar	styles[6][16];
uchar	block[2][16];
uchar	footnote[256];
uchar	endnote[256];
uchar	table[256][16];

uchar	errStr[256];

#define	output(a,b)	fprintf(a,"%s",b)
#define Max(a,b)	(a > b ? a : b)
#define Min(a,b)	(a < b ? a : b)

#if defined(__MACOS__) || (defined(__INTEL__) && defined(__MWERKS__))
	int	strcasecmp(uchar *a, uchar *b) {
		char	s1[512], s2[512];
		int i;
		for(i=0; a[i]; i++) {
			s1[i] = tolower(a[i]);
		}
		s1[i] = 0;
		for(i=0; b[i]; i++) {
			s2[i] = tolower(b[i]);
		}
		s2[i] = 0;
		return(strcmp(s1,s2));
	}
	int	strncasecmp(uchar *a, uchar *b, int n) {
		char	s1[512], s2[512];
		int i;
		for(i=0; a[i]; i++) {
			s1[i] = tolower(a[i]);
		}
		s1[i] = 0;
		for(i=0; b[i]; i++) {
			s2[i] = tolower(b[i]);
		}
		s2[i] = 0;
		return(strncmp(s1,s2,n));
	}
	#ifndef TOOL	/* Not as an MWP tool	*/
		void macwarn(uchar *m) {
			int	i;

			for(i=1; i<256 && m[i]; i++)
				if(m[i] == '\n') m[i] = '\r';
			if((m[0] = (uchar)i-1) != 0) {
				ParamText(m, NULL, NULL, NULL);
			/*	CenterAlert(200);	/*	JS -- there'a some bug	*/
				StopAlert(200,NULL);
		}	}
		void SetFileInfo(uchar *file) {
			uchar	myFile[256];
			FSSpec	myFSS;
			FInfo	myFInfo;
			int i;
			
			i = strlen(file);
			if (i>256) return;
			myFile[0] = i;
			strcpy(&myFile[1],file);
			FSMakeFSSpec(0, 0, myFile, &myFSS);
			FSpGetFInfo(&myFSS, &myFInfo);
			myFInfo.fdType = 'TEXT'	/*	0x54455854L	*/;
			myFInfo.fdCreator ='MSWD'	/*	0x4d535744L	*/;
			FSpSetFInfo(&myFSS, &myFInfo);
		}	
	#endif	/*	TOOL	*/
#endif	/*	__MACOS__ || (__INTEL__	&& __MWERKS__) */


/*	It just might be needed, sometimes...
void dump(void)
{
	int i;

	for(i=0; i < 10; i++)
		fprintf(stdout, "pre[%i]: %s\n", i, pre[i]);
	fprintf(stdout, "post: %s\n", post);
	fprintf(stdout, "para: %s\n", para);
	for(i=0; i < 6; i++)
		fprintf(stdout, "styles[%i]: %s\n", i, styles[i]);
	for(i=0; i < 2; i++)
		fprintf(stdout, "block[%i]: %s\n", i, block[i]);
	fprintf(stdout, "footnote: %s\n", footnote);
	fprintf(stdout, "endnote: %s\n", endnote);
	for(i=0; i < 256; i++)
		fprintf(stdout, "table[%i]: %s\n", i, table[i]);
}
*/

uchar	_PrgName[256];	/*	ST: startup code fills in (full) progname	*/

#if !defined(__MACOS__) || defined(TOOL)
void usage(uchar *prg)
{
	static int	stage = 0;
	if(!stage++) warn("Usage: %s [-t translator] [-u] [-v] file1 ...\n",prg,NULL,NULL);
}

void version(uchar *prg)
{
	static int	stage = 0;
	if(!stage++) warn("%s (v%s, %s)\n",prg,VERSION,__DATE__);
}

int main(int argc, uchar *argv[])
{
	int	file, Default = TRUE;
	uchar	*ProgName;		/*	Pointer to filename only (without path)	*/
	uchar	*ptr;
	uchar	TranslateFile[256];

#ifndef __TOS__
	strcpy(_PrgName,argv[0]);
#endif
	if(_PrgName[0]) {
		ProgName = strrchr(_PrgName,DIRSEP);
		if(ProgName == NULL) {
			ProgName = _PrgName;
		} else {
			ProgName++;
		}
		/*	Strip extension from program name	*/
		if((ptr = strrchr(ProgName,'.')) != NULL) *ptr = 0;
	} else {
		strcpy(_PrgName,"wpls2rtf");
		ProgName = _PrgName;
	}
	strcpy(TranslateFile,_PrgName);
	strcat(TranslateFile,".x");
	for(file = 1; (file < argc) && (argv[file][0] == '-'); file++) {
		switch(argv[file][1]) {
			case 't':	if(file >= (argc-1)) {
							usage(ProgName);
							return(1);
						}
						strcpy(TranslateFile,argv[++file]);
						Default = FALSE;
						break;
			case 'v':	version(ProgName);
						break;
			case 'u':	usage(ProgName);
						break;
			default:	usage(ProgName);
						return(1);
	}	}
	if(file >= argc) {
		usage(ProgName);
		return(1);
	}
	if(!init_table(TranslateFile, Default))
		return(1);
	for(;file < argc; file++)
		translate(argv[file], FALSE);
	return(0);
}
#endif

int	hex2num(uchar digit)
{
	digit = toupper(digit);
	if(digit >= '0'  && digit <= '9') return(digit - '0');
	if(digit >= 'A'  && digit <= 'F') return(digit - 'A' + 10);
	return(0);
}

int init_table(uchar *file, int Default)
{
	FILE	*in;
	int 	i, c=0;
	uchar	buf[1024]; uchar *ptr;

	/*	First, determine extension from translation filename
		A maximum of three characters is taken, in the following way:
			- point to the '.' in the filename - if none, start at the end;
			- search for a '2' in the filename
				- if found, use max. 3 chars from that '2' onwards;
				- otherwise, use max. 3 chars from the '.' backwards.
	*/

	for(i = 0; i<10; i++) pre[i][0] = 0;
	post[0] = para[0] = footnote[0] = endnote[0] = 0;
	for(i = 0; i<6; i++) styles[i][0] = 0;
	for(i = 0; i<2; i++) block[i][0] = 0;
	for(i = 0; i<32; i++)
		table[i][0] = 0;
	for(; i<256; i++) {
		table[i][0] = i;
		table[i][1] = 0;
	}
	table[30][0] = 32;
	in = fopen(file,"rb");
	if(in != NULL) {
		while(c!=EOF) {
			for(i=0;i<1024;i++) buf[i]=0;
			for(i=0, c=getc(in); c!='\x0D'&&c!='\x0A'&&c!=EOF &&i<1024;i++, c=getc(in))
				buf[i]=c;
			while(c=='\x0D'||c=='\x0A') c=getc(in);
			if(c!=EOF) ungetc(c,in);
			if(buf[0] == '$') {
				i = (16*hex2num(buf[1])) + hex2num(buf[2]);
				strcpy(table[i], &buf[4]);
			}
			else {
				if(eqn(".ext",buf,4))
					strcpy(extension,&buf[5]);
				if(eqn("init",buf,4))
					strcpy(pre[buf[4]-'0'],&buf[6]);
				if(eqn("exit",buf,4))
					strcpy(post,&buf[5]);
				if(eqn("paragraph",buf,9))
					strcpy(para,&buf[10]);
				if(eqn("blockstart",buf,10))
					strcpy(block[BLOCKSTART],&buf[11]);
				if(eqn("blockend",buf,8))
					strcpy(block[BLOCKEND],&buf[9]);
				if(eqn("bold",buf,4))
					strcpy(styles[BOLD],&buf[5]);
				if(eqn("light",buf,5))
					strcpy(styles[LIGHT],&buf[6]);
				if(eqn("italic",buf,6))
					strcpy(styles[ITALIC],&buf[7]);
				if(eqn("underlined",buf,10))
					strcpy(styles[UNDERLINE],&buf[11]);
				if(eqn("super",buf,5))
					strcpy(styles[SUPERSCRIPT],&buf[6]);
				if(eqn("sub",buf,3))
					strcpy(styles[SUBSCRIPT],&buf[4]);
				if(eqn("footnote",buf,8))
					strcpy(footnote,&buf[9]);
				if(eqn("endnote",buf,7))
					strcpy(endnote,&buf[8]);
		}	}
		fclose(in);
	} else {
		if(!Default) {
			warn("Could not open translation file\n\t\"%s\"\nfor reading.\n",file,NULL,NULL);
			return(FALSE);
		}
		strcpy(extension, ".rtf");
		strcpy(pre[0], "{\\rtf1\\mac\\deff2\\ {\\fonttbl");
		strcpy(pre[1], "{\\f0\\fswiss Chicago;}{\\f3\\fswiss Geneva;}{\\f4\\fmodern Monaco;}{\\f13\\fnil Zapf Dingbats;}");
		strcpy(pre[2], "{\\f16\\fnil Palatino;}{\\f20\\froman Times;}{\\f21\\fswiss Helvetica;}{\\f23\\ftech Symbol;}");
		strcpy(pre[3], "{\\f33\\fnil Avant Garde;}{\\f34\\fnil New Century Schlbk;}}");
		strcpy(pre[4], "{\\stylesheet{ \\s243\\qj\\tqc\\tx4320\\tqr\\tx8640 \\f34\\sbasedon0\\snext243 footer;}");
		strcpy(pre[5], "{\\s245\\qj \\f34\\fs18\\up6 \\sbasedon0\\snext0 footnote reference;}");
		strcpy(pre[6], "{\\s246\\qj \\f34\\fs20 \\sbasedon0\\snext246 footnote text;}");
		strcpy(pre[7], "{\\s254\\qj\\sb120 \\b\\f34 \\sbasedon0\\snext0 heading 2;}");
		strcpy(pre[8], "{\\s255\\qj\\sb240 \\b\\f34\\ul \\sbasedon0\\snext0 heading 1;}");
		strcpy(pre[9], "{\\qj \\f34 \\sbasedon222\\snext0 Normal;}}\\pard\\plain \\qj \\f34 ");
		strcpy(post,"}");
		strcpy(para,"\\par");
		strcpy(block[BLOCKSTART],"{");
		strcpy(block[BLOCKEND],"}");
		strcpy(styles[BOLD],"\\b ");
		strcpy(styles[LIGHT],"\\outl ");
		strcpy(styles[ITALIC],"\\i ");
		strcpy(styles[UNDERLINE],"\\ul ");
		strcpy(styles[SUPERSCRIPT],"\\fs18\\up6 ");
		strcpy(styles[SUBSCRIPT],"\\fs18\\dn6 ");
		strcpy(footnote,"{\\fs18\\up6\\chftn{\\footnote\\pard\\plain\\s246\\qj\\f34\\fs20{\\fs18\\up6\\chftn}");
		strcpy(endnote,"}}");
		strcpy(table[0x08],"\\'c3"); strcpy(table[0x09],"\\tab ");
		strcpy(table[0x0C],"\\page ");
		strcpy(table[0x19],"\\-");
/* 		strcpy(table[0x1D],"\\tab "); strcpy(table[0x1E]," "); */
		strcpy(table[0x1D],""); strcpy(table[0x1E]," ");
		strcpy(table[0x20],"\\~");
		strcpy(table[0x5C],"\\\\");
		strcpy(table[0x7B],"\\{");
		strcpy(table[0x7D],"\\}");
		strcpy(table[0x7F],"\\'c6");
		strcpy(table[0x80],"\\'82"); strcpy(table[0x81],"\\'9f");
		strcpy(table[0x82],"\\'8e"); strcpy(table[0x83],"\\'89");
		strcpy(table[0x84],"\\'8a"); strcpy(table[0x85],"\\'88");
		strcpy(table[0x86],"\\'8c"); strcpy(table[0x87],"\\'8d");
		strcpy(table[0x88],"\\'90"); strcpy(table[0x89],"\\'91");
		strcpy(table[0x8A],"\\'8f"); strcpy(table[0x8B],"\\'95");
		strcpy(table[0x8C],"\\'94"); strcpy(table[0x8D],"\\'93");
		strcpy(table[0x8E],"\\'80"); strcpy(table[0x8F],"\\'81");
		strcpy(table[0x90],"\\'83"); strcpy(table[0x91],"\\'be");
		strcpy(table[0x92],"\\'ae"); strcpy(table[0x93],"\\'99");
		strcpy(table[0x94],"\\'9a"); strcpy(table[0x95],"\\'98");
		strcpy(table[0x96],"\\'9e"); strcpy(table[0x97],"\\'9d");
		strcpy(table[0x98],"\\'d8"); strcpy(table[0x99],"\\'85");
		strcpy(table[0x9A],"\\'86"); strcpy(table[0x9B],"\\'a2");
		strcpy(table[0x9C],"\\'a3"); strcpy(table[0x9D],"\\'b4");
		strcpy(table[0x9E],"\\'a7"); strcpy(table[0x9F],"\\'c4");
		strcpy(table[0xA0],"\\'87"); strcpy(table[0xA1],"\\'92");
		strcpy(table[0xA2],"\\'97"); strcpy(table[0xA3],"\\'9c");
		strcpy(table[0xA4],"\\'96"); strcpy(table[0xA5],"\\'84");
		strcpy(table[0xA6],""); strcpy(table[0xA7],"\\'bc");
		strcpy(table[0xA8],"\\'c0"); strcpy(table[0xA9],"");
		strcpy(table[0xAA],"\\'c2"); strcpy(table[0xAB],"\\|F(1,2)");
		strcpy(table[0xAC],"\\|F(1,4)"); strcpy(table[0xAD],"\\'c1");
		strcpy(table[0xAE],"\\'c7"); strcpy(table[0xAF],"\\'c8");
		strcpy(table[0xB0],"\\'8b"); strcpy(table[0xB1],"\\'9b");
		strcpy(table[0xB2],"\\'af"); strcpy(table[0xB3],"\\'bf");
		strcpy(table[0xB4],"\\'cf"); strcpy(table[0xB5],"\\'ce");
		strcpy(table[0xB6],"\\'cb"); strcpy(table[0xB7],"\\'cc");
		strcpy(table[0xB8],"\\'cd"); strcpy(table[0xB9],"\\'ac");
		strcpy(table[0xBA],"`"); strcpy(table[0xBB],"\\'a0");
		strcpy(table[0xBC],"\\'a6"); strcpy(table[0xBD],"\\'a9");
		strcpy(table[0xBE],"\\'a8"); strcpy(table[0xBF],"\\'aa");
		strcpy(table[0xC0],"ij"); strcpy(table[0xC1],"IJ");
		strcpy(table[0xC2],""); strcpy(table[0xC3],"");
		strcpy(table[0xC4],""); strcpy(table[0xC5],"");
		strcpy(table[0xC6],""); strcpy(table[0xC7],"");
		strcpy(table[0xC8],""); strcpy(table[0xC9],"");
		strcpy(table[0xCA],""); strcpy(table[0xCB],"");
		strcpy(table[0xCC],""); strcpy(table[0xCD],"");
		strcpy(table[0xCE],""); strcpy(table[0xCF],"");
		strcpy(table[0xD0],""); strcpy(table[0xD1],"");
		strcpy(table[0xD2],""); strcpy(table[0xD3],"");
		strcpy(table[0xD4],""); strcpy(table[0xD5],"");
		strcpy(table[0xD6],""); strcpy(table[0xD7],"");
		strcpy(table[0xD8],""); strcpy(table[0xD9],"");
		strcpy(table[0xDA],""); strcpy(table[0xDB],"");
		strcpy(table[0xDC],""); strcpy(table[0xDD],"\\'a4");
		strcpy(table[0xDE],"{\\dn6 ^}"); strcpy(table[0xDF],"\\'b0");
		strcpy(table[0xE0],""); strcpy(table[0xE1],"\\'a7");
		strcpy(table[0xE2],""); strcpy(table[0xE3],"\\'b9");
		strcpy(table[0xE4],"\\'b7"); strcpy(table[0xE5],"");
		strcpy(table[0xE6],"\\'b5"); strcpy(table[0xE7],"");
		strcpy(table[0xE8],""); strcpy(table[0xE9],"");
		strcpy(table[0xEA],"\\'bd"); strcpy(table[0xEB],"\\'b6");
		strcpy(table[0xEC],""); strcpy(table[0xED],"");
		strcpy(table[0xEE],""); strcpy(table[0xEF],"");
		strcpy(table[0xF0],""); strcpy(table[0xF1],"\\'b1");
		strcpy(table[0xF2],"\\'b3"); strcpy(table[0xF3],"\\'b2");
		strcpy(table[0xF4],""); strcpy(table[0xF5],"");
		strcpy(table[0xF6],""); strcpy(table[0xF7],"\\'c5");
		strcpy(table[0xF8],"\\'a1"); strcpy(table[0xF9],"\\'a5");
		strcpy(table[0xFA],"\\'a5"); strcpy(table[0xFB],"\\'c3");
		strcpy(table[0xFC],""); strcpy(table[0xFD],"");
		strcpy(table[0xFE],""); strcpy(table[0xFF],"");
	}
	if(!extension[0]) {
		ptr = strrchr(file,DIRSEP);
		if(ptr == NULL)
			ptr = file;
		strcpy(buf,ptr);
		ptr = strrchr(buf,'.');
		if(ptr != NULL)
			*ptr = 0;
		i = (int) strlen(buf);
		ptr = strrchr(buf,'2');
		if(ptr == NULL)	/*	Take at most 3 from the end	*/
			ptr = &buf[i - Min(i,3)];
		else
			ptr++;
		extension[0] = '.';
		ptr[Min(strlen(ptr),3)] = 0;
		strcpy(&extension[1],ptr);
		if (extension[1] == 0)
			strcpy(&extension[1],"tra");
	}
	return(TRUE);
}

void translate(uchar *filename, int bulk)
{
	FILE	*in, *out;
	uchar	outfile[256], *ptr, *buffer, tmp[32], style;
	long	filesize, current = 0L;
	int		fnum, level=0, flevel, soft, i;

	strcpy(outfile,filename);
	/* Only search for '.' in the filename (not entire path)	*/
	((ptr = strrchr(outfile, DIRSEP)) ==  NULL) ? ptr = outfile: ptr++;
	if((ptr = strrchr(ptr, '.')) != NULL) {
		if(eq(ptr,extension)) {
			if(!bulk)
				warn("In- and output must be named differently\n[%s].\n",outfile,NULL,NULL);
			return;
		}
		strcpy(ptr,extension);
	}
	else {
		strcat(outfile,extension);
	}
	in = fopen(filename,"rb");
	if(in == NULL) {
		warn("Error opening \n\t\"%s\"\nfor reading.\n",filename,NULL,NULL);
		return;
	}
	fseek(in, 0L, SEEK_END);
	filesize = ftell(in);
	fseek(in, 0L, SEEK_SET);
	buffer = malloc(filesize+1);
	if(buffer == NULL) {
		warn("Insufficient memory to read \n\t\"%s\"\n",filename,NULL,NULL);
		fclose(in);
		return;
	}
	if(fread(buffer,sizeof(uchar),filesize,in) != filesize) {
		warn("Error reading \"%s\".\n",filename,NULL,NULL);
		free(buffer);
		fclose(in);
		return;
	}
	if(buffer[0] != '\x1F' || buffer[1] != '0') {
		if(!bulk)
			warn("Not a valid 1st Word Plus file:\n\t\"%s\".\n",filename,NULL,NULL);
		free(buffer);
		fclose(in);
		return;
	}
	buffer[filesize] = 0;
	fclose(in);
	out = fopen(outfile,"wb");
	if(out == NULL) {
		warn("Error opening \"%s\" for writing.\n",outfile,NULL,NULL);
		free(buffer);
		return;
	}
#if defined(__MACOS__) &&!defined(TOOL)
	SetFileInfo(outfile);
#endif
	/* Everything loaded & opened, all set to go... */
	
	for(i = 0; i<=9; i++) {
		output(out, pre[i]);
	}
	while(current < filesize) {
		switch(buffer[current]) {
			case	'\0':
			case	'\1':	/* Used for erasing footnote text	*/
				break;
			case	'\x0A':	/*	Unix linebreak	*/
				if(	buffer[current-1] == '\x19' || buffer[current-1] == '\x1c'
				 ||	buffer[current-1] == '\x1d' || buffer[current-1] == '\x1e'
				 ||	buffer[current-1] == '-') {
				/*	Soft Break after
						soft hyphen/stretch space/indent space/soft space/hyphen
						0x19/0x1C/0x1D/0x1E/0x2D
				*/
					output(out,NEWLINE);
				}
				else {	/*	Real paragraph break	*/
					output(out,para);
					output(out,NEWLINE);
				}
				/*	Don't handle pathological line breaks twice	*/
				if(buffer[current+1] == '\x0D') current++;
				break;
			case	'\x0B':	/*	Conditional Page Break, next byte defines scope -- skip it	*/
				current++;
				break;
			case	'\x0D':	/*	Mac linebreak, or start of DOS linebreak	*/
				if(	buffer[current-1] == '\x19' || buffer[current-1] == '\x1c'
				 ||	buffer[current-1] == '\x1d' || buffer[current-1] == '\x1e'
				 ||	buffer[current-1] == '-') {
				/*	Soft Break after
						soft hyphen/stretch space/indent space/soft space/hyphen
						0x19/0x1C/0x1D/0x1E/0x2D
				*/
					output(out,NEWLINE);
				}
				else {	/*	Real paragraph break	*/
					output(out,para);
					output(out,NEWLINE);
				}
				/*	Don't handle DOS line breaks twice	*/
				if(buffer[current+1] == '\x0A') current++;
				break;
			case	'\x18':	/*	Footnote reference	*/
				/* Skip first two bytes (no. of lines in footnote)
				current++;
				i =  (buffer[current++] - '0') * 10;
				i += (buffer[current++] - '0');				*/
				current += 3;
				if(buffer[current++] != ',') {
					warn("Warning: illegal format in footnote in file \n\t\"%s\"\n(position %i).\n",
							filename,current,NULL);
				}
				fnum=0;
				while(buffer[current] != '\x18') {
					if(buffer[current] < '0' || buffer[current] > '9') {
						warn("Warning: illegal footnote number in file \n\t\"%s\"\n(position %i).\n",
								filename,current,NULL);
					} else {
						fnum *= 10;
						fnum += buffer[current] - '0';
					}
					current++;
				}
				output(out,footnote);
				sprintf(tmp,"\x1FN%03u:",fnum);
				/*	Now find footnote and insert it	*/
				ptr = strstr(&buffer[current], tmp);
				if(ptr == NULL) {
					warn("Warning: footnote text %i not found in file \n\t\"%s\"\n(position %i).\n",
							fnum,filename,current);
				} else {
					flevel = 0;
					/* Skip 0x1f 'N' ... \r\n line */
					while(*ptr != '\x0A') {
						*(ptr++) = '\1';
					}
					*(ptr++) = '\1';
					/*	Skip footnote style change	*/
					if(*ptr == '\x1B') {
						*(ptr++) = '\1';
						*(ptr++) = '\1';
					}
					/*	Footnotes end either by another footnote ("\x1FN...\r\n")
						or by the end-of-footnotes line ("\x1FE\r\n")	*/
					/*	Note that footnote space is erased (0-filled) when used	*/
					soft=0;
					while(*ptr != '\x1F') {
						switch(*ptr) {
							case	'\0':
							case	'\1':
								break;
							case	'\x0A':
								if(!soft) {
								/*	Real paragraph break?	*/
									for(i=0; *(ptr+i) && (*(ptr+i)=='\x0D'||*(ptr+i)=='\x0A');) i++;
									if(*(ptr+i) !='\x1F') output(out,para);
								}
								if(*(ptr+1) == '\x0D') *(ptr++) = '\1';
								break;
							case	'\x0B':	/*	Conditional Page Break, next byte defines scope -- skip it	*/
								*(ptr++) = '\1';
								break;
							case	'\x0D':
								if(!soft) {
								/*	Real paragraph break?	*/
									for(i=0; *(ptr+i) && (*(ptr+i)=='\x0D'||*(ptr+i)=='\x0A');) i++;
									if(*(ptr+i) !='\x1F') output(out,para);
								}
								if(*(ptr+1) == '\x0A') *(ptr++) = '\1';
								break;
							case	'\x18':	/*	Footnote reference - BOO!	*/
								break;
							case	'\x1B':
								*(ptr++) = '\1';
								style = *ptr;
								if(!VALID(style)) {
									warn("Warning: illegal style byte (%#x) in file \n\t\"%s\"\n(position %i) - ignored.\n",
										style,filename,current);
									break;
								};
								if(flevel) {	/*	Don't end blocks that weren't started	*/
									flevel--;
									output(out,block[BLOCKEND]);
								}
								if(STYLED(style)) {
									flevel++;
									output(out,block[BLOCKSTART]);
									for(i = BOLD; i <= SUBSCRIPT; i++) {
										if(style & BIT(i))
											output(out,styles[i]);
								}	}
								break;
							/*	Footnotes are *always* indented and stretched,
								so indent and stretch spaces should be ignored	*/
							case	'\x1C':	
							case	'\x1D':
									break;
							case	'\x1F':	/* Format line: skip!	*/
								while(*ptr != '\x0A') *(ptr++) = '\1';
								break;
							default:
								output(out,table[*ptr]);
								break;
						}
						soft = (*ptr=='\x19' || *ptr=='\x1c' || *ptr=='\x1d' || *ptr=='\x1e' || *ptr=='-');
						*(ptr++) = '\1';
					}
					/*	*ptr == '\x1F' now	*/
					switch(*(ptr+1)) {
						case 'N':	break;
						case 'E':	
						default:	while(*ptr != '\x0A') {
										*(ptr++) = '\1';
									}
									*ptr = '\1'; ptr++;
									break;
				}	}
				output(out,endnote);
				break;
			case	'\x1B':
				style = buffer[++current];
				if(!VALID(style)) {
					warn("Warning: illegal style byte (%#x) in file \n\t\"%s\"\n(position %i) - ignored.\n",
						style,filename,current);
					break;
				};
				if(level) {	/*	Don't end blocks that weren't started	*/
					level--;
					output(out,block[BLOCKEND]);
				}
				if(STYLED(style)) {
					level++;
					output(out,block[BLOCKSTART]);
					for(i = BOLD; i<= SUBSCRIPT; i++) {
						if(style & BIT(i))
							output(out,styles[i]);
				}	}
				break;
			case	'\x1F':	/* Format line: skip!	*/
				for(;current < filesize && buffer[current] != '\x0A';) current++;
				break;
			default:
				output(out,table[buffer[current]]);
				break;
		}
		current++;
	}
	output(out,post);
	output(out,NEWLINE);
	fclose(out);
	free(buffer);
}
