#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tos.h>

#include "nettrace.h"
static char str[200];
void (*nettrace)(register char *);

#define noDEBUGSTAT
#define noDEBUGAPP
#define noDEBUG

#define VERSION "1.31"

#define VBLCNT 0x454L
#define VBLLIST 0x456L

/*		UPDATELIST												    */
/*  27. 4.92	hw		fixed malloc problem (basepage switching)	*/
/*  27. 9.92	pm		fixed double SYN ACK reset    				*/
/*  15.10.92	pm		fixed double ACK, window management     	*/
/*  23.10.92	pm		fixed FIN, SYNREC, ack policy ...  	        */
/*  30.10.92	pm		added URGENT  	        					*/
/*  18. 2.93	pm		fixed abort problem if no packet free		*/
/*              pm      fixed freeing of packets					*/

#include "pktdrv.h"
#include "ip.h"
#include "arp.h"
#include "icmp.h"
#include "tcp.h"
#include "udp.h"
#include "netdb.h"
#include "cookie.h"
#include "inetcust.h"
#include "tuwtcp.h"
#include "gemhook.h"
#include "mbuf.h"

extern int net_link(void);

long linkin(void);
void (*myprog)();
long * vbl_hook;

#define MACHINECOOKIE	0x5f4d4348L		/* "_MCH" */
#define TRAP_1 			33				/* GEMDOS TRAP */
#define TRAP_5 			37				/* GEMDOS TRAP */
typedef long (*GEMDOSFUNC)(register char *);

#define TCPBASE (1)
#define UDPBASE (100)

char myid[] = {"@(#) TUW-TCP v"
				VERSION };

long GETIPADDR(register char *param);
long UDPOPEN(register char *param);
long UDPCLOSE(register char *param);
long UDPREAD(register char *param);
long UDPWRITE(register char *param);
long TCPOPEN(register char *param);
long TCPWRITE(register char *param);
long TCPREAD(register char *param);
long TCPCLOSE(register char *param);
long TCPABORT(register char *param);
long TCPSTATE(register char *param);

int tcp_upcall(int tcb,char *data,int len);
int udp_upcall(int tcb,char *data,int len);


INETCUST *custom = NULL;
char *tcp_buffers;
char *udp_buffers;

extern TCP_TCB *tcpcb_list;
extern UDP_CTL *udp_list;
extern PKTQUEUE	*ip_qrecv;
extern long arp_counts[];
extern long icmp_counts[];
extern long udp_counts[];
extern long tcp_counts[];

COOKIE *cookie;

INETSTAT inetstat;

int mode = 0;

#define STATMODE 7
#define MUXMODE 4

char linebuf[MAXNAME+16];


GEMDOSFUNC GEM_TAB[] = 
{					/* gemdos # */
	GETIPADDR,			/* 612 */
	UDPOPEN,			/* 620 */
	UDPCLOSE,			/* 621 */
	UDPREAD,			/* 622 */
	UDPWRITE,			/* 623 */
	TCPOPEN,			/* 630 */
	TCPWRITE,			/* 631 */
	TCPREAD,			/* 632 */
	TCPCLOSE,			/* 633 */
	TCPABORT,			/* 634 */
	TCPSTATE			/* 635 */
};


typedef struct 
{
	char *_Host;
	unsigned char *_IPAddr;
}getip;

#define Host   (((getip *)param)->_Host)
#define IPAddr (((getip *)param)->_IPAddr)

long GETIPADDR(register char *param)
{
register FILE *fp;
register char *p_ip;
register char *p_name;
register INADDR inaddr;

	if(!custom) return(-1);
	if(!Host)
	{			/* return own IP-Address */
		*(INADDR *)IPAddr = custom->inaddr;
		return(0);
	}
	fp = fopen(custom->hosts,"r");
	if(!fp) return(-1);
	while(fgets(linebuf,(int)sizeof(linebuf)-1,fp) != NULL)
	{
		if(linebuf[0] == '#') continue;
		p_ip = strtok(linebuf," \t");
		if(!p_ip) continue;
		inaddr = atoin(p_ip);
		if(!inaddr) continue;
		while((p_name = strtok(NULL," \t\n")) != NULL)
		{
			if(!Host[0])
			{
				if(inaddr == *(INADDR *)IPAddr)
				{
					strcpy(Host,p_name);
					fclose(fp);
					return(0);
				}
			}
			if(!strcmp(Host,p_name))
			{
				*(INADDR *)IPAddr = inaddr;
				fclose(fp);
				return(0);
			}
		}
	}
	fclose(fp);
	return(-1);
}
#undef Host
#undef IPAddr


typedef struct
{
	unsigned int	_port;
} udpo;

#define port	(((udpo *)param)->_port)

long UDPOPEN(register char *param)
{
register int ret;
	net_demux(FALSE,DEMUX);
	ret = udp_open(port,udp_upcall);
	if(ret < 0) return(ret);
	return((long)ret + UDPBASE);
}
#undef port



typedef struct
{
	unsigned int	_UDPID;
} udpc;

#define UDPID	(((udpc *)param)->_UDPID)

long UDPCLOSE(register char *param)
{
register int ret;
	ret = udp_close(UDPID-UDPBASE);
	net_demux(FALSE,DEMUX);
	if(ret < 0) return(ret);
	return(UDPID);
}
#undef UDPID



typedef struct
{
	unsigned int	_UDPID;
	char 			*_Buffer;
	DESTI			*_src;
} udpr;

#define UDPID	(((udpr *)param)->_UDPID)
#define Buffer	(((udpr *)param)->_Buffer)
#define src		(((udpr *)param)->_src)

long UDPREAD(register char *param)
{
long len;
UDP_CTL *p_udpctl;

	net_demux(FALSE,DEMUX);
	p_udpctl = udp_getctl(UDPID-UDPBASE);
	if(!p_udpctl) return(-1);
	if(p_udpctl->udp_err == UDP_NORECV) return(-1);
	if(!p_udpctl->data_len || !p_udpctl->data) return(0);
	len = (long)p_udpctl->data_len;
	memcpy(Buffer,p_udpctl->data,len);
	*(long *)src->IPAddr = p_udpctl->fhost;
	src->Port = p_udpctl->fgn_port;
	udp_free(UDPID-UDPBASE);
	return(len);
}
#undef UDPID
#undef Buffer
#undef src



typedef struct
{
	unsigned int	_UDPID;
	char 			*_Buffer;
	unsigned int	_len;
	DESTI			*_dest;
} udpw;

#define UDPID	(((udpw *)param)->_UDPID)
#define Buffer	(((udpw *)param)->_Buffer)
#define len		(((udpw *)param)->_len)
#define dest	(((udpw *)param)->_dest)

long UDPWRITE(register char *param)
{
register int ret;

	ret = udp_write(UDPID-UDPBASE,Buffer,len,*(long *)(dest->IPAddr),dest->Port);
	net_demux(FALSE,DEMUX);
	return((long)ret);
}
#undef UDPID
#undef Buffer
#undef len
#undef dest



typedef struct
{
	unsigned int	_port;
	DESTI		   *_dest;
	unsigned int 	_APflag;
	unsigned int	_timeout;
	unsigned long	_rwin;
} tcpo;

#define port	(((tcpo *)param)->_port)
#define dest	(((tcpo *)param)->_dest)
#define APFlag	(((tcpo *)param)->_APflag)
#define timeout	(((tcpo *)param)->_timeout)
#define rwin	(((tcpo *)param)->_rwin)

long TCPOPEN(register char *param)
{
int tcp;
#ifdef DEBUG
TRACE("TCPOPEN\n");
#endif

	if(APFlag != AKTIV && APFlag != PASSIV) return(0);
	if(rwin > 65535L) return(0);	/* receivewindow is unsigned short */
	tcp = tcp_create(rwin,rwin,tcp_upcall);
	if(tcp < 0) return(0);
	if(port) tcp_bind(tcp,port);
		
	if(APFlag == AKTIV)
	{
		if(tcp_open(tcp,*(INADDR *)dest->IPAddr,dest->Port,tm_msec(timeout)) < 0)
		{
			tcp_delete(tcp);
			return(0);
		}
	}
	else
	{
		if(tcp_listen(tcp,port,tm_msec(timeout))<0)
		{
			tcp_delete(tcp);
			return(0);
		}
	}
	net_demux(FALSE,DEMUX);		/* process incoming packets */
	return((long)tcp+TCPBASE);	/* return tcp id > 0 */
}
#undef port
#undef dest
#undef APFlag
#undef timeout
#undef rwin



typedef struct
{
	unsigned int	_TCPID;
	char *			_Buffer;
	unsigned int 	_len;
	unsigned int	_Pflg;
	unsigned int	_Uflg;
} tcpwr;

#define TCPID	(((tcpwr *)param)->_TCPID)
#define Buffer	(((tcpwr *)param)->_Buffer)
#define len		(((tcpwr *)param)->_len)
#define Pflg	(((tcpwr *)param)->_Pflg)
#define Uflg	(((tcpwr *)param)->_Uflg)

long TCPWRITE(register char *param)
{
long sent;

	/*if(Uflg == URGENT) return(-1);*/
	TCPID -= TCPBASE;
	sent = tcp_write(TCPID,Buffer,len,(Pflg == PUSH ? TCP_PUSH : 0) | (Uflg == URGENT ? TCP_URG : 0));
	net_demux(FALSE,DEMUX);
	return(sent);
}

#undef TCPID
#undef Buffer
#undef len
#undef Pflg
#undef Uflg


typedef struct
{
	unsigned int	_TCPID;
	char *			_Buffer;
	unsigned int 	_len;
} tcprd;

#define TCPID	(((tcprd *)param)->_TCPID)
#define Buffer	(((tcprd *)param)->_Buffer)
#define len		(((tcprd *)param)->_len)

long TCPREAD(register char *param)
{
register long got;
#ifdef VDEBUG
TRACE(">TCP_READ, demux\n");
#endif
	net_demux(FALSE,DEMUX);
#ifdef DEBUG
TRACE(">>TCP_READ, tcp_read\n");
#endif
	got = (long)tcp_read(TCPID-TCPBASE,Buffer,len);
#ifdef DEBUG
TRACE("<TCP_READ\n");
#endif
	return(got);
}

#undef TCPID
#undef Buffer
#undef len


typedef struct
{
	unsigned int	_TCPID;
} tcpc;

#define TCPID	(((tcpc *)param)->_TCPID)

long TCPCLOSE(register char *param)
{
int tcp;
	tcp = tcp_close(TCPID - TCPBASE);
	net_demux(FALSE,DEMUX);
	return(tcp<0 ? -1L : TCPID);
}

#undef TCPID

typedef struct
{
	unsigned int	_TCPID;
} tcpa;
#define TCPID	(((tcpa *)param)->_TCPID)

long TCPABORT(register char *param)
{
int tcp;
	tcp = tcp_abort(TCPID - TCPBASE);
	return(tcp<0 ? -1L : (long)TCPID);
}

#undef TCPID

typedef struct
{
	unsigned int	_TCPID;
	TCPSTAT 	   *_statblk;
} tcps;
#define TCPID	(((tcps *)param)->_TCPID)
#define statblk	(((tcps *)param)->_statblk)

long TCPSTATE(register char *param)
{
TCP_TCB *tcb;

#ifdef DEBUGSTAT
sprintf(str,">tcp_stat tcpid %u\n",TCPID);
TRACE(str);

TRACE(">>tcpstat ... do demux\n");	
#endif
    mode = MUXMODE;
	net_demux(FALSE,DEMUX);
    mode = STATMODE;
#ifdef DEBUGSTAT
TRACE("<<tcpstat ... back from demux\n");	
#endif
	if(!TCPID || !statblk)
	{
#ifdef DEBUGSTAT
TRACE("<tcp_stat - no TCPID or statblock\n");
#endif
	 return(-1L);
    }
	tcb = tcp_gettcb(TCPID - TCPBASE);
	if(!tcb)
	{
#ifdef DEBUGSTAT
TRACE("<tcp_stat - no such tcb\n");
#endif
	 return(-1L);
    }
	statblk->TCP_ID = TCPID;
	statblk->TCP_Port = tcb->lcl_port;
	statblk->TCP_Dest.Port = tcb->fgn_port;
	*(INADDR *)(statblk->TCP_Dest.IPAddr) = tcb->fhost;
	statblk->TCP_State = tcb->state;
	statblk->TCP_Urgent = 0;
	statblk->TCP_Timeout = (int)(tcb->timeout / 200);
	statblk->TCP_RWin = tcb->q_in.size;
	statblk->TCP_RWfree = q_free(&(tcb->q_in));
#ifdef DEBUGSTAT
sprintf(str,"<tcp_stat ok, l_%u.f_%u %d\n",tcb->lcl_port,tcb->fgn_port,tcb->state);
TRACE(str);
#endif
	return((long)tcb->state);
}

#undef TCPID
#undef statblk

long tuwinit(void)
{
	cookie = get_cookie(INETCUSTCOOKIE);
	if(!cookie)
	{
		fprintf(stderr," - INETCUST not loaded\n");
		exit(1);
	}
	custom = (INETCUST *)(cookie->val);
	if(!custom || custom->magic != sizeof(INETCUST))
	{
		fprintf(stderr," - invalid custom structure found(%ld->%ld\n",custom->magic,sizeof(INETCUST));
		exit(1);
	}

	if(net_link() < 0)
	{
		fprintf(stderr," - packet driver not found\n");
		exit(1);
	}

	tcp_buffers = buf_create(custom->netmem);
	if(!tcp_buffers)
	{
		fprintf(stderr," - out of memory to allocate buffers\n");
		exit(1);
	}
	
	udp_buffers = buf_create(UDP_MAXPORTS * sizeof(UDP_CTL));

	if(!udp_buffers)
	{
		fprintf(stderr," - out of memory to allocate buffers\n");
		Mfree(tcp_buffers);
		exit(1);
	}
	
	if(!ip_init())			/* init services */
	{
		fprintf(stderr," - cannot init IP layer\n");
		Mfree(tcp_buffers);
		Mfree(udp_buffers);
		exit(1);
	}
	if(!tcp_init())
	{
		ip_exit();
		fprintf(stderr," - cannot init TCP layer\n");
		Mfree(tcp_buffers);
		Mfree(udp_buffers);
		exit(1);
	}
	if(!udp_init())
	{
		ip_exit();
		fprintf(stderr," - cannot init UDP layer\n");
		Mfree(tcp_buffers);
		Mfree(udp_buffers);
		exit(1);
	}
	
 inetstat.tcpcb_list = &tcpcb_list;
 inetstat.udp_list = &udp_list;
 inetstat.ip_qrecv = &ip_qrecv;
 inetstat.arp_counts = arp_counts;
 inetstat.icmp_counts = icmp_counts;
 inetstat.udp_counts = udp_counts;
 inetstat.tcp_counts = tcp_counts;

	add_cookie(INETCOOKIE,(long)(&inetstat));
	cookie = get_cookie(MACHINECOOKIE);

	if(!cookie || (cookie->val >> 16) != 2)
		OLD_GEMDOS = Setexc(TRAP_1,ST_GEMDOS);
	else
		OLD_GEMDOS = Setexc(TRAP_1,TT_GEMDOS);
		Setexc(TRAP_5,TRP5SIM);

        myprog = NET_TICK;

  	       printf(" installed\n"
		   "%ld bytes resident\n"
		   "(c) hw/pm ForTec 1992,93\n\a",
		   _PgmSize+custom->netmem+UDP_MAXPORTS * sizeof(UDP_CTL));
/*        if(linkin())
        {
	      printf("\n - cannot install net-tick\n");
        }
*/        return 0;
}

main()
{

		printf("\nTUW-TCP v%s",VERSION);

#ifdef NETTRACE
	TRACE("TUWTCP startup\n");
#endif

Supexec(tuwinit);

#ifdef DEBUG	printf("net_demux at %lx",(long)net_demux);
	Cconin();
#endif

#ifdef DEBUGAPP
{
DESTI desti;
int tcp_id,x,i;
char data[100];
TCPSTAT tstat;

#define tcp_xopen(a,b,c,d,e)		gemdos(630,a,b,c,d,e)
#define tcp_xwrite(a,b,c,d,e)	gemdos(631,a,b,c,(char)d,(char)e)
#define tcp_xread(a,b,c)			gemdos(632,a,b,c)
#define	tcp_xclose(a)			gemdos(633,a)
#define tcp_xstat(a,b)			gemdos(635,a,b)

    desti.IPAddr[0] = 128;
    desti.IPAddr[1] = 130;
    desti.IPAddr[2] = 70;
    desti.IPAddr[3] = 130;
    desti.Port = 23;
  
    tcp_id = (unsigned)tcp_xopen(0,&desti,AKTIV,60,4096L);
    while(tcp_xstat(tcp_id,&tstat) != ESTABLISHED);
do
{
    if(Cconis())
    {
    data[0] = Cconin();
    x=(int)tcp_xwrite(tcp_id,&data,1,PUSH,NO_URGENT);
    if(data[0] == 3) break;
    }
    x = (int)tcp_xread(tcp_id,&data,10);
    for(i=0;i<x;Cconout(data[i++]));
}while(1);
    tcp_xclose(tcp_id);
    tcp_exit();
	udp_exit();
	ip_exit();
}
#else
	Ptermres(_PgmSize,0);		/* sit into memory */
#endif
	return(0);
}


int udp_upcall(int tcb,char *data,int len)
{
	return(0);
}

int tcp_upcall(int tcb,char *data,int len)
{

		/* upcall codes if datapointer in upcall is NULL */
	if(!data) switch(len)
	{
		case TCP_UCESTAB:
			return(0);
			
		case TCP_UCRESET:
			return(0);
			
		case TCP_UCCLOSING:
			return(0);
			
		case TCP_UCTIMEOUT:
		case TCP_UCDATA:
		case TCP_UCCLOSEWT:
		case TCP_UCCLOSED:
			break;
	}
	return(0);
}
/*
long linkin(void)
{
 int cnt,i;
 void (**queue)();
 extern void (*myprog)();
 extern long *vbl_hook;

 vbl_hook = NULL;
 cnt = *(int*)VBLCNT;
 queue = *((void(***)())VBLLIST);

 for(i = 1;i < cnt;i++)
 {
   if(queue[i] == 0L)
   {
     *(queue+i) = myprog;
     vbl_hook = (long*)(queue+i);
     break;
   }
 }
 if(i < cnt) return 0;
 else return 1;

 OLD_TICK = Setexc(69,myprog);
 return 0;
}
*/