/*     ANS compatible Telnet in AES windows     */
/*         compiled with TURBO-C/PURE-C         */
/*  P. Mayer & H. Wieser fortec TU Vienna 1992  */

#include <vdi.h>
#include <aes.h>
#include <tos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "tnftp.h"
#include "tndefs.h"

extern char *getmem(long size);
extern int w_open(char *name, int xpos, int ypos, int xsiz, int ysiz, int sliders, int titles, FNT *usefont);
extern void w_closei(struct wi_str *wp);
extern void w_close(struct wi_str *wp);
extern int w_resize(struct wi_str *wp1, int xsiz, int ysiz, int sliders, int titles, int chfont);
extern void w_rename(struct wi_str *wp, char *name);
extern void w_info(struct wi_str *wp, char *name);
extern void w_redraw(struct wi_str *wp, int logic, int xx, int yy, int ww, int hh);
extern void w_update(struct wi_str *wp, int logic, int xx, int yy, int ww, int hh);
extern void w_move(struct wi_str *wp, int xx, int yy, int ww, int hh);
extern void w_top(struct wi_str *wp);
extern void w_bottom(void);
extern void w_hide(void);
extern void w_shrink(struct wi_str *wp);
extern void w_full(struct wi_str *wp);
extern void w_arrow(struct wi_str *wp, int arrow);
extern void w_slide(struct wi_str *wp, int hor, int val);
extern void sethslide(struct wi_str *wp);
extern void w_output(struct wi_str *wp, unsigned char *ptr, short charcount);
extern void lineerase(register struct wi_str *wp, int first, int last);
extern int tcp_out(int tcp_id, char *o_str, int o_len);
extern int do_multi(int);

void setvslide(struct wi_str *wp);
void w_flash(struct wi_str *wp, int state);
void scrollup(register struct wi_str *wp, int first, int nlines, int amount);
void scrolldn(register struct wi_str *wp, int first, int nlines, int amount);
int rc_intersect( GRECT *r1, GRECT *r2 );
void vt100_reset (struct wi_str *wp);

/* variables used by various routines
 */

extern int screen_handle;
extern  long dummy;  /* dummy return variable */
extern	int sdummy;  /* short-sized dummy */

extern	int	scr_x, scr_y;  /* size of the screen */
extern	int	scr_w, scr_h;
extern	int	fast;
extern  int	wrap;
/* this makes more updates happen in "scrolled" mode with delayed updates */
extern	int	jerky_updates;
extern	int	mouseflicker;  /* for knowing when to turn it on */
extern	int	audibell;  /* What happens on BEL? */
extern	int	visibell;

extern	FNT	*curfont;  /* current font */
extern	WIN_MFDB screen_mf;  /* screen descriptor */
extern	int	mouse;  /* for mouse on/off */

extern  struct wi_str *wlist;

extern int ncolors;  /* used by ESCb and ESCc */
extern int o_len;
extern char o_str[30];

/* the program code... */

static BASPAG **oldpd;

long set_pd(void)
{
  oldpd = SYSBASE->_run;
  SYSBASE->_run = &_BasPag;
  return 0;
}

long restore_pd(void)
{
  SYSBASE->_run = oldpd;
  return 0;
}

char *getmem(size)
register long size;
{
  char *got;

  /* this relies on malloc taking size_t, and size_t being long, */
  /* or else not compiling with -mshort */
/*  Supexec(set_pd);*/
  got = (char *) malloc(size);
/*  Supexec(restore_pd);*/
  if (got == NULL) 
  {
    form_alert(1, "[1][Out of memory][ Ok ]");
  }
  else 
  {
    memset(got, 0, size);
  }
  return got;
}

/*
 * w_open opens a window with the supplied name.  The new window is
 * top, ergo wlist.  Puts up an alert & returns -1 on errors.
 */

int w_open(name, xpos, ypos, xsiz, ysiz, sliders, titles, usefont)
char *name;
int xpos, ypos, xsiz, ysiz;
int sliders, titles;  /* nonzero to get that thing */
FNT *usefont;  /* ptr to font to use */
{
  register struct wi_str *wp;
  int wdes;
  int wtyp;
  int tmp_w, tmp_h; 

  wtyp = (sliders ? WI_WITHSLD : 0) | (titles ? WI_WITHTITLE : 0);
  if (ypos < scr_y) ypos = scr_y;
  if (xpos < scr_x) xpos = scr_x;

  wind_calc(0, wtyp, 0, 0, usefont->inc_x*xsiz+2*X0,
  usefont->inc_y*ysiz+2*Y0, &sdummy, &sdummy, &tmp_w, &tmp_h);

  if (tmp_w>scr_w)
    tmp_w = scr_w;  /* full size <= screen size */

  if (tmp_h>scr_h)
    tmp_h = scr_h;

  wp = (struct wi_str *)getmem(sizeof(struct wi_str));
  if (wp == NULL) 
  {
    return -1;
  }

  wp->wi_mf.wpix = 2*X0 + xsiz*usefont->inc_x;
  wp->wi_mf.hpix = 2*Y0 + ysiz*usefont->inc_y;
  wp->wi_mf.wwords = (wp->wi_mf.wpix>>4) +1;
  wp->wi_mf.planes = 1;
  wp->font = usefont;
  wp->fgbg[1] = 0;  /* foreground color for vrt_copyfm */
  wp->fgbg[0] = 1;  /* background color for vrt_copyfm */
  wp->discard = !wrap;
  wp->recv_flag = 1;
  /* allocate a screen image for this window before wind_create */
  wp->wi_mf.ptr = (short *)getmem(
  ((long)wp->wi_mf.hpix + wp->font->inc_y*MAXSCROLLED) * 
      wp->wi_mf.wwords*2);

  if (wp->wi_mf.ptr == NULL) 
  {
    free(wp);
    return -1;
  }
  wdes = wind_create(wtyp, scr_x, scr_y, tmp_w, tmp_h);
  if (wdes < 0) 
  {
    form_alert(1, "[1][Sorry, GEM has|no more windows|for us...][Ok]");
    free(wp->wi_mf.ptr);
    free(wp);
    return -1;
  }

  /* install at head of wlist list (which is sorted by window depth) */
  if (wlist == NULL) 
  {
    wp->next = wp->prev = wp;
  }
  else 
  {
    wp->next = wlist;
    wp->prev = wlist->prev;
    wlist->prev->next = wp;
    wlist->prev = wp;
  }
  wlist = wp;

  wp->sliders = sliders;
  wp->titles = titles;
  wp->aes_handle = wdes;
  wp->wi_w = X0*2 + usefont->inc_x*xsiz;
  wp->wi_h = Y0*2 + usefont->inc_y*ysiz;
  wp->wi_style = wtyp;
  wp->wi_mainstyle = wtyp;

  w_rename(wp, name);
  w_info(wp, "");

  if (!fast)
    graf_growbox(0, 0, 20, 10, xpos, ypos, tmp_w, tmp_h);
  wind_open(wdes, xpos, ypos, tmp_w, tmp_h);
  wind_get(wdes, WF_WORKXYWH, &wp->x, &wp->y, &wp->w, &wp->h);

  wp->fulled = 0;
  wp->x_off = 0;
  wp->y_off = 0;
  wp->px_off = 0;
  wp->py_off = 0;
  wp->m_off = wp->x & 15;  /* when is this used? */
  wp->cur_x = X0;
  wp->cur_y = Y0;
  wp->top_y = Y0;
  wp->x_chrs = xsiz;
  wp->y_chrs = ysiz;

  setvslide(wp);
  sethslide(wp);
  w_redraw(wp,FM_COPY, wp->x, wp->y, wp->w, wp->h);
  vt100_reset(wp);
  wlist->markx1 = wlist->markx2 = wlist->lastx2 = -1;
  wlist->marky1 = wlist->marky2 = wlist->lasty2 = -1;
  wlist->direct = 0;
  return 0;
}

/*
 * w_closei removes a window but does not release its storage.  This is used
 * if the window contents must be saved for later use.
 */
void w_closei(wp)
struct wi_str *wp;
{
  int xx, yy, ww, hh;
  int wdes = wp->aes_handle;

  wind_get(wdes, WF_CURRXYWH, &xx, &yy, &ww, &hh);
  wind_close(wdes);
  if (!fast)
    graf_shrinkbox(0, 0, 20, 10, xx, yy, ww, hh);
  wind_delete(wdes);
}

/*
 * w_close removes a window.
 */
void w_close(wp)
struct wi_str *wp;
{
  /* unlink me */
  wp->prev->next = wp->next;
  wp->next->prev = wp->prev;
  if (wp->next == wp) wlist = NULL;  /* singleton list */
  else if (wlist == wp) wlist = wp->next;

  w_closei(wp);
  free(wp->wi_mf.ptr);
  free(wp);
}

/* w_resize resizes an existing window.  Also lets you pass in the
 * sliders & titles arguments for the newly-sized window.
 *
 * This used to relocate the window; now it copies the xy.
 * This used to change the font in the window; now it doesn't unless
 * chfont == 1.
 */
int w_resize(wp1, xsiz, ysiz, sliders, titles, chfont)
struct wi_str *wp1;
int xsiz, ysiz;
int sliders, titles;
int chfont;  /* flag: when 0 don't change font */
{
  struct wi_str *wp2;
  static int c[8];
  int tmp_x, tmp_y, tmp_w, tmp_h, wtyp;
  int retcode;

  if (wp1->curstate) 
  {
    w_flash(wp1,0);
  }

  w_closei(wp1);  /* close it (closes AES window) */

            /* what's happening here is that the overlap of screen images between
             * the old & new sizes gets copied into the new window. This is done by
             * deleting the old window, creating a new one of the new size, and
             * copying the appropriate rectangle of screen image over.
             */

  /* unlink me */
  wp1->prev->next = wp1->next;
  wp1->next->prev = wp1->prev;
  if (wp1->next == wp1) wlist = NULL;
  else if (wlist == wp1) wlist = wp1->next;

  wtyp = (sliders ? WI_WITHSLD : 0) | (titles ? WI_WITHTITLE : 0);
  wind_calc(0,wtyp,wp1->x,wp1->y,wp1->w,wp1->h,
  &tmp_x, &tmp_y, &tmp_w, &tmp_h);

  /* open this window with the same workxy as the previous */
  if (w_open(wp1->name, tmp_x, tmp_y, xsiz, ysiz, 
  sliders, titles, (chfont ? curfont : wp1->font))) 
  {
    /* error opening the new copy of the window */
    retcode = -1;
    goto freeold;
  }

  wp2 = wlist;
  c[0] = wp1->m_off;
  c[1] = wp1->top_y + max(0, wp1->wi_mf.hpix - wp2->wi_mf.hpix);
  c[2] = c[0] + min(wp1->wi_mf.wpix, wp2->wi_mf.wpix);
  c[3] = c[1] + min(wp1->wi_mf.hpix, wp2->wi_mf.hpix);
  c[4] = wp2->m_off;
  c[5] = wp2->top_y;
  c[6] = c[4] + min(wp1->wi_mf.wpix, wp2->wi_mf.wpix);
  c[7] = c[5] + min(wp1->wi_mf.hpix, wp2->wi_mf.hpix);

  /* copy screen */
  vro_cpyfm(screen_handle, FM_COPY, c, (MFDB*)&wp1->wi_mf, (MFDB*)&wp2->wi_mf);
  /* copy parameters */

  wp2->fgbg[0] = wp1->fgbg[0];
  wp2->fgbg[1] = wp1->fgbg[1];
  wp2->insmode = wp1->insmode;

  wp2->fd = wp1->fd;
  wp2->pid = wp1->pid;

  if (wtyp != wp1->wi_mainstyle) 
  {
    /* you're changing the style... copy mainstyle from the original */
    wp2->wi_mainstyle = wp1->wi_mainstyle;
  }

          /* if font changed, put cursor at bottom left.  Else put it at old X
           * offset (or right edge if narrower than that), and I can't figure out
           * the calculation for Y.
           */
  if (wp2->font != wp1->font) 
  {
    wp2->cur_x = X0;
    wp2->cur_y = (wp2->y_chrs - 1) * wp2->font->inc_y + Y0;
  }
  else 
  {
    wp2->cur_x = (wp2->x_chrs - 1) * wp2->font->inc_x + X0;
    if (wp1->cur_x < wp2->cur_x)
      wp2->cur_x = wp1->cur_x;
    wp2->cur_y = max(0, wp1->cur_y - c[1]) + Y0;
  }
  
  wp2->state = wp1->state;
  strcpy(wp2->name,wp1->name);

  wp2->discard = wp1->discard; /* was commented out */
  wp2->curskey = wp1->curskey;
  wp2->keypad = wp1->keypad;
  wp2->smooth = wp1->smooth;
  wp2->repeat = wp1->repeat;
  wp2->lfmode = wp1->lfmode;
  
  wp2->G0 = wp1->G0;
  wp2->G1 = wp1->G1;
  wp2->chset = wp1->chset;
  
  wp2->app = wp1->app;
  wp2->recv_flag = wp1->recv_flag;
  wp2->ftp_data = wp1->ftp_data;

  w_flash(wp2,wp1->curstate);
  retcode = 0;

freeold:
  free(wp1->wi_mf.ptr);
  free(wp1);
  return retcode;  /* old window is GONE if this is -1 */
}

/* w_rename changes the title bar of a window
 */
void w_rename(wp, name)
struct wi_str *wp;
char *name;
{
  if (name)
    strcpy(wp->name, name);
  if (wp->wi_style & NAME) 
  {
    wind_set(wp->aes_handle, WF_NAME, wp->name, 0, 0);
  }
}
/* w_info changes the info line of a window
 */
void w_info(wp, name)
struct wi_str *wp;
char *name;
{
  if (name)
    strcpy(wp->info, name);
  if (wp->wi_style & NAME) 
  {
    wind_set(wp->aes_handle, WF_INFO, wp->info, 0, 0);
  }
}

/* w_redraw redraws part of the screen from window contents.
 * The coordinates are screen relative.
 */
void w_redraw(wp, logic, xx, yy, ww, hh)
struct wi_str *wp;
int logic,xx,yy,ww,hh;
{
  int c[8];
  GRECT t1, t2;
  int wdes = wp->aes_handle;

  /* turn vro_cpyfm logic ops into vrt_cpyfm ones */
  if (logic == FM_INVERT) logic = 3;
  else logic = 1;

  if (xx+ww > scr_w)
    ww = scr_w - xx;
  if (yy+hh > scr_h+scr_y)
    hh = scr_h+scr_y - yy;
  t2.g_x = xx; 
  t2.g_y = yy;
  t2.g_w = ww; 
  t2.g_h = hh;
  t1.g_x = wp->x; 
  t1.g_y = wp->y;
  t1.g_w = wp->w; 
  t1.g_h = wp->h;
  if (!rc_intersect(&t2, &t1)) 
  {
    return;  /* nothing to do... */
  }
  wind_update(TRUE);
  wind_get(wdes, WF_FIRSTXYWH, &t1.g_x, &t1.g_y, &t1.g_w, &t1.g_h);
  while (t1.g_w && t1.g_h) 
  {
    if (rc_intersect(&t2, &t1)) 
    {
      if (mouse) 
      {
        /* we have to do graphics, so switch the mouse off.
                                	 * mouse will be switched on again in main loop.
                                	 * this is ugly, but it improves speed a bit...
                                	 * (If mouseflicker is ON, we'll turn it on again below)
                                	 */
        mouse = 0;
        graf_mouse(M_OFF, NULL);
      }
      c[0] = t1.g_x - wp->x + wp->x_off + wp->m_off;
      c[1] = t1.g_y - wp->y + wp->y_off + wp->top_y - Y0;
      c[2] = c[0] + t1.g_w - 1;
      c[3] = c[1] + t1.g_h - 1;
      c[4] = t1.g_x;
      c[5] = t1.g_y;
      c[6] = c[4] + t1.g_w - 1;
      c[7] = c[5] + t1.g_h - 1;
      vrt_cpyfm(screen_handle, logic, c,
      (MFDB*)&wp->wi_mf, (MFDB*)&screen_mf, wp->fgbg);
    }
    wind_get(wdes, WF_NEXTXYWH, &t1.g_x, &t1.g_y, &t1.g_w, &t1.g_h);
  }
  wind_update(FALSE);
  /* mouse stays hidden -- we'll make it visible next time it moves */
  /* except if mouseflicker is on, in which case we'll do it NOW */
  if (!mouse && mouseflicker) 
  {
    mouse = 1;
    graf_mouse(M_ON,NULL);
  }
}

/* w_update copies a portion of the window to the screen.  Coordinates
 * are window-relative
 */
void w_update(wp, logic, xx, yy, ww, hh)
struct wi_str *wp;
int logic, xx,yy,ww,hh;
{
  w_redraw(wp, logic, xx + wp->x - wp->x_off, 
  yy + wp->y - wp->y_off - wp->top_y + Y0, ww, hh);
}

/* w_move sets the window's idea of its own position on the screen
 */

void w_move(wp, xx, yy, ww, hh)
struct wi_str *wp;
int xx, yy, ww, hh;
{
  int wdes = wp->aes_handle;
  int flag = 0;
  int m_w, m_h;
  int x1, x2;
  int tmp;
  int c[8];
  int inc_x, inc_y;

  wind_calc(1, wp->wi_style, xx, yy, ww, hh, &sdummy, &sdummy, &m_w, &m_h);
  if ((tmp = (m_w-2*X0)%wp->font->inc_x) != 0)
  {
    ww -= tmp;
    m_w -= tmp;
  }
  if ((tmp = (m_h-2*Y0)%wp->font->inc_y) != 0)
  {
    hh -= tmp;
    m_h -= tmp;
  }
  if (m_w>wp->wi_w) ww = ww-(m_w-wp->wi_w);
  if (m_h>wp->wi_h) hh = hh-(m_h-wp->wi_h);
  wind_set(wdes, WF_CURRXYWH, xx, yy, ww, hh);
  wind_get(wdes, WF_WORKXYWH, &wp->x, &wp->y, &wp->w, &wp->h);
  if (wp->x_off+wp->w > wp->wi_w) 
  {
    inc_x = wp->font->inc_x;
    flag = 1;
    wp->x_off = (wp->wi_w - wp->w)/inc_x*inc_x;
  }
  if (wp->y_off+wp->h > wp->wi_h) 
  {
    inc_y = wp->font->inc_y;
    flag = 1;
    wp->y_off = (wp->wi_h - wp->h)/inc_y*inc_y;
  }
  x1 = wp->m_off;
  x2 = (wp->x - wp->x_off) & 15;
  if (x1 != x2) 
  {
    c[0] = x1;
    c[1] = wp->top_y;  /* displayed part of memory form starts here */
    c[2] = x1 + wp->wi_w - 1;
    c[3] = wp->wi_h - 1 + c[1];
    c[4] = x2;
    c[5] = c[1];
    c[6] = x2 + wp->wi_w - 1;
    c[7] = c[3];
    vro_cpyfm(screen_handle, FM_COPY, c, (MFDB*)&wp->wi_mf, (MFDB*)&wp->wi_mf);
    wp->m_off = x2;
  }
  if (flag)
    w_redraw(wp, FM_COPY, wp->x, wp->y, wp->w, wp->h);
  setvslide(wp);
  sethslide(wp);
}

/*
 * w_top makes win the top window.
 */

void w_top(wp)
struct wi_str *wp;
{
  wind_set(wp->aes_handle, WF_TOP, 0, 0, 0, 0);

  if (wlist == wp) return;  /* already top of list */

  /* unlink from its current place */
  wp->next->prev = wp->prev;
  wp->prev->next = wp->next;

  /* link into top */
  wp->next = wlist;
  wp->prev = wlist->prev;
  wlist->prev->next = wp;
  wlist->prev = wp;
  wlist = wp;
}

/*
 * w_bottom finds the bottom window and puts it on top
 */

void w_bottom()
{
  struct wi_str *wp;

  if (!wlist || wlist->next == wlist) return;
  for (wp = wlist->next; wp->next != wlist; wp = wp->next)  /* do nothing */ ;
  w_top(wp);
}

/*
 * w_hide puts the top window on the bottom.
 * (a.k.a. "bury")
 */

void w_hide()
{
  struct wi_str *wp, *oldtop;

  /* top all the windows, in order, from back to front, except the first. */
  if (!wlist || wlist->next == wlist) return;  /* empty or singleton list */
  oldtop = wlist;  /* window NOT to top */
  for (wp = wlist->prev; wp != oldtop; wp = wp->prev)
    wind_set(wp->aes_handle,WF_TOP, 0,0,0,0);

  /* move the top element from wlist to the end of wlist (easy!) */
  wlist = wlist->next;
}

#define TINYX 80
#define TINYY 70
/*
 * w_shrink saves current size and location and shrinks to standard tiny size.
 * The second from the top non-shrunk window is placed on top.
 */

void w_shrink(wp)
struct wi_str *wp;
{
  int wdes = wp->aes_handle;
  int curx, cury, curw, curh;
  static int slotcount;

  /*
           * Don't shrink a window that is currently shrunk
           */
  wind_get(wdes, WF_CURRXYWH, &curx, &cury, &curw, &curh);
  if (curw <= TINYX && cury <= TINYY)
    return;

  if (wp->slotno == 0) wp->slotno = ++slotcount;

  /*
           * By setting wp->fulled to one and the "previous" size to tiny,
           * we're saying that the current size is the "full" size, and we
           * want to "toggle to" the tiny size.
           */
  wp->fulled = 1;
  wp->px = scr_x + (scr_w - TINYX + 2);
  wp->py = scr_y + ((wp->slotno-1) * (TINYY + 2));
  wp->pw = TINYX;
  wp->ph = TINYY;

  /* ensure at least 10 dots of title bar on screen */
  if (wp->py + 10 > scr_y + scr_h) 
  {
    wp->py = wp->py - scr_h + 10;
    wp->px = scr_x + scr_w - TINYY * 2;
  }
  w_full(wp);

  /* now top the topmost window which isn't already tiny */

  wp = wlist;
  do 
  {
    wdes = wp->aes_handle;
    wind_get(wdes, WF_CURRXYWH, &curx, &cury, &curw, &curh);
    if (curw > TINYX || curh > TINYY) 
    {
      w_full(wp);
      w_top(wp);
      return;
    }
    wp = wp->next;
  } 
  while (wp != wlist);

  /* no windows are not shrunk; just leave 'em */
}

/* w_full toggles size and location between the current size and
 * the "previous" size.
 */

void w_full(wp)
struct wi_str *wp;
{
  int x1, y1, w1, h1;
  int x2, y2, w2, h2;
  int full;
  int wdes = wp->aes_handle;

  full = wp->fulled;

  /* if already full, set to "previous" size, else to full size */
  if (full) 
  {
    x1 = wp->px;
    y1 = wp->py;
    w1 = wp->pw;
    h1 = wp->ph;
  }
  else
    wind_get(wdes, WF_FULLXYWH, &x1, &y1, &w1, &h1);

  wind_get(wdes, WF_CURRXYWH, &x2, &y2, &w2, &h2);
  wp->px = x2;
  wp->py = y2;
  wp->pw = w2;
  wp->ph = h2;
  if (!fast) 
  {
    if (w2>=w1)
      graf_growbox(x1, y1, w1, h1, x2, y2, w2, h2);
    else
      graf_shrinkbox(x1, y1, w1, h1, x2, y2, w2, h2);
  }

  x2 = wp->x_off;
  y2 = wp->y_off;
  wp->x_off = wp->px_off;
  wp->y_off = wp->py_off;
  wp->px_off = x2;
  wp->py_off = y2;

  w_move(wp, x1, y1, w1, h1);
  w_redraw(wp, FM_COPY, wp->x, wp->y, wp->w, wp->h);
  wp->fulled = 1;
}

void w_arrow(wp, arrow)
struct wi_str *wp;
int arrow;
{
  int inc_x = wp->font->inc_x;
  int inc_y = wp->font->inc_y;

  switch (arrow) 
  {
  case 0:  /* page up */
    wp->y_off -= wp->h/inc_y*inc_y;
    goto y_upd;

  case 1:  /* page down */
    wp->y_off += wp->h/inc_y*inc_y;
    goto y_upd;

  case 2:  /* row up */
    wp->y_off -= inc_y;
    goto y_upd;

  case 3:  /* row down */
    wp->y_off += inc_y;
    goto y_upd;

  case 4:  /* page left */
    wp->x_off -= wp->w/inc_x*inc_x;
    goto x_upd;

  case 5:  /* page right */
    wp->x_off += wp->w/inc_x*inc_x;
    goto x_upd;

  case 6:  /* column left */
    wp->x_off -= inc_x;
    goto x_upd;

  case 7:  /* column right */
    wp->x_off += inc_x;
    goto x_upd;
  }

x_upd:
  if (wp->x_off<0) wp->x_off = 0; 
  else
    if (wp->x_off+wp->w > wp->wi_w) wp->x_off = (wp->wi_w - wp->w)/inc_x*inc_x;
  sethslide(wp);
  goto upd;

y_upd:
  if (wp->y_off<0) wp->y_off = 0; 
  else
    if (wp->y_off+wp->h > wp->wi_h) wp->y_off = (wp->wi_h - wp->h)/inc_y*inc_y;
  setvslide(wp);

upd:
  w_redraw(wp, FM_COPY, wp->x, wp->y, wp->w, wp->h);
}

void w_slide(wp, hor, val)
struct wi_str *wp;
int hor, val;
{
  int tmp;

  if (hor) 
  {
    tmp = wp->font->inc_x;
    wp->x_off = (int)(((long)val*(wp->wi_w-wp->w)/1000)/tmp*tmp);
    sethslide(wp);
  }
  else 
  {
    tmp = wp->font->inc_y;
    wp->y_off = (int)(((long)val*(wp->wi_h-wp->h)/1000)/tmp*tmp);
    setvslide(wp);
  }
  w_redraw(wp, FM_COPY, wp->x, wp->y, wp->w, wp->h);
}

void sethslide(wp)
struct wi_str *wp;
{
  int tmp;
  int wdes = wp->aes_handle;

  if (wp->wi_style & HSLIDE) 
  {
    if (wp->wi_w == wp->w) tmp = 0;
    else tmp = (int)((long)1000*wp->x_off/(wp->wi_w-wp->w));
    if (tmp != wp->hspos) 
    {
      wind_set(wdes, WF_HSLIDE, tmp, 0, 0, 0);
      wp->hspos = tmp;
    }

    tmp = (int)((long)1000*wp->w/wp->wi_w);
    if (tmp != wp->hssiz) 
    {
      wind_set(wdes, WF_HSLSIZE, tmp, 0, 0, 0);
      wp->hssiz = tmp;
    }
  }
}

void setvslide(wp)
struct wi_str *wp;
{
  int tmp;
  int wdes = wp->aes_handle;

  if (wp->wi_style & VSLIDE) 
  {
    if (wp->wi_h == wp->h) tmp = 0;
    else tmp = (int)((long)1000*wp->y_off/(wp->wi_h-wp->h));
    if (tmp != wp->vspos) 
    {
      wind_set(wdes, WF_VSLIDE, tmp, 0, 0, 0);
      wp->vspos = tmp;
    }

    tmp = (int)((long)1000 * wp->h / wp->wi_h);
    if (tmp != wp->vssiz) 
    {
      wind_set(wdes, WF_VSLSIZE, tmp, 0, 0, 0);
      wp->vssiz = tmp;
    }
  }
}

/*
 * flash the cursor in a window; if it's not the last one we flashed,
 * un_flash that one
 */
void w_flash(wp, state)
struct wi_str *wp;
int state;
{
  static struct wi_str *wp_last = NULL;
  int t[8];

/*  if (wp_last && wp != wp_last) w_flash(wp_last, 1);*/
  wp_last = wp;
  if (wp->curstate == state) return;
  if (state == 2)
    wp->curstate = !wp->curstate;
  else
    wp->curstate = state;
  t[0] = t[4] = wp->cur_x + wp->m_off;
  t[1] = t[5] = wp->cur_y;
  t[2] = t[6] = t[0]+wp->font->inc_x-1;
  t[3] = t[7] = t[1]+wp->font->inc_y-1;
  vro_cpyfm(screen_handle, FM_INVERT, t, (MFDB*)&wp->wi_mf, (MFDB*)&wp->wi_mf);
  w_update(wp, FM_COPY, wp->cur_x, wp->cur_y, wp->font->inc_x, wp->font->inc_y);
}

/* w_output prints a string onto the window.  The string may
 * contain control chars and escape sequences.  Its length is given,
 * so you can even output NULs.
 */
void w_output(wp, ptr, charcount)
struct wi_str *wp;
unsigned char *ptr;
short charcount;
{
  unsigned char ch;
  int inc_x, cur_x;
  int inc_y, cur_y;
  int t[8];
  int /*f_x, f_y,*/ f_mod;
  int scrolled;  /* Number of scrolling operations delayed */
  int xsiz, ysiz;/* Size in chars of terminal emulation for this window*/
  register unsigned char *sptr;
  register unsigned long *dptr;
  register unsigned long mask;
  register int shift;
  register unsigned long valu;
  int count = 0;
  char * fdata;
  long width;
  char * wimfptr;
  int moffincx;
  int state;

  if (!wp->font || charcount == 0) return;
  state = wp->state;
  inc_x = wp->font->inc_x;
  inc_y = wp->font->inc_y;
  xsiz = wp->x_chrs;
  ysiz = wp->y_chrs;
  /*f_x = */cur_x = wp->cur_x;
  /*f_y = */cur_y = wp->cur_y;

  /*
           * This sets "hard update" any time the bottom N lines of the buffer are
           * being used -- that is, the overflow below the visible screen. This is
           * seven lines in 8 when you're doing glass-tty scrolling things.  This
           * is wrong & slow.
           */

  scrolled = wp->top_y/inc_y;

  fdata = wp->font->f_data;
  width = 2 * wp->wi_mf.wwords;
  wimfptr = ((char *) (wp-> wi_mf.ptr)) - 2;
  moffincx = wp->m_off + inc_x - 1;
  f_mod = 0;

  if (wp->curstate) 
  {
    w_flash(wp, 0);
  }

  while (charcount--) 
  {
    ch = *ptr++;
    if(ch == CAN)
    {
     state = S_NORMAL;
     continue;
    }
      if(ch < ' ') 
      {  /* not printable character */
                                    /*
                                	 * If you've modified the screen in this incarnation and you aren't
                                	 * "scrolled", update before any non-printing character.  This
                                	 * appears to call w_update for the line you're on, from the X you
                                	 * started from to the X you're at now.  I think this is
                                	 * inefficient, but I'm not sure yet.  If you're in insert mode,
                                	 * update the whole line from the starting X to the end of the
                                	 * line.
                                	 *
                                	 * I changed this to set "scrolled" if you get here and f_mod is
                                	 * TRUE.  That means simple updates on one line (no non-printing
                                	 * chars) don't happen in "scrolled" mode, but anything more
                                	 * complicated does.  This is also conditional on jerky_updates,
                                	 * which is the visual result.
                                	 */

        if (f_mod)
        {
         if(!jerky_updates) scrolled++;
        }
        switch (ch) 
        {
        case '\007':  /* Bell */
          if (audibell) (void)Bconout(2, '\007');
          if (visibell) 
          {
            w_redraw(wp, FM_INVERT, wp->x, wp->y, wp->w, wp->h);
            w_redraw(wp, FM_COPY, wp->x, wp->y, wp->w, wp->h);
            /* Should clear flag to prevent need for next update? */
          }
          break;

        case '\r':  /* Carriage Return */
          cur_x = X0;
          break;

        case '\b':  /* Backspace */
          if (cur_x>X0) cur_x -= inc_x;
          break;

        case '\n':  /* Newline */
          if (cur_y + inc_y >= inc_y * (wp->bottomline + 1) + wp->top_y)
          {
            scrollup(wp, wp->topline, wp->bottomline - wp->topline, 1);
          if (! scrolled)
            w_update(wp, FM_COPY, X0, wp->topline * inc_y, xsiz * inc_x,
            wp->top_y + (inc_y * (wp->bottomline - wp->topline + 1)));
          }
          else cur_y += inc_y;
          if(wp->lfmode) cur_x = X0;
          break;

        case '\t':  /* Tab */
          cur_x = (((cur_x - X0)/inc_x/8 + 1))*inc_x*8+X0;
          cur_x = min(cur_x, (inc_x * (xsiz-1)+X0)); 
          break;

        case ENQ:  /* ENQ - get answer back */
          sprintf(o_str,"TUW VT100");
          o_len = (int)strlen(o_str);
          tcp_out(wp->pid,o_str,o_len);
          break;
        case SI:
          wp->chset = 0;
          break;
        case SO:
          wp->chset = 1;
          break;
        case '\033':  /* ESC */
          state = S_ESC;
          count = 0;  /* count is used for insert or delete line */
          break;
        }
        /*f_x = cur_x;
        f_y = cur_y;*/
      }
    else
    {
    switch (state) 
    {
    case S_NORMAL:
      if (ch >= ' ') 
      {
        if (wp->insmode) 
        {  /* open space for character */
          t[0] = cur_x + wp->m_off;
          t[1] = t[5] = cur_y;
          t[2] = (xsiz - 1) * inc_x + wp->m_off - 1;
          t[3] = t[7] = cur_y + inc_y - 1;
          t[4] = t[0] + inc_x;
          t[6] = t[2] + inc_x;
          vro_cpyfm(screen_handle, FM_COPY, t, (MFDB*)&wp->wi_mf, (MFDB*)&wp->wi_mf);
        }

        /* paint the character (only if it's in range for this font) */
        if (ch < wp->font->nchars) 
        {
          ch &= 0x7f;
          if(wp->chset == 0)
          {
            if(wp->G0 == '0' && ch >= '_') ch -= '_';
          }
          else
            if(wp->G1 == '0' && ch >= '_') ch -= '_';
          sptr = (unsigned char *)(fdata+ch*16);
          dptr = (unsigned long *)(wimfptr + cur_y*width
              + (((moffincx + cur_x)>>4)<<1));
          shift = 15 - ((moffincx + cur_x)&15);

          /* to get overstrike, set mask to -1 */
          mask = (-1L << (shift+inc_x)) | ((1 << shift)-1);
          if (wp->inverse) 
          {
            for (count = inc_y; count; count--) 
            {
              valu = (((long)(*sptr++)) << shift) ^ ~mask;
              *dptr = (*dptr&mask)|valu;
              ((char *)dptr) += width;
            }
          }
          else 
          {
            for (count = inc_y; count; count--) 
            {
              valu = ((long)(*sptr++))<<shift;
              *dptr = (*dptr&mask)|valu;
              ((char *)dptr) += width;
            }
          }
        }
        cur_x += inc_x;
        f_mod = 1;
        if (cur_x >= inc_x * xsiz) 
        {  /* autowrap */
          cur_x -= inc_x;  /* back to last char position */
          if (wp->discard) 
          {
          }
          else 
          {
            if (cur_y + inc_y >= inc_y * (wp->bottomline + 1) + wp->top_y)
            {
              scrollup(wp, wp->topline, wp->bottomline - wp->topline, 1);
            if (! scrolled)
              w_update(wp, FM_COPY, X0, wp->topline * inc_y, xsiz * inc_x,
              wp->top_y + (inc_y * (wp->bottomline - wp->topline + 1)));
            }
            else cur_y += inc_y;
            cur_x = X0;

          /* cur_y += inc_y;
            if (cur_y >= wp->top_y + inc_y * ysiz) 
            {
              wp->top_y += inc_y;
              ++ scrolled;
            }
            if (! scrolled) 
            {
              w_update(wp, FM_COPY, f_x, f_y, cur_x-f_x, inc_y);
              f_mod = 0;
            }
            cur_x = X0;

            f_x = cur_x;
            f_y = cur_y;
          */}
        }
      } 
      break;

    case S_CHS0:
      wp->G0 = ch;
      state = S_NORMAL;
      break;
      
    case S_CHS1:
      wp->G1 = ch;
      state = S_NORMAL;
      break;

    case S_ESC:
      switch (ch) 
      {
      case '[':  /* CSI */
        state = S_CSI;
        wp->val1 = wp->val2 = wp->valcnt = 0;
        break;
      case '(':
        state = S_CHS0;
        break;
      case ')':
        state = S_CHS1;
        break;
      case '7':  /* AKP: save cursor location */
        wp->save_x = cur_x;
        wp->save_y = cur_y;
        state = S_NORMAL;
        break;
      case '8':  /* AKP: restore saved location */
        /*f_x = */cur_x = wp->save_x;
        /*f_x = */cur_y = wp->save_y;
        state = S_NORMAL;
        break;
      case '>':  /* reset keypad (numeric) mode */
        wp->keypad = 0;
        state = S_NORMAL;
        break;
      case '=':  /* set keypad (application) mode */
        wp->keypad = 1;
        state = S_NORMAL;
        break;
      case 'Z':  /* terminal ID */
        /* this is obsolete. use ESC [ c */
        state = S_NORMAL;
        break;
      case 'c':  /* reset to initial state */
        vt100_reset(wp);
        wp->discard = 1;
        state = S_NORMAL;
        break;
      case 'H':  /* set tab at current position */
        state = S_NORMAL;
        break;
      case 'E':  /* next line */
          cur_x = X0;
      case 'D':  /* index */
        cur_y += inc_y;
        if (cur_y >= inc_y * (wp->bottomline+1) + wp->top_y)
        {
          wp->top_y += inc_y;
          ++ scrolled;
        }
        state = S_NORMAL;
        break;
      case 'M':  /* Reverse Index (does possible reverse scroll) */
        if (cur_y != wp->top_y + (wp->topline * inc_y)) 
        {
          cur_y -= inc_y;
        }
        else
        {
          scrolldn(wp, cur_y/inc_y, wp->bottomline - wp->topline, 1);
          if (! scrolled)
            w_update(wp, FM_COPY, X0, cur_y, xsiz * inc_x,
            wp->top_y + (inc_y * (wp->bottomline - wp->topline + 1)));
        }
        state = S_NORMAL;
        break;
      case '#':
        state = S_ALIGN;
        break;
      default:  /* Unknown escape sequence */
        state = S_NORMAL;
        break;
      }
      break;
    case S_ALIGN:
      if(ch == '8')
      {
          cur_x = X0;
          cur_y = wp->top_y = Y0;
       do
       {
          sptr = (unsigned char *)(fdata+'E'*16);
          dptr = (unsigned long *)(wimfptr + cur_y*width
              + (((moffincx + cur_x)>>4)<<1));
          shift = 15 - ((moffincx + cur_x)&15);

          /* to get overstrike, set mask to -1 */
          mask = (-1L << (shift+inc_x)) | ((1 << shift)-1);

          for (count = inc_y; count; count--) 
          {
            valu = ((long)(*sptr++))<<shift;
            *dptr = (*dptr&mask)|valu;
            ((char *)dptr) += width;
          }
        cur_x += inc_x;
        f_mod = 1;
        if (cur_x > inc_x * xsiz) 
        { 
            cur_y += inc_y;
            cur_x = X0;
        }
       }
       while(cur_y < (Y0 + inc_y * ysiz));

       f_mod = 0;
       cur_x = /*f_x = */X0;
       cur_y = /*f_y = */Y0;
       w_redraw(wp, FM_COPY, wp->x, wp->y, wp->w, wp->h);
      }
      state = S_NORMAL;
      break;
    case S_CSI:
      wp->valcnt = 0;
      switch (ch) 
      {
      case '?':
        state = S_QUE;
        wp->val1 = 0;
        break;
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
        state = S_NUM1;
        wp->valcnt = 0;
        wp->val[0] = wp->val1 = ch - '0';
        break; 
      case 'm':  /* Exit Inverse */
        wp->inverse = 0;
        state = S_NORMAL;
        break;
      default:  /* other escape sequence, continue as if parameter 0 */
        state = S_NUM1;
        wp->valcnt = 0;
        wp->val[0] = 0;
        ptr--;
        charcount++;
        break;
      }
      break;
    case S_NUM1:
      switch (ch) 
      {
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
        wp->val1 = wp->val[0] = (wp->val1*10) + ch - '0';
        break; 
      case ';':
        state = S_NUM2;
        wp->valcnt = 1;
        wp->val[1] = 0;
        break;
      case 'J':
        switch(wp->val1)
        {
        case 0:  /* Clear to End of Screen */
          lineerase(wp, cur_y / inc_y + 1, ysiz - 1 + wp->top_y / inc_y);
          if (! scrolled)
            w_update(wp, FM_COPY, X0, cur_y + inc_y, xsiz*inc_x, ysiz*inc_y);
          t[0] = t[4] = cur_x + wp->m_off;
          t[1] = t[5] = cur_y;
          t[2] = t[6] = X0-1 + xsiz*inc_x +wp->m_off;
          t[3] = t[7] = cur_y+inc_y-1;
          vro_cpyfm(screen_handle, FM_CLEAR, t, (MFDB*)&wp->wi_mf, (MFDB*)&wp->wi_mf);
          if (! scrolled)
            w_update(wp, FM_COPY, cur_x, cur_y, xsiz * inc_x - cur_x, inc_y);
          state = S_NORMAL;
          break;
        case 1:  /* Clear from beginning of screen */
          if(cur_y >= inc_y) lineerase(wp, 0, cur_y/inc_y - 1);  /* clear top to this line */
          ++scrolled;
          t[0] = t[4] = wp->m_off;  /* init X */
          t[1] = t[5] = cur_y;  /* init Y */
          t[2] = t[6] = cur_x + wp->m_off + inc_x - 1;  /* final X */
          t[3] = t[7] = cur_y+inc_y-1;
          vro_cpyfm(screen_handle, FM_CLEAR, t, (MFDB*)&wp->wi_mf, (MFDB*)&wp->wi_mf);
          ++scrolled;
          state = S_NORMAL;
          break;
        case 2:  /* Clear whole Screen */
          /*f_x = */cur_x = X0;
          wp->top_y = /*f_y = */cur_y = Y0;
          wp->inverse = 0;
          wp->insmode = 0;
          lineerase(wp, 0, ysiz - 1 + MAXSCROLLED);
          ++ scrolled;
          state = S_NORMAL;
          break;
        }
        break;
      case 'K':
        switch(wp->val1)
        {
        case 0:  /* Clear to End of Line */
          t[0] = t[4] = cur_x + wp->m_off;
          t[1] = t[5] = cur_y;
          t[2] = t[6] = X0-1 + xsiz*inc_x +wp->m_off;
          t[3] = t[7] = cur_y+inc_y-1;
          vro_cpyfm(screen_handle, FM_CLEAR, t, (MFDB*)&wp->wi_mf, (MFDB*)&wp->wi_mf);
          if (! scrolled)
            w_update(wp, FM_COPY, cur_x, cur_y, xsiz * inc_x - cur_x, inc_y);
          state = S_NORMAL;
          break;
        case 1:  /* Clear from beginning of line */
          t[0] = t[4] = wp->m_off;  /* init X */
          t[1] = t[5] = cur_y;  /* init Y */
          t[2] = t[6] = cur_x + wp->m_off + inc_x -1;  /* final X */
          t[3] = t[7] = cur_y+inc_y-1;
          vro_cpyfm(screen_handle, FM_CLEAR, t, (MFDB*)&wp->wi_mf, (MFDB*)&wp->wi_mf);
          ++scrolled;
          state = S_NORMAL;
          break;
        case 2:  /* erase entire line, cursor to left */
          t[0] = t[4] = wp->m_off;
          t[1] = t[5] = cur_y;
          t[2] = t[6] = X0-1 + xsiz*inc_x + wp->m_off;
          t[3] = t[7] = cur_y+inc_y-1;
          vro_cpyfm(screen_handle, FM_CLEAR, t, (MFDB*)&wp->wi_mf, (MFDB*)&wp->wi_mf);
          ++scrolled;
          cur_x = X0;
          state = S_NORMAL;
          break;
        }
        break;  
      case 'H':  /* special case cursor set */
      case 'f':
        if(wp->val1 != 0) wp->val1--;
        if(wp->origmode) wp->val1 += wp->topline;
        /*f_x = */cur_x = X0;
        /*f_y = */cur_y = wp->val1*inc_y + wp->top_y;
        state = S_NORMAL;
        break;
      case 'A':  /* Cursor Up */
        if(wp->val1 == 0) wp->val1 = 1;
        for(;wp->val1;wp->val1--)
        if(wp->origmode)
        {
          if (cur_y > wp->topline*inc_y + wp->top_y) 
          {
            cur_y -= inc_y;
          }
        }
        else
        {
          if (cur_y!=wp->top_y) 
          {
            cur_y -= inc_y;
          }
        }
        state = S_NORMAL;
        break;
      case 'B':  /* Cursor Down */
        if(wp->val1 == 0) wp->val1 = 1;
        for(;wp->val1;wp->val1--)
        if(wp->origmode)
        {
          if ((cur_y + inc_y) < (wp->bottomline + 1)*inc_y) 
          {
            cur_y += inc_y;
          }
        }
        else
        {
          if ((cur_y + inc_y) < (wp->top_y + (inc_y * ysiz))) 
          {
            cur_y += inc_y;
          }
        }
        state = S_NORMAL;
        break;
      case 'C':  /* Cursor Right */
        if(wp->val1 == 0) wp->val1 = 1;
        for(;wp->val1;wp->val1--)
          if (cur_x < (xsiz - 1) * inc_x) cur_x += inc_x;
        state = S_NORMAL;
        break;
      case 'D':  /* Cursor Left */
        if(wp->val1 == 0) wp->val1 = 1;
        for(;wp->val1;wp->val1--)
          if (cur_x > X0) cur_x -= inc_x;
        state = S_NORMAL;
        break;
      case 'L':  /* Insert Line */
        if(wp->val1 == 0) wp->val1 = 1;
        wp->val1 = min(wp->val1, cur_y/inc_y - wp->topline);
        scrolldn(wp, cur_y/inc_y, (wp->bottomline + 1) - (cur_y - wp->top_y + Y0)/inc_y - wp->val1, wp->val1);
        if (! scrolled)
          w_update(wp, FM_COPY, X0, cur_y, xsiz * inc_x,
          (wp->bottomline + 1) * inc_y - cur_y + wp->top_y - Y0);
        state = S_NORMAL;
        break;
      case 'M':  /* Delete Line */
        if(wp->val1 == 0) wp->val1 = 1;
        wp->val1 = min(wp->val1, wp->bottomline - cur_y/inc_y);
        scrollup(wp, cur_y / inc_y,
        wp->bottomline - (cur_y - wp->top_y + Y0)/inc_y - wp->val1 + 1, wp->val1);
        if (! scrolled)
          w_update(wp, FM_COPY, X0, cur_y, xsiz * inc_x,
          (wp->bottomline + 1) * inc_y - cur_y + wp->top_y - Y0);
        state = S_NORMAL;
        break;
      case 'P':  /* Delete Character */
        if(wp->val1 == 0) wp->val1 = 1;
        for(;wp->val1;wp->val1--)
        {
          t[0] = cur_x + inc_x + wp->m_off;
          t[1] = t[5] = cur_y;
          t[2] = X0 - 1 + xsiz * inc_x + wp->m_off;
          t[3] = t[7] = cur_y+inc_y - 1;
          t[4] = t[0] - inc_x;
          t[6] = t[2] - inc_x;
          vro_cpyfm(screen_handle, FM_COPY, t, (MFDB*)&wp->wi_mf, (MFDB*)&wp->wi_mf);
          t[0] = t[4] = X0 + (xsiz - 1) * inc_x + wp->m_off;
          t[2] = t[6] = t[0] + inc_x - 1;
          vro_cpyfm(screen_handle, FM_CLEAR, t, (MFDB*)&wp->wi_mf, (MFDB*)&wp->wi_mf);
        }
        if (! scrolled)
          w_update(wp, FM_COPY, cur_x, cur_y, xsiz * inc_x - (cur_x - X0),
          inc_y);
        state = S_NORMAL;
        break;
      case 'h':  /* Insert Mode */
        switch(wp->val1)
        {
        case 4:
          wp->insmode = 1;
          break;
        case 20:
          wp->lfmode = 1;
          state = S_NORMAL;
          break;
        }
        state = S_NORMAL;
        break;
      case 'l':  /* End Insert */
        switch(wp->val1)
        {
        case 4:
          wp->insmode = 0;
          break;
        case 20:
          wp->lfmode = 0;
          state = S_NORMAL;
          break;
        }
        state = S_NORMAL;
        break;
      case 'm':
        switch(wp->val1)
        {
        case 0:  /* Exit Inverse */
          wp->inverse = 0;
          break;
        default:
          wp->inverse = 1;
        }
        state = S_NORMAL;
        break;
      case 'n':
       switch(wp->val1)
       {
         case 5:
           sprintf(o_str,"\033[0n");
           o_len = (int)strlen(o_str);
           tcp_out(wp->pid,o_str,o_len);
         break;
         case 6:
           wp->val1 = 1 + (cur_y - wp->top_y)/inc_y;
           wp->val2 = 1 + (cur_x - X0)/inc_x;
           sprintf(o_str,"\033[%d;%dR",wp->val1,wp->val2);
           o_len = (int)strlen(o_str);
           tcp_out(wp->pid,o_str,o_len);
         break;
       }
       break; 
      case 'c':
       sprintf(o_str,"\033[?1;2c");
       o_len = (int)strlen(o_str);
       tcp_out(wp->pid,o_str,o_len);
       break;
      default:
        state = S_NORMAL;
        break;
      }
      break;
    case S_QUE:
      switch(ch)
      {
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
        wp->val1 = (wp->val1*10) + ch - '0';
        break; 
      case 'l':
        switch(wp->val1)
        {
        case 1:
          wp->curskey = 0;
          state = S_NORMAL;
          break;
        case 3:
          if (w_resize(wp, 80, 24, wp->sliders, wp->titles, 0));
          xsiz = 80;
          wp = wlist;
          wp->colwidth = 0;
          /*f_x = */cur_x = X0;
          /*f_y = */cur_y = Y0;
          width = 2 * wp->wi_mf.wwords;
          wimfptr = ((char *) (wp-> wi_mf.ptr)) - 2;
          moffincx = wp->m_off + inc_x - 1;
          lineerase(wp, 0, ysiz - 1 + MAXSCROLLED);
          ++ scrolled;
          state = S_NORMAL;
          break;
        case 4:
          wp->smooth = 0;
          state = S_NORMAL;
          break;
        case 5:
          wp->fgbg[0] = (ncolors-1);
          wp->fgbg[1] = 0;
          state = S_NORMAL;
          scrolled++;  /* force a hard update */
          break;
        case 6:
          wp->origmode = 0;
          /*f_y = */cur_y = wp->val1*inc_y + wp->top_y;
          /*f_x = */cur_x = X0;
          state = S_NORMAL;
          break;
        case 7:
          wp->discard = 1;
          state = S_NORMAL;
          break;
        case 8:
          wp->repeat = 0;
          state = S_NORMAL;
          break;
        }
        break;
      case 'h':
        switch(wp->val1)
        {
        case 1:
          wp->curskey = 1;
          state = S_NORMAL;
          break;
        case 3:
          if (w_resize(wp, 132, 24, wp->sliders, wp->titles, 0));
          xsiz = 132;
          wp = wlist;
          wp->colwidth = 1;
          /*f_x = */cur_x = X0;
          /*f_y = */cur_y = Y0;
          width = 2 * wp->wi_mf.wwords;
          wimfptr = ((char *) (wp-> wi_mf.ptr)) - 2;
          moffincx = wp->m_off + inc_x - 1;
          lineerase(wp, 0, ysiz - 1 + MAXSCROLLED);
          ++ scrolled;
          state = S_NORMAL;
          break;
        case 4:
          wp->smooth = 1;
          state = S_NORMAL;
          break;
        case 5:
          wp->fgbg[0] = 0;
          wp->fgbg[1] = (ncolors-1);
          state = S_NORMAL;
          scrolled++;  /* force a hard update */
          break;
        case 6:
          wp->origmode = 1;
          state = S_NORMAL;
          /*f_y = */cur_y = wp->val1*inc_y + wp->top_y;
          /*f_x = */cur_x = X0;
          break;
        case 7:
          wp->discard = 0;
          state = S_NORMAL;
          break;
        case 8:
          wp->repeat = 1;
          state = S_NORMAL;
          break;
        }
      }
      break;
    case S_NUM2:
      switch (ch) 
      {
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
        wp->val2 = wp->val[wp->valcnt] = (wp->val[wp->valcnt]*10) + ch - '0';
        break; 
      case ';':
        if(wp->valcnt < 8) wp->valcnt++;
        wp->val[wp->valcnt] = 0;
        break;
      case 'H':
      case 'f':
        if(wp->val1 != 0) wp->val1--;
        if(wp->val2 != 0) wp->val2--;
        if(wp->origmode) wp->val1 += wp->topline;
        if (wp->val1 > ysiz-1) wp->val1 = ysiz-1;
        if(wp->origmode && wp->val1 > wp->bottomline) wp->val1 = wp->bottomline;
        /*f_y = */cur_y = wp->val1*inc_y + wp->top_y;
        if (wp->val2 > xsiz-1) wp->val2 = xsiz-1;
        /*f_x = */cur_x = wp->val2*inc_x +X0;
        state = S_NORMAL;
        break;
      case 'r':
        /* change scrolling region */
        if(wp->val1 == 0 && wp->val2 == 0) /* empty resets to whole screen */
        {
         wp->val1 = 1;
         wp->val2 = 24;
        }
        if(wp->val1 != 0) wp->val1--;
        if(wp->val2 != 0) wp->val2--;
        wp->topline = wp->val1;
        wp->bottomline = wp->val2;
        /*f_y = */cur_y = wp->val1*inc_y + wp->top_y;
        /*f_x = */cur_x = X0;
        state = S_NORMAL;
        break;
      case 'm':
      {
        int i;
        for(i=0;i <= wp->valcnt;i++)
        {
          switch(wp->val[i])
          {
          case 0:  /* Exit Inverse */
            wp->inverse = 0;
            break;
          default:
            wp->inverse = 1;
          }
        }
        state = S_NORMAL;
        break;
      }
      default:
        state = S_NORMAL;
        break;
      }
    }  /* end switch on state */
    }
    if (scrolled >= MAXSCROLLED) 
    {
      if (wp->top_y != Y0) 
      {
        scrollup(wp, 0, ysiz, wp->top_y/inc_y);
        wp->top_y = Y0;
        /*f_y = */cur_y = Y0 + (ysiz - 1) * inc_y;
      }
      w_redraw(wp, FM_COPY, wp->x, wp->y, wp->w, wp->h);
      scrolled = 0;
    }
  }  /* end while loop for each character */

             /*
             * "scrolled" is true if you need to do a hard update, where multiple
             * lines may have changed.  This used to actually align the virtual
             * screen with the physical screen only when scrolled >= MAXSCROLLED, but
             * this meant that seven lines out of eight got hard updates for every
             * char when typing on a scrolling TTY.  So I align them every time.
             */
  if (scrolled) 
  {
    if (wp->top_y != Y0) 
    {
      scrollup(wp, 0, ysiz, wp->top_y/inc_y);
      cur_y -= (wp->top_y - Y0);
      wp->top_y = Y0;
    }
  }
  w_redraw(wp, FM_COPY, wp->x, wp->y, wp->w, wp->h);
  wp->cur_x = cur_x;
  wp->cur_y = cur_y;
  wp->state = state;
  w_flash(wp, 1);
}

void lineerase(wp, first, last)
register struct wi_str *wp;
int first, last;
{
  register short *p;
  register long *lp;
  long count;
  long linespace = wp->wi_mf.wwords*wp->font->inc_y;

  p = wp->wi_mf.ptr + first*linespace + Y0*wp->wi_mf.wwords - 1;
  count = (last-first+1)*linespace;
  lp = (long *)p;
  while (count > 7)
  {
    *lp++ = 0;
    *lp++ = 0;
    *lp++ = 0;
    *lp++ = 0;
    count -= 8;
  }
  p = (short *)lp;
  while (--count >= 0)
    *++p = 0;
}

void scrollup(wp, first, nlines, amount)
register struct wi_str *wp;
int first, nlines, amount;
{
  register short *p1, *p2;
  register long *lp1, *lp2;
  register long count;
  int linespace = wp->wi_mf.wwords*wp->font->inc_y;

  p1 = wp->wi_mf.ptr + first*linespace + Y0*wp->wi_mf.wwords;
  p2 = p1 + linespace * amount;
  count = (long)(nlines)*linespace;
  lp1 = (long *)p1;
  lp2 = (long *)p2;
  while (count > 15)
  {
    *lp1++ = *lp2++;
    *lp1++ = *lp2++;
    *lp1++ = *lp2++;
    *lp1++ = *lp2++;
    *lp1++ = *lp2++;
    *lp1++ = *lp2++;
    *lp1++ = *lp2++;
    *lp1++ = *lp2++;
    count -= 16;
  }
  p1 = (short *)lp1;
  p2 = (short *)lp2;
  while (--count >= 0)
    *(p1++) = *(p2++);
  count = linespace * amount;
  lp1 = (long *)p1;
  while (count > 7)
  {
    *lp1++ = 0;
    *lp1++ = 0;
    *lp1++ = 0;
    *lp1++ = 0;
    count -= 8;
  }
  p1 = (short *)lp1;
  while (--count >= 0)
    *(p1++) = 0;
}

void scrolldn(wp, first, nlines, amount)
register struct wi_str *wp;
int first, nlines, amount;
{
  register short *p1, *p2;
  register long *lp1, *lp2;
  register long count;
  long linespace = wp->wi_mf.wwords*wp->font->inc_y;

  p1 = wp->wi_mf.ptr + (nlines+first+amount)*linespace + Y0*wp->wi_mf.wwords;

  p2 = p1 - linespace * amount;
  count = (long)(nlines)*linespace;
  lp2 = (long *)p2;
  lp1 = (long *)p1;
  while (count > 15)
  {
    *--lp1 = *--lp2;
    *--lp1 = *--lp2;
    *--lp1 = *--lp2;
    *--lp1 = *--lp2;
    *--lp1 = *--lp2;
    *--lp1 = *--lp2;
    *--lp1 = *--lp2;
    *--lp1 = *--lp2;
    count -= 16;
  }
  p1 = (short *)lp1;
  p2 = (short *)lp2;
  while (--count >= 0)
    *--p1 = *--p2;
  count = linespace * amount;
  lp1 = (long *)p1;
  while (count > 7)
  {
    *--lp1 = 0L;
    *--lp1 = 0L;
    *--lp1 = 0L;
    *--lp1 = 0L;
    count -= 8;
  }
  p1 = (short *)lp1;
  while (--count >= 0)
    *--p1 = 0;
}
/* -------------------------------------------------------------------- */
/*       boolean rc_intersect( GRECT *r1, GRECT *r2 );                  */
/*                                                                      */
/*       Berechnung der Schnittflche zweier Rechtecke.                 */
/*                                                                      */
/*       -> r1, r2               Pointer auf Rechteckstruktur.          */
/*                                                                      */
/*       <-                      TRUE  falls sich die Rechtecke         */
/*                                     schneiden,                       */
/*                               FALSE sonst.                           */
/* -------------------------------------------------------------------- */

int rc_intersect( GRECT *r1, GRECT *r2 )
{
  int x, y, w, h;

  x = max( r2->g_x, r1->g_x );
  y = max( r2->g_y, r1->g_y );
  w = min( r2->g_x + r2->g_w, r1->g_x + r1->g_w );
  h = min( r2->g_y + r2->g_h, r1->g_y + r1->g_h );

  r2->g_x = x;
  r2->g_y = y;
  r2->g_w = w - x;
  r2->g_h = h - y;

  return (((w > x) && (h > y) ) );
}

/*------------------------------*/
/*	vt100_reset		*/
/*------------------------------*/
void vt100_reset (struct wi_str *wp)
{
  wp->repeat = 1;
  wp->curskey = 0;
  wp->keypad = 0;
  wp->topline = 0;
  wp->bottomline = wp->y_chrs-1;
  wp->colwidth = 0;
  wp->smooth = 0;
  wp->origmode = 0;
  wp->lfmode = 0;
  return;
}

