#define FALSE	0
#define TRUE	1

#define MACHINECOOKIE	0x5f4d4348L		/* "_MCH" */

int net_info(int, char *);
int net_open(int, int(*)(int,char *));
int net_release(int);
int net_send(int, char *);
int	net_getadr(int,char *);
int net_reset(void);
PKTBUF *net_pktalloc(u_short);
int net_pktfree(PKTBUF *);

int lnc_reset(void);
int read_inf(void);


#define TIMEOUT	1000	/* 100 ms timeout to get free buffer to send */
typedef struct
{
	long	st_sent;
	long	st_xmiterr;
	long	st_collision;
	long	st_got;
	long	st_received;
	long	st_missed;
	long	st_crc;
	int		st_err;
	int		st_free;
	long	st_intr;
} et_stat;

typedef struct
{
	HADDR	et_dest;
	HADDR	et_src;
	unsigned short et_type;
} et_hdr;

typedef struct
{
	int type;
	int (*handler)(int,char *);
	unsigned int recvd;
	unsigned int sent;
} PROTOCOL;



#define MAXPROTOCOLS	4
#define ET_UNUSED		0
#define ET_FREE			-1
#define ISTACKSIZE		512			/* size of interrupt stack in byte*/

typedef int (*procref)();

extern procref old_intr;
extern void (*ihandler)(void);
extern long lnc_install(long);
extern long pterm_install(long);
