/* definitions for network packet driver accessory */

#ifndef _INET_PKT
#define _INET_PKT

#define FALSE	0
#define TRUE	!FALSE

#ifndef NULL
#define NULL	( (void*) 0L )
#endif

typedef unsigned char u_char;
typedef unsigned short u_short;
typedef unsigned long u_long;


#define PKTCOOKIE	0x5f504b54L			/* "_PKT" */
#define MAXPROTOCOLS	4


#define ET_IP	0x800
#define ET_ARP	0x806
#define ET_RARP	0x8035

#define NETRESET		0
#define NETOPEN			1
#define NETRELEASE		2
#define NETSEND			3
#define NETGETADR		4
#define NETINFO			5

typedef char * (*pkt_hndl)(int,int,char *);
typedef int (*demux_handler)(void);

typedef char HADDR[6];

int net_info(int, char *);
int net_open(int, pkt_hndl);
int net_release(int);
int net_send(int, char *);
int	net_getadr(int,HADDR);
int net_reset(void);
int net_demux(int,demux_handler);
unsigned short chksum(register u_short*,u_short,u_short);

#define DEMUX	(demux_handler)0L

typedef struct
{
	HADDR		et_dest;
	HADDR		et_src;
	unsigned	et_type;
} ETH;


typedef struct
{
	ETH		pkt_head;
	char	pkt_data[1518];
} PACKET;


/* error returnvalues from packetdriver */

#define EPROTAVAIL		-1
#define EPROTUSED		-2
#define EHANDLE			-3
#define EPROTBUSY		-4
#define EINIT			-5
#define EPARAM			-6
#define EPKTLEN			-7
#define ECOLLISION		-8
#define ETIMEOUT		-9
#define ENOTINST		-10

#endif
