/********************************************************************/
/*																	*/
/*	Packet driver for D-LINK DE600 ethernet controller				*/
/*																	*/
/*	Copyleft by P. Mayer, 1993 TU-Vienna IAEE						*/
/*	All rights reserved												*/
/*																	*/
/********************************************************************/

/* queue definitions */

#ifndef _PKT_QUEUE
#define _PKT_QUEUE


typedef struct
{
	int		p_get;
	int		p_put;
	int		p_nbuf;
	struct	p_table
	{
		int		p_occupied;
		PKTBUF	*p_pkt;
	}p_tab[MAXPKT];
} PKTPOOL;


PKTBUF *p_getpkt(u_short,PKTPOOL *);			/* dequeue packet */
int p_putpkt(PKTPOOL *,PKTBUF *);				/* enqueue packet */
PKTBUF *ap_getpkt(u_short,PKTPOOL *);			/* dequeue packet atomic */
int ap_putpkt(PKTPOOL *,PKTBUF *);				/* enqueue packet atomic */
PKTPOOL *p_init(int,PKTPOOL *,PKTBUF *);		/* init queue */

#endif
